"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOnSaveNavigate = exports.useCancelAddPackagePolicy = void 0;
var _react = require("react");
var _constants = require("../../../../constants");
var _services = require("../../../../services");
var _hooks = require("../../../../hooks");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCancelAddPackagePolicy = params => {
  const {
    from,
    pkgkey,
    agentPolicyId
  } = params;
  const {
    application: {
      navigateToApp
    }
  } = (0, _hooks.useStartServices)();
  const routeState = (0, _hooks.useIntraAppState)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const cancelClickHandler = (0, _react.useCallback)(ev => {
    if (routeState !== null && routeState !== void 0 && routeState.onCancelNavigateTo) {
      ev.preventDefault();
      navigateToApp(...routeState.onCancelNavigateTo);
    }
  }, [routeState, navigateToApp]);
  const cancelUrl = (0, _react.useMemo)(() => {
    if (routeState && routeState.onCancelUrl) {
      return routeState.onCancelUrl;
    }
    return from === 'policy' && agentPolicyId ? getHref('policy_details', {
      policyId: agentPolicyId
    }) : getHref('integration_details_overview', {
      pkgkey
    });
  }, [routeState, from, agentPolicyId, getHref, pkgkey]);
  return {
    cancelClickHandler,
    cancelUrl
  };
};
exports.useCancelAddPackagePolicy = useCancelAddPackagePolicy;
const useOnSaveNavigate = params => {
  const {
    queryParamsPolicyId
  } = params;
  const routeState = (0, _hooks.useIntraAppState)();
  const doOnSaveNavigation = (0, _react.useRef)(true);
  const {
    getPath
  } = (0, _hooks.useLink)();
  const {
    application: {
      navigateToApp
    }
  } = (0, _hooks.useStartServices)();

  // Detect if user left page
  (0, _react.useEffect)(() => {
    return () => {
      doOnSaveNavigation.current = false;
    };
  }, []);
  const onSaveNavigate = (0, _react.useCallback)((policy, paramsToApply = []) => {
    if (!doOnSaveNavigation.current) {
      return;
    }
    const hasNoAgentPolicies = policy.policy_ids.length === 0;
    let onSaveNavigateTo;
    let onSaveQueryParams;
    if (routeState !== null && routeState !== void 0 && routeState.onSaveNavigateTo) {
      onSaveNavigateTo = routeState.onSaveNavigateTo;
      onSaveQueryParams = routeState === null || routeState === void 0 ? void 0 : routeState.onSaveQueryParams;
    } else {
      // If agentless or no agent policies, navigate to the integration's policies table
      if ((policy.supports_agentless || hasNoAgentPolicies) && !queryParamsPolicyId) {
        onSaveNavigateTo = [_constants.INTEGRATIONS_PLUGIN_ID, {
          path: getPath('integration_details_policies', {
            pkgkey: (0, _services.pkgKeyFromPackageInfo)(policy.package)
          })
        }];
        if (policy.supports_agentless) {
          onSaveQueryParams = {
            openEnrollmentFlyout: {
              policyIdAsValue: true
            }
          };
        } else {
          onSaveQueryParams = routeState === null || routeState === void 0 ? void 0 : routeState.onSaveQueryParams;
        }
      }
      // Otherwise, navigate to the policy's first agent policy details page
      // or the overridden policy id from query param instead
      // TODO: handle case where package policy belongs to multiple agent policies
      else {
        onSaveNavigateTo = [_constants.PLUGIN_ID, {
          path: getPath('policy_details', {
            policyId: queryParamsPolicyId || policy.policy_ids[0]
          })
        }];
        onSaveQueryParams = {
          showAddAgentHelp: true,
          openEnrollmentFlyout: true
        };
      }
    }
    const [appId, options] = onSaveNavigateTo;
    if (options !== null && options !== void 0 && options.path) {
      const pathWithQueryString = (0, _utils.appendOnSaveQueryParamsToPath)({
        path: options.path,
        policy,
        mappingOptions: onSaveQueryParams,
        paramsToApply
      });
      navigateToApp(appId, {
        ...options,
        path: pathWithQueryString
      });
    } else {
      navigateToApp(...onSaveNavigateTo);
    }
  }, [getPath, routeState === null || routeState === void 0 ? void 0 : routeState.onSaveNavigateTo, routeState === null || routeState === void 0 ? void 0 : routeState.onSaveQueryParams, queryParamsPolicyId, navigateToApp]);
  return onSaveNavigate;
};
exports.useOnSaveNavigate = useOnSaveNavigate;