"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = void 0;
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getMetricColumn = (metricAccessor, visData) => {
  return (0, _chartExpressionsCommon.getColumnByAccessor)(metricAccessor, visData.columns);
};
const getColumns = (dimensions, visData) => {
  const {
    metric,
    buckets
  } = dimensions;
  if (buckets.length > 0) {
    const bucketColumns = buckets.map(bucket => {
      const column = (0, _chartExpressionsCommon.getColumnByAccessor)(bucket, visData.columns);
      return {
        ...column,
        format: (0, _chartExpressionsCommon.getFormatByAccessor)(bucket, visData.columns)
      };
    });
    const lastBucketId = bucketColumns[bucketColumns.length - 1].id;
    const matchingIndex = visData.columns.findIndex(col => col.id === lastBucketId);
    return {
      bucketColumns,
      metricColumn: getMetricColumn(metric !== null && metric !== void 0 ? metric : {
        accessor: matchingIndex + 1,
        type: 'vis_dimension',
        format: {}
      }, visData)
    };
  }
  const metricColumn = getMetricColumn(metric !== null && metric !== void 0 ? metric : {
    accessor: 0,
    type: 'vis_dimension',
    format: {}
  }, visData);
  return {
    metricColumn,
    bucketColumns: [{
      name: metricColumn.name
    }]
  };
};
exports.getColumns = getColumns;