"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFunctionArgumentHover = getFunctionArgumentHover;
var _i18n = require("@kbn/i18n");
var _esqlAst = require("@kbn/esql-ast");
var _utils = require("@kbn/esql-ast/src/definitions/utils");
var _types = require("@kbn/esql-ast/src/types");
var _hover_cache = require("./hover_cache");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TIME_SYSTEM_DESCRIPTIONS = {
  '?_tstart': _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.timeSystemParamStart', {
    defaultMessage: 'The start time from the date picker'
  }),
  '?_tend': _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.timeSystemParamEnd', {
    defaultMessage: 'The end time from the date picker'
  })
};

// Find the argument that contains the cursor offset
const findArgumentAtOffset = (args, targetOffset) => {
  for (const arg of args) {
    if (Array.isArray(arg)) {
      const found = findArgumentAtOffset(arg, targetOffset);
      if (found) return found;
    } else if ('location' in arg && arg.location && (0, _esqlAst.within)(targetOffset, arg)) {
      return arg;
    }
  }
  return null;
};
async function getFunctionArgumentHover(fnNode, offset) {
  const fnDefinition = (0, _utils.getFunctionDefinition)(fnNode.name);
  if (!fnDefinition) {
    return [];
  }
  const argumentAtOffset = findArgumentAtOffset(fnNode.args || [], offset);
  if (!argumentAtOffset) {
    return [];
  }
  const argIdentifier = 'name' in argumentAtOffset ? argumentAtOffset.name : 'unknown';
  // Use function name + argument identifier as cache key
  const cacheKey = `${fnNode.name}:${argIdentifier}`;
  const cached = (0, _hover_cache.fromCache)(cacheKey);
  if (cached) {
    return cached;
  }
  const contents = [];
  if (argumentAtOffset && (0, _types.isESQLNamedParamLiteral)(argumentAtOffset)) {
    const bestMatch = _esqlAst.TIME_SYSTEM_PARAMS.find(p => p.startsWith(argumentAtOffset.text));
    // We only know if it's start or end after first 3 characters (?t_s or ?t_e)
    if (argumentAtOffset.text.length > 3 && bestMatch) {
      Object.entries(TIME_SYSTEM_DESCRIPTIONS).forEach(([key, value]) => {
        contents.push({
          value: `**${key}**: ${value}`
        });
      });
    }
  }
  (0, _hover_cache.setToCache)(cacheKey, contents);
  return contents;
}