"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildQueryAst = void 0;
var _esqlAst = require("@kbn/esql-ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const buildQueryAst = source => {
  const {
    root,
    commands
  } = source;
  const queryAst = _esqlAst.Builder.expression.query([...root.commands]);
  for (const command of commands) {
    _esqlAst.mutate.generic.commands.append(queryAst, command);
  }
  return queryAst;
};
exports.buildQueryAst = buildQueryAst;