"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortOrder = void 0;
exports.sort = sort;
var _append = require("../pipeline/append");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let SortOrder = exports.SortOrder = /*#__PURE__*/function (SortOrder) {
  SortOrder["Asc"] = "ASC";
  SortOrder["Desc"] = "DESC";
  return SortOrder;
}({});
/**
 * Appends a `SORT` command to the ESQL composer pipeline.
 *
 * @param sorts The sort criteria.
 * @returns A `QueryPipeline` instance with the `SORT` command appended.
 */
function sort(firstArg, secondArg, ...restSorts) {
  if (typeof firstArg === 'string' && firstArg.includes('?')) {
    return (0, _append.append)({
      command: `SORT ${firstArg}`,
      params: secondArg
    });
  }
  const allSorts = [firstArg, ...(secondArg !== undefined ? [secondArg] : []), ...restSorts].flatMap(sortInstruction => sortInstruction).map(sortInstruction => {
    if (typeof sortInstruction === 'string') {
      return {
        column: sortInstruction,
        order: SortOrder.Asc
      };
    }
    const column = Object.keys(sortInstruction)[0];
    return {
      column,
      order: sortInstruction[column]
    };
  });
  const command = `SORT ${allSorts.map(sortInstruction => `${sortInstruction.column} ${sortInstruction.order}`).join(', ')}`;
  return (0, _append.append)({
    command
  });
}