"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggFunctionDefinitions = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../../commands_registry/types");
var _types2 = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * __AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.__
 *
 * @note This file is generated by the `generate_function_definitions.ts`
 * script. Do not edit it manually.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const absentDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'absent',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.absent', {
    defaultMessage: 'Returns true if the input expression yields no non-null values within the current aggregation context. Otherwise it returns false.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'aggregate_metric_double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geohash',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geohex',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geotile',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| WHERE emp_no == 10020\n| STATS is_absent = ABSENT(languages)', 'FROM employees\n| STATS is_absent = ABSENT(salary) BY languages', 'FROM employees\n| WHERE emp_no == 10020\n| STATS is_absent = TO_INTEGER(ABSENT(languages))']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const avgDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'avg',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.avg', {
    defaultMessage: 'The average of a numeric field.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'aggregate_metric_double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS AVG(height)', 'FROM employees\n| STATS avg_salary_change = ROUND(AVG(MV_AVG(salary_change)), 10)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const countDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'count',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.count', {
    defaultMessage: 'Returns the total number (count) of input values.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'aggregate_metric_double',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'geohash',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'geohex',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'geotile',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: true
    }],
    returnType: 'long'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS COUNT(height)', 'FROM employees\n| STATS count = COUNT(*) BY languages\n| SORT languages DESC', 'ROW words="foo;bar;baz;qux;quux;foo"\n| STATS word_count = COUNT(SPLIT(words, ";"))', 'ROW n=1\n| WHERE n < 0\n| STATS COUNT(n)', 'ROW n=1\n| STATS COUNT(n > 0 OR NULL), COUNT(n < 0 OR NULL)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const countDistinctDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'count_distinct',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.count_distinct', {
    defaultMessage: 'Returns the approximate number of distinct values.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'long'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM hosts\n| STATS COUNT_DISTINCT(ip0), COUNT_DISTINCT(ip1)', 'FROM hosts\n| STATS COUNT_DISTINCT(ip0, 80000), COUNT_DISTINCT(ip1, 5)', 'ROW words="foo;bar;baz;qux;quux;foo"\n| STATS distinct_word_count = COUNT_DISTINCT(SPLIT(words, ";"))']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const firstDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'first',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.first', {
    defaultMessage: 'Calculates the earliest value of a field.'
  }),
  ignoreAsSuggestion: true,
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'value',
      type: 'double',
      optional: false
    }, {
      name: 'sort',
      type: 'date',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'value',
      type: 'double',
      optional: false
    }, {
      name: 'sort',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'value',
      type: 'integer',
      optional: false
    }, {
      name: 'sort',
      type: 'date',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'value',
      type: 'integer',
      optional: false
    }, {
      name: 'sort',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'value',
      type: 'keyword',
      optional: false
    }, {
      name: 'sort',
      type: 'date',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'value',
      type: 'keyword',
      optional: false
    }, {
      name: 'sort',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'value',
      type: 'long',
      optional: false
    }, {
      name: 'sort',
      type: 'date',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'value',
      type: 'long',
      optional: false
    }, {
      name: 'sort',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'value',
      type: 'text',
      optional: false
    }, {
      name: 'sort',
      type: 'date',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'value',
      type: 'text',
      optional: false
    }, {
      name: 'sort',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'keyword'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM k8s\n| STATS first_bytes_in = FIRST(network.bytes_in, @timestamp) BY pod\n| SORT pod ASC']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const lastDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'last',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.last', {
    defaultMessage: 'Calculates the latest value of a field.'
  }),
  ignoreAsSuggestion: true,
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'value',
      type: 'double',
      optional: false
    }, {
      name: 'sort',
      type: 'date',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'value',
      type: 'double',
      optional: false
    }, {
      name: 'sort',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'value',
      type: 'integer',
      optional: false
    }, {
      name: 'sort',
      type: 'date',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'value',
      type: 'integer',
      optional: false
    }, {
      name: 'sort',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'value',
      type: 'keyword',
      optional: false
    }, {
      name: 'sort',
      type: 'date',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'value',
      type: 'keyword',
      optional: false
    }, {
      name: 'sort',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'value',
      type: 'long',
      optional: false
    }, {
      name: 'sort',
      type: 'date',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'value',
      type: 'long',
      optional: false
    }, {
      name: 'sort',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'value',
      type: 'text',
      optional: false
    }, {
      name: 'sort',
      type: 'date',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'value',
      type: 'text',
      optional: false
    }, {
      name: 'sort',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'keyword'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM k8s\n| STATS last_bytes_in = LAST(network.bytes_in, @timestamp) BY pod\n| SORT pod ASC']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const maxDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'max',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.max', {
    defaultMessage: 'The maximum value of a field.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'aggregate_metric_double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'version'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS MAX(languages)', 'FROM employees\n| STATS max_avg_salary_change = MAX(MV_AVG(salary_change))']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const medianDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'median',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.median', {
    defaultMessage: 'The value that is greater than half of all values and less than half of all values, also known as the 50% `PERCENTILE`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS MEDIAN(salary), PERCENTILE(salary, 50)', 'FROM employees\n| STATS median_max_salary_change = MEDIAN(MV_MAX(salary_change))']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const medianAbsoluteDeviationDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'median_absolute_deviation',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.median_absolute_deviation', {
    defaultMessage: 'Returns the median absolute deviation, a measure of variability. It is a robust statistic, meaning that it is useful for describing data that may have outliers, or may not be normally distributed. For such data it can be more descriptive than standard deviation.\n\nIt is calculated as the median of each data point’s deviation from the median of the entire sample. That is, for a random variable `X`, the median absolute deviation is `median(|median(X) - X|)`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS MEDIAN(salary), MEDIAN_ABSOLUTE_DEVIATION(salary)', 'FROM employees\n| STATS m_a_d_max_salary_change = MEDIAN_ABSOLUTE_DEVIATION(MV_MAX(salary_change))']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const minDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'min',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.min', {
    defaultMessage: 'The minimum value of a field.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'aggregate_metric_double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'version'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS MIN(languages)', 'FROM employees\n| STATS min_avg_salary_change = MIN(MV_AVG(salary_change))']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const percentileDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'percentile',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.percentile', {
    defaultMessage: 'Returns the value at which a certain percentage of observed values occur. For example, the 95th percentile is the value which is greater than 95% of the observed values and the 50th percentile is the `MEDIAN`.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'percentile',
      type: 'double',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'percentile',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'percentile',
      type: 'long',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'percentile',
      type: 'double',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'percentile',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'percentile',
      type: 'long',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'percentile',
      type: 'double',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'percentile',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'percentile',
      type: 'long',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS p0 = PERCENTILE(salary,  0)\n     , p50 = PERCENTILE(salary, 50)\n     , p99 = PERCENTILE(salary, 99)', 'FROM employees\n| STATS p80_max_salary_change = PERCENTILE(MV_MAX(salary_change), 80)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const presentDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'present',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.present', {
    defaultMessage: 'Returns true if the input expression yields any non-null values within the current aggregation context. Otherwise it returns false.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'aggregate_metric_double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geohash',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geohex',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geotile',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS is_present = PRESENT(languages)', 'FROM employees\n| STATS is_present = PRESENT(salary) BY languages', 'FROM employees\n| WHERE emp_no == 10020\n| STATS is_present = TO_INTEGER(PRESENT(languages))']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const sampleDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'sample',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.sample', {
    defaultMessage: 'Collects sample values for a field.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'cartesian_point'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'cartesian_shape'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'geo_point'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'geo_shape'
  }, {
    params: [{
      name: 'field',
      type: 'geohash',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'geohash'
  }, {
    params: [{
      name: 'field',
      type: 'geohex',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'geohex'
  }, {
    params: [{
      name: 'field',
      type: 'geotile',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'geotile'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false
    }],
    returnType: 'version'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS sample = SAMPLE(gender, 5)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stCentroidAggDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'st_centroid_agg',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_centroid_agg', {
    defaultMessage: 'Calculate the spatial centroid over a field with spatial point geometry type.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'cartesian_point'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'geo_point'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM airports\n| STATS centroid=ST_CENTROID_AGG(location)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stExtentAggDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'st_extent_agg',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.st_extent_agg', {
    defaultMessage: 'Calculate the spatial extent over a field with geometry type. Returns a bounding box for all values of the field.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'cartesian_shape'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }],
    license: 'platinum',
    returnType: 'cartesian_shape'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'geo_shape'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }],
    license: 'platinum',
    returnType: 'geo_shape'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM airports\n| WHERE country == "India"\n| STATS extent = ST_EXTENT_AGG(location)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stdDevDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'std_dev',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.std_dev', {
    defaultMessage: 'The population standard deviation of a numeric field.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS std_dev_height = STD_DEV(height)', 'FROM employees\n| STATS stddev_salary_change = STD_DEV(MV_MAX(salary_change))']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const sumDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'sum',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.sum', {
    defaultMessage: 'The sum of a numeric expression.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'aggregate_metric_double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS SUM(languages)', 'FROM employees\n| STATS total_salary_changes = SUM(MV_MAX(salary_change))']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const topDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'top',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.top', {
    defaultMessage: 'Collects the top values for a field. Includes repeated values.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'date',
      optional: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'double',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'integer',
      optional: true
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'date',
      optional: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'double',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'integer',
      optional: true
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'date',
      optional: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'double',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'integer',
      optional: true
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'date',
      optional: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'double',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'integer',
      optional: true
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }, {
      name: 'outputField',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }, {
      name: 'limit',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'order',
      type: 'keyword',
      optional: true,
      constantOnly: true,
      suggestedValues: ['asc', 'desc']
    }],
    returnType: 'keyword'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS top_salaries = TOP(salary, 3, "desc"), top_salary = MAX(salary)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const valuesDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'values',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.values', {
    defaultMessage: 'Returns unique values as a multivalued field. The order of the returned values isn’t guaranteed.\nIf you need the values returned in order use\n`MV_SORT`.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'cartesian_point'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'cartesian_shape'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'geo_point'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'geo_shape'
  }, {
    params: [{
      name: 'field',
      type: 'geohash',
      optional: false
    }],
    returnType: 'geohash'
  }, {
    params: [{
      name: 'field',
      type: 'geohex',
      optional: false
    }],
    returnType: 'geohex'
  }, {
    params: [{
      name: 'field',
      type: 'geotile',
      optional: false
    }],
    returnType: 'geotile'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'version'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| EVAL first_letter = SUBSTRING(first_name, 0, 1)\n| STATS first_name = MV_SORT(VALUES(first_name)) BY first_letter\n| SORT first_letter']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const varianceDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'variance',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.variance', {
    defaultMessage: 'The population variance of a numeric field.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS var_height = VARIANCE(height)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const weightedAvgDefinition = {
  type: _types2.FunctionDefinitionTypes.AGG,
  name: 'weighted_avg',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.weighted_avg', {
    defaultMessage: 'The weighted average of a numeric expression.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'weight',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'weight',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'weight',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'weight',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'weight',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'weight',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'weight',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'weight',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'weight',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS],
  examples: ['FROM employees\n| STATS w_avg = WEIGHTED_AVG(salary, height) BY languages\n| EVAL w_avg = ROUND(w_avg)\n| KEEP w_avg, languages\n| SORT languages']
};
const aggFunctionDefinitions = exports.aggFunctionDefinitions = [absentDefinition, avgDefinition, countDefinition, countDistinctDefinition, firstDefinition, lastDefinition, maxDefinition, medianDefinition, medianAbsoluteDeviationDefinition, minDefinition, percentileDefinition, presentDefinition, sampleDefinition, stCentroidAggDefinition, stExtentAggDefinition, stdDevDefinition, sumDefinition, topDefinition, valuesDefinition, varianceDefinition, weightedAvgDefinition];