"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = void 0;
var _utils = require("../../../definitions/utils");
var _settings = require("../../../definitions/generated/settings");
var _is = require("../../../ast/is");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const validate = (command, commands) => {
  const messages = [];
  const settingNameIdentifier = getSettingNameIdentifier(command);
  if (!settingNameIdentifier) {
    return [];
  }

  // Find the setting definition
  const setting = _settings.settings.find(s => s.name === settingNameIdentifier.text);

  // Check if setting exists
  if (!setting) {
    messages.push((0, _utils.getMessageFromId)({
      messageId: 'unknownSetting',
      values: {
        name: settingNameIdentifier.text
      },
      locations: settingNameIdentifier.location
    }));
    return messages;
  }
  return messages;
};
exports.validate = validate;
function getSettingNameIdentifier(command) {
  const settingArg = command.args[0];
  if (!(0, _is.isBinaryExpression)(settingArg)) {
    return null;
  }
  const settingName = settingArg.args[0];
  if (!(0, _is.isIdentifier)(settingName)) {
    return null;
  }
  return settingName;
}