"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = void 0;
var _walker = require("../../../walker");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const REQUIRED_METADATA_FIELDS = ['_id', '_index', '_score'];
const validate = (command, ast, context) => {
  const messages = [];
  const missingFields = [...REQUIRED_METADATA_FIELDS];
  const sourceCommand = ast.find(_command => ['ts', 'from'].includes(_command.name.toLocaleLowerCase()));
  if (sourceCommand) {
    (0, _walker.walk)(sourceCommand, {
      visitCommandOption: node => {
        if (node.name.toLocaleLowerCase() === 'metadata') {
          const metadataFields = node.args.map(arg => {
            var _name;
            return arg === null || arg === void 0 ? void 0 : (_name = arg.name) === null || _name === void 0 ? void 0 : _name.toLocaleLowerCase();
          });
          for (const field of REQUIRED_METADATA_FIELDS) {
            if (metadataFields.includes(field)) {
              missingFields.splice(missingFields.indexOf(field), 1);
            }
          }
        }
      }
    });
  }
  if (missingFields.length > 0) {
    messages.push((0, _utils.buildMissingMetadataMessage)(command, missingFields.join(', ')));
  }
  return messages;
};
exports.validate = validate;