"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _is = require("../../../ast/is");
var _location = require("../../../ast/location");
var _ast = require("../../../definitions/utils/ast");
var _expressions = require("../../../definitions/utils/autocomplete/expressions");
var _utils = require("../../../definitions/utils");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _expressions2 = require("../../../definitions/utils/expressions");
var _complete_items = require("../../complete_items");
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition = query.length) {
  if (!(callbacks !== null && callbacks !== void 0 && callbacks.getByType)) {
    return [];
  }
  const innerText = query.substring(0, cursorPosition);
  const lastArg = command.args[command.args.length - 1];
  const startingNewExpression =
  // ends with a comma
  /,\s*$/.test(innerText) && lastArg &&
  // and we aren't within a function
  !((0, _is.isFunctionExpression)(lastArg) && (0, _location.within)(innerText.length, lastArg));
  let expressionRoot = startingNewExpression ? undefined : lastArg;
  let insideAssignment = false;
  if (expressionRoot && (0, _is.isAssignment)(expressionRoot)) {
    // EVAL foo = <use this as the expression root>
    expressionRoot = expressionRoot.args[1][0];
    insideAssignment = true;
    if ((0, _ast.isMarkerNode)(expressionRoot)) {
      expressionRoot = undefined;
    }
  }
  const suggestions = await (0, _utils.suggestForExpression)({
    query,
    expressionRoot,
    command,
    cursorPosition,
    location: _types.Location.EVAL,
    context,
    callbacks,
    options: {
      preferredExpressionType: 'any'
    }
  });
  const positionInExpression = (0, _expressions.getExpressionPosition)(query, expressionRoot);
  if (positionInExpression === 'empty_expression' && !insideAssignment) {
    var _callbacks$getSuggest;
    suggestions.push((0, _complete_items.getNewUserDefinedColumnSuggestion)((callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getSuggest = callbacks.getSuggestedUserDefinedColumnName) === null || _callbacks$getSuggest === void 0 ? void 0 : _callbacks$getSuggest.call(callbacks)) || ''));
  }
  const insideFunction = lastArg && (0, _is.isFunctionExpression)(lastArg) && (0, _location.within)(cursorPosition || 0, lastArg);
  const expressionType = (0, _expressions2.getExpressionType)(expressionRoot, context === null || context === void 0 ? void 0 : context.columns);
  if (
  // don't suggest finishing characters if incomplete expression
  (0, _expressions2.isExpressionComplete)(expressionType, innerText) &&
  // don't suggest finishing characters if the expression is a column
  // because "EVAL columnName" is a useless expression
  expressionRoot && (!(0, _is.isColumn)(expressionRoot) || insideAssignment) &&
  // don't suggest finishing characters if we're inside a function
  !insideFunction) {
    suggestions.push((0, _helpers.withAutoSuggest)(_complete_items.pipeCompleteItem), (0, _helpers.withAutoSuggest)({
      ..._complete_items.commaCompleteItem,
      text: ', '
    }));
  }
  return suggestions;
}