"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterStateStore = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
  Filter,
 * An enum to denote whether a filter is specific to an application's context or whether it should be applied globally.
 * @public
 */
let FilterStateStore = exports.FilterStateStore = /*#__PURE__*/function (FilterStateStore) {
  FilterStateStore["APP_STATE"] = "appState";
  FilterStateStore["GLOBAL_STATE"] = "globalState";
  return FilterStateStore;
}({});