"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InlineEditableTableContents = exports.InlineEditableTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _page_introduction = require("../../page_introduction/page_introduction");
var _reorderable_table = require("../reorderable_table");
var _get_updated_columns = require("./get_updated_columns");
var _inline_editable_table_logic = require("./inline_editable_table_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/shared/tables/inline_editable_table/inline_editable_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InlineEditableTable = props => {
  const {
    instanceId,
    columns,
    defaultItem,
    onAdd,
    onDelete,
    onReorder,
    onUpdate,
    transformItem,
    validateItem,
    ...rest
  } = props;
  return /*#__PURE__*/_react.default.createElement(_kea.BindLogic, {
    logic: _inline_editable_table_logic.InlineEditableTableLogic,
    props: {
      instanceId,
      columns,
      defaultItem,
      onAdd,
      onDelete,
      onReorder,
      onUpdate,
      transformItem,
      validateItem
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(InlineEditableTableContents, (0, _extends2.default)({}, rest, {
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  })));
};
exports.InlineEditableTable = InlineEditableTable;
const InlineEditableTableContents = ({
  columns,
  emptyPropertyAllowed,
  items,
  title,
  addButtonText,
  canRemoveLastItem,
  className,
  description,
  isLoading,
  lastItemWarning,
  noItemsMessage = () => null,
  uneditableItems,
  ...rest
}) => {
  const {
    editingItemId,
    isEditing,
    isEditingUnsavedItem,
    rowErrors
  } = (0, _kea.useValues)(_inline_editable_table_logic.InlineEditableTableLogic);
  const {
    editNewItem,
    reorderItems
  } = (0, _kea.useActions)(_inline_editable_table_logic.InlineEditableTableLogic);

  // A11y - restore focus when editing ends
  const prevFocusRef = (0, _react.useRef)(null);
  (0, _eui.useUpdateEffect)(() => {
    if (!isEditing && prevFocusRef.current) {
      prevFocusRef.current.focus();
      prevFocusRef.current = null;
    }
  }, [isEditing]);
  const handleEditNewItem = () => {
    prevFocusRef.current = document.activeElement;
    editNewItem();
  };

  // TODO These two things shoud just be selectors
  const isEditingItem = item => item.id === editingItemId;
  const isActivelyEditing = item => isEditing && isEditingItem(item);
  const emptyItem = {
    id: null
  };
  const displayedItems = isEditingUnsavedItem ? uneditableItems ? [emptyItem, ...items] : [...items, emptyItem] : items;
  const updatedColumns = (0, _get_updated_columns.getUpdatedColumns)({
    columns,
    displayedItems,
    emptyPropertyAllowed,
    isActivelyEditing,
    canRemoveLastItem,
    isLoading,
    lastItemWarning,
    prevFocusRef,
    uneditableItems
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_introduction.PageIntroduction, {
    description: description || '',
    title: title || '',
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      iconType: "plusInCircle",
      disabled: isEditing,
      onClick: handleEditNewItem,
      color: "primary",
      "data-test-subj": "inlineEditableTableActionButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 11
      }
    }, addButtonText || _i18n.i18n.translate('xpack.enterpriseSearch.inlineEditableTable.newRowButtonLabel', {
      defaultMessage: 'New row'
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_reorderable_table.ReorderableTable, (0, _extends2.default)({
    className: (0, _classnames.default)(className, 'editableTable'),
    items: displayedItems,
    unreorderableItems: uneditableItems,
    columns: updatedColumns,
    rowProps: item => ({
      className: (0, _classnames.default)({
        'is-being-edited': isActivelyEditing(item)
      })
    }),
    rowErrors: item => isActivelyEditing(item) ? rowErrors : undefined,
    noItemsMessage: noItemsMessage(handleEditNewItem),
    onReorder: reorderItems,
    disableDragging: isEditing
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 7
    }
  })));
};
exports.InlineEditableTableContents = InlineEditableTableContents;