"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WhatsNextBox = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchConnectors = require("@kbn/search-connectors");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _routes = require("../../../routes");
var _syncs_context_menu = require("../../shared/header_actions/syncs_context_menu");
var _connector_detail = require("../connector_detail");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/connector_detail/components/whats_next_box.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WhatsNextBox = ({
  connectorId,
  connectorIndex,
  connectorStatus,
  disabled = false,
  isSyncing = false,
  isWaitingForConnector = false
}) => {
  const {
    share
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const onStartPlaygroundClick = (0, _react.useCallback)(() => {
    if (!share) return;
    const playgroundLocator = share.url.locators.get('PLAYGROUND_LOCATOR_ID');
    if (playgroundLocator) {
      playgroundLocator.navigate({
        'default-index': connectorIndex
      });
    }
  }, [connectorIndex, share]);
  const isConfigured = !(connectorStatus === _searchConnectors.ConnectorStatus.NEEDS_CONFIGURATION || connectorStatus === _searchConnectors.ConnectorStatus.CREATED);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    style: {
      position: 'relative'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, isSyncing && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    position: "absolute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.whatsNextBox.whatsNextPanelLabel', {
    defaultMessage: "What's next?"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.whatsNextBox.whatsNextPanelDescription', {
    defaultMessage: 'You can manually sync your data, schedule a recurring sync or see your documents.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchWhatsNextBoxSearchPlaygroundButton",
    iconType: "sparkles",
    disabled: !connectorIndex || disabled,
    onClick: onStartPlaygroundClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.whatsNextBox.searchPlaygroundButtonLabel",
    defaultMessage: "Search Playground",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    "data-test-subj": "entSearchContent-connector-configuration-setScheduleAndSync",
    "data-telemetry-id": "entSearchContent-connector-configuration-setScheduleAndSync",
    isDisabled: isWaitingForConnector || !connectorIndex || !isConfigured,
    to: `${(0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
      connectorId,
      tabId: _connector_detail.ConnectorDetailTabId.SCHEDULING
    })}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.schedule.button.label', {
    defaultMessage: 'Set schedule and sync'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_syncs_context_menu.SyncsContextMenu, {
    disabled: isWaitingForConnector || !connectorIndex || !isConfigured,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 15
    }
  }))))));
};
exports.WhatsNextBox = WhatsNextBox;