"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationIndices = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../shared/constants");
var _health_colors = require("../../../shared/constants/health_colors");
var _kibana = require("../../../shared/kibana");
var _telemetry_logic = require("../../../shared/telemetry/telemetry_logic");
var _search_application_indices_logic = require("./search_application_indices_logic");
var _search_application_view_index_link = require("./search_application_view_index_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_application/search_application_indices.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchApplicationIndices = () => {
  const subduedBackground = (0, _eui.useEuiBackgroundColor)('subdued');
  const {
    sendEnterpriseSearchTelemetry
  } = (0, _kea.useActions)(_telemetry_logic.TelemetryLogic);
  const {
    searchApplicationData
  } = (0, _kea.useValues)(_search_application_indices_logic.SearchApplicationIndicesLogic);
  const {
    removeIndexFromSearchApplication
  } = (0, _kea.useActions)(_search_application_indices_logic.SearchApplicationIndicesLogic);
  const {
    navigateToUrl,
    share
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const [removeIndexConfirm, setConfirmRemoveIndex] = (0, _react.useState)(null);
  const searchIndicesLocator = (0, _react.useMemo)(() => share === null || share === void 0 ? void 0 : share.url.locators.get('SEARCH_INDEX_DETAILS_LOCATOR_ID'), [share]);
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  if (!searchApplicationData) return null;
  const {
    indices
  } = searchApplicationData;
  const hasAllUnreachableIndices = indices.every(({
    health
  }) => health === 'unknown');
  const hasUnknownIndices = indices.some(({
    health
  }) => health === 'unknown');
  const removeIndexAction = {
    color: 'danger',
    'data-test-subj': 'search-application-remove-index-btn',
    description: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.actions.removeIndex.title', {
      defaultMessage: 'Remove this index from search application'
    }),
    icon: 'minusInCircle',
    isPrimary: false,
    name: index => _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.actions.removeIndex.caption', {
      defaultMessage: 'Remove index {indexName}',
      values: {
        indexName: index.name
      }
    }),
    onClick: index => {
      setConfirmRemoveIndex(index.name);
      sendEnterpriseSearchTelemetry({
        action: 'clicked',
        metric: 'entSearchApplications-indices-removeIndex'
      });
    },
    type: 'icon'
  };
  const columns = [{
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.name.columnTitle', {
      defaultMessage: 'Index name'
    }),
    render: ({
      health,
      name
    }) => health === 'unknown' ? name : /*#__PURE__*/_react.default.createElement(_search_application_view_index_link.SearchApplicationViewIndexLink, {
      indexName: name,
      dataTestSubj: "search-application-index-link",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 11
      }
    }),
    sortable: ({
      name
    }) => name,
    truncateText: true,
    width: '40%'
  }, {
    field: 'health',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.health.columnTitle', {
      defaultMessage: 'Index health'
    }),
    render: health => /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot",
      color: (0, _health_colors.indexHealthToHealthColor)(health),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }), "\xA0", health !== null && health !== void 0 ? health : '-'),
    sortable: true,
    truncateText: true,
    width: '15%'
  }, {
    field: 'count',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.docsCount.columnTitle', {
      defaultMessage: 'Docs count'
    }),
    render: count => count === null ? _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.docsCount.notAvailableLabel', {
      defaultMessage: 'N/A'
    }) : count,
    sortable: true,
    truncateText: true,
    width: '15%'
  }, {
    actions: [{
      enabled: () => searchIndicesLocator !== undefined,
      available: index => index.health !== 'unknown',
      'data-test-subj': 'search-application-view-index-btn',
      description: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.actions.viewIndex.title', {
        defaultMessage: 'View this index'
      }),
      icon: 'eye',
      isPrimary: false,
      name: index => _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.actions.viewIndex.caption', {
        defaultMessage: 'View index {indexName}',
        values: {
          indexName: index.name
        }
      }),
      onClick: async index => {
        if (searchIndicesLocator) {
          const url = await searchIndicesLocator.getUrl({
            indexName: index.name
          });
          navigateToUrl(url, {
            shouldNotCreateHref: true,
            shouldNotPrepend: true
          });
        } else {
          return undefined;
        }
      },
      type: 'icon'
    }, ...(indices.length > 1 ? [removeIndexAction] : [])],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.actions.columnTitle', {
      defaultMessage: 'Actions'
    }),
    width: '10%'
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (hasAllUnreachableIndices || hasUnknownIndices) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "warning",
    iconType: "warning",
    title: hasAllUnreachableIndices ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.allUnknownIndicesCallout.title', {
      defaultMessage: 'All of your indices are unavailable.'
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.someUnknownIndicesCallout.title', {
      defaultMessage: 'Some of your indices are unavailable.'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 13
    }
  }, hasAllUnreachableIndices ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.allUnknownIndicesCallout.description', {
    defaultMessage: 'Your search application has no reachable indices. Add some indices and check for any pending operations or errors on affected indices, or remove indices that should no longer be used by this search application.'
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.someUnknownIndicesCallout.description', {
    defaultMessage: 'Some data might be unreachable from this search application. Check for any pending operations or errors on affected indices, or remove indices that should no longer be used by this search application.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: indices,
    columns: columns,
    rowProps: index => {
      if (index.health === 'unknown') {
        return {
          style: {
            backgroundColor: subduedBackground
          }
        };
      }
      return {};
    },
    search: {
      box: {
        incremental: true,
        placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.searchPlaceholder', {
          defaultMessage: 'Filter indices'
        }),
        schema: true
      }
    },
    pagination: true,
    sorting: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 7
    }
  }), removeIndexConfirm !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    onCancel: () => setConfirmRemoveIndex(null),
    onConfirm: () => {
      removeIndexFromSearchApplication(removeIndexConfirm);
      setConfirmRemoveIndex(null);
      sendEnterpriseSearchTelemetry({
        action: 'clicked',
        metric: 'entSearchApplications-indices-removeIndexConfirm'
      });
    },
    title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.removeIndexConfirm.title', {
      defaultMessage: 'Remove this index from the search application'
    }),
    "aria-labelledby": confirmModalTitleId,
    titleProps: {
      id: confirmModalTitleId
    },
    buttonColor: "danger",
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.removeIndexConfirm.text', {
      defaultMessage: 'Yes, Remove This Index'
    }),
    defaultFocusedButton: "confirm",
    maxWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.removeIndexConfirm.description', {
    defaultMessage: "This won't delete the index. You may add it back to this search application at a later time."
  })))));
};
exports.SearchApplicationIndices = SearchApplicationIndices;