"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMessageFieldWithFallbacks = void 0;
var _ = require("..");
var _get_log_field_with_fallback = require("./get_log_field_with_fallback");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const rankingOrder = [_.fieldConstants.MESSAGE_FIELD, _.fieldConstants.ERROR_MESSAGE_FIELD, _.fieldConstants.EVENT_ORIGINAL_FIELD, _.fieldConstants.EXCEPTION_MESSAGE_FIELD, _.fieldConstants.ERROR_EXCEPTION_MESSAGE, _.fieldConstants.OTEL_ATTRIBUTES_EXCEPTION_MESSAGE];
const getMessageFieldWithFallbacks = (doc, {
  includeFormattedValue = false
} = {}) => {
  return (0, _get_log_field_with_fallback.getLogFieldWithFallback)(doc, rankingOrder, includeFormattedValue);
};
exports.getMessageFieldWithFallbacks = getMessageFieldWithFallbacks;