"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchProviderFind = void 0;
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _esqlUtils = require("@kbn/esql-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const searchProviderFind = async ({
  isESQLEnabled,
  locator,
  getServices
}, {
  term = '',
  types,
  tags
}) => {
  if (tags || types && !types.includes('application') || !locator || !isESQLEnabled) {
    return [];
  }
  const [core, {
    dataViews
  }] = await getServices();
  if (!core.application.capabilities.navLinks.discover) {
    return [];
  }
  const title = _i18n.i18n.translate('discover.globalSearch.esqlSearchTitle', {
    defaultMessage: 'Create ES|QL queries',
    description: 'ES|QL is a product name and should not be translated'
  });
  const defaultDataView = await dataViews.getDefaultDataView({
    displayErrors: false
  });
  if (!defaultDataView) {
    return [];
  }
  const params = {
    query: {
      esql: (0, _esqlUtils.getInitialESQLQuery)(defaultDataView, true)
    },
    dataViewSpec: defaultDataView === null || defaultDataView === void 0 ? void 0 : defaultDataView.toSpec()
  };
  const discoverLocation = await (locator === null || locator === void 0 ? void 0 : locator.getLocation(params));
  term = term.toLowerCase();
  let score = 0;
  if (term === 'es|ql' || term === 'esql') {
    score = 100;
  } else if (term && ('es|ql'.includes(term) || 'esql'.includes(term))) {
    score = 90;
  }
  if (score === 0) return [];
  return [{
    id: 'esql',
    title,
    type: 'application',
    icon: 'logoKibana',
    meta: {
      categoryId: _public.DEFAULT_APP_CATEGORIES.kibana.id,
      categoryLabel: _public.DEFAULT_APP_CATEGORIES.kibana.label
    },
    score,
    url: `/app/${discoverLocation.app}${discoverLocation.path}`
  }];
};
exports.searchProviderFind = searchProviderFind;