"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFetch$ = getFetch$;
var _rxjs = require("rxjs");
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * This function returns an observable that's used to trigger data fetching
 */
function getFetch$({
  setAutoRefreshDone,
  data,
  main$,
  refetch$,
  searchSessionManager,
  lastReloadRequestTime$
}) {
  const {
    timefilter
  } = data.query.timefilter;
  return (0, _rxjs.merge)(refetch$, timefilter.getFetch$(), timefilter.getAutoRefreshFetch$().pipe((0, _rxjs.tap)(done => {
    setAutoRefreshDone(done);
  }), (0, _rxjs.filter)(() => {
    const currentFetchStatus = main$.getValue().fetchStatus;
    return (
      /**
       * filter to prevent auto-refresh triggered fetch when
       * loading is still ongoing
       */
      currentFetchStatus !== _types.FetchStatus.LOADING && currentFetchStatus !== _types.FetchStatus.PARTIAL
    );
  })), (0, _rxjs.defer)(() => {
    // We defer creating the search session ID observable until it's subscribed to
    // in order to ensure we get a new instance when switching between tabs.
    // Otherwise, search session IDs from previous tabs could trigger extra fetches
    // when initializing a new tab with a different search session ID.
    return searchSessionManager.getNewSearchSessionIdFromURL$().pipe((0, _rxjs.filter)(sessionId => !!sessionId));
  })).pipe((0, _rxjs.debounceTime)(100), (0, _rxjs.tap)(() => {
    lastReloadRequestTime$.next(Date.now());
  }));
}