"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFailureStoreSuccessNotifier = exports.updateFailureStoreFailedNotifier = exports.fetchTotalDocsFailedNotifier = exports.fetchIntegrationsFailedNotifier = exports.fetchFailedStatsFailedNotifier = exports.fetchDegradedStatsFailedNotifier = exports.fetchDatasetTypesPrivilegesFailedNotifier = exports.fetchDatasetStatsFailedNotifier = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchDatasetTypesPrivilegesFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchDatasetTypesPrivilegesFailed', {
      defaultMessage: "We couldn't get your data set types privileges."
    }),
    text: error.message
  });
};
exports.fetchDatasetTypesPrivilegesFailedNotifier = fetchDatasetTypesPrivilegesFailedNotifier;
const fetchDatasetStatsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchDatasetStatsFailed', {
      defaultMessage: "We couldn't get your data sets."
    }),
    text: error.message
  });
};
exports.fetchDatasetStatsFailedNotifier = fetchDatasetStatsFailedNotifier;
const fetchDegradedStatsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchDegradedStatsFailed', {
      defaultMessage: "We couldn't get your degraded docs information."
    }),
    text: error.message
  });
};
exports.fetchDegradedStatsFailedNotifier = fetchDegradedStatsFailedNotifier;
const fetchTotalDocsFailedNotifier = (toasts, error, meta) => {
  const dataStreamType = meta._event.origin;
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchTotalDocsFailed', {
      defaultMessage: "We couldn't get total docs information for {dataStreamType}.",
      values: {
        dataStreamType
      }
    }),
    text: error.message
  });
};
exports.fetchTotalDocsFailedNotifier = fetchTotalDocsFailedNotifier;
const fetchIntegrationsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchIntegrationsFailed', {
      defaultMessage: "We couldn't get your integrations."
    }),
    text: error.message
  });
};
exports.fetchIntegrationsFailedNotifier = fetchIntegrationsFailedNotifier;
const fetchFailedStatsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchFailedStatsFailed', {
      defaultMessage: "We couldn't get your failed docs information."
    }),
    text: error.message
  });
};
exports.fetchFailedStatsFailedNotifier = fetchFailedStatsFailedNotifier;
const updateFailureStoreFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.updateFailureStoreFailed', {
      defaultMessage: "We couldn't update the failure store settings."
    }),
    text: error.message
  });
};
exports.updateFailureStoreFailedNotifier = updateFailureStoreFailedNotifier;
const updateFailureStoreSuccessNotifier = toasts => {
  toasts.addSuccess({
    title: _i18n.i18n.translate('xpack.datasetQuality.updateFailureStoreSuccess', {
      defaultMessage: 'Failure store settings saved'
    })
  });
};
exports.updateFailureStoreSuccessNotifier = updateFailureStoreSuccessNotifier;