"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useESQLDataVisualizerData = exports.getDefaultESQLDataVisualizerListState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _mlUrlState = require("@kbn/ml-url-state");
var _fieldTypes = require("@kbn/field-types");
var _fieldUtils = require("@kbn/field-utils");
var _dataService = require("@kbn/data-service");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _esQuery = require("@kbn/es-query");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _filter_fields = require("../../../common/components/fields_stats_grid/filter_fields");
var _index_based_expanded_row = require("../../../common/components/expanded_row/index_based_expanded_row");
var _use_esql_field_stats_data = require("./use_esql_field_stats_data");
var _esql_utils = require("../../search_strategy/requests/esql_utils");
var _constants = require("../../../common/constants");
var _use_esql_overall_stats_data = require("./use_esql_overall_stats_data");
var _kibana_context = require("../../../kibana_context");
var _index_data_visualizer_viewer = require("../../constants/index_data_visualizer_viewer");
var _esql_constants = require("../../constants/esql_constants");
var _get_reason_fieldstats_unavailable_for_esql_query = require("../../utils/get_reason_fieldstats_unavailable_for_esql_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/index_data_visualizer/hooks/esql/use_data_visualizer_esql_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultSearchQuery = {
  match_all: {}
};
const FALLBACK_ESQL_QUERY = {
  esql: ''
};
const DEFAULT_LIMIT_SIZE = '5000';
const defaults = (0, _index_data_visualizer_viewer.getDefaultPageState)();
const getDefaultESQLDataVisualizerListState = overrides => ({
  pageIndex: 0,
  pageSize: 10,
  sortField: 'fieldName',
  sortDirection: 'asc',
  visibleFieldTypes: [],
  visibleFieldNames: [],
  limitSize: DEFAULT_LIMIT_SIZE,
  searchString: '',
  searchQuery: defaultSearchQuery,
  searchQueryLanguage: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY,
  filters: [],
  showDistributions: false,
  showAllFields: false,
  showEmptyFields: false,
  probability: null,
  rndSamplerPref: 'off',
  query: {
    esql: ''
  },
  ...overrides
});
exports.getDefaultESQLDataVisualizerListState = getDefaultESQLDataVisualizerListState;
const useESQLDataVisualizerData = (input, dataVisualizerListState) => {
  var _dataVisualizerListSt, _dataVisualizerListSt2, _input$timeRange, _input$timeRange2, _dataVisualizerListSt3, _fieldStatsRequest$li, _input$esqlQuery2;
  const [lastRefresh, setLastRefresh] = (0, _react.useState)(0);
  const {
    services
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const {
    uiSettings,
    executionContext,
    data
  } = services;
  const parentExecutionContext = (0, _useObservable.default)(executionContext === null || executionContext === void 0 ? void 0 : executionContext.context$);
  const componentExecutionContext = (0, _react.useMemo)(() => {
    const child = {
      type: 'visualization',
      name: 'esql_field_statistics_table',
      id: input.id
    };
    return {
      ...(parentExecutionContext ? parentExecutionContext : {}),
      child
    };
  }, [parentExecutionContext, input.id]);
  (0, _public.useExecutionContext)(executionContext, componentExecutionContext);
  const _timeBuckets = (0, _mlTimeBuckets.useTimeBuckets)(uiSettings);
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: true,
    autoRefreshSelector: true
  });
  const [delayedESQLQuery, setDelayedESQLQuery] = (0, _react.useState)(input === null || input === void 0 ? void 0 : input.esqlQuery);
  const previousQuery = (0, _usePrevious.default)(delayedESQLQuery);
  const {
    currentDataView,
    parentQuery,
    parentFilters,
    query,
    visibleFieldNames,
    indexPattern
  } = (0, _react.useMemo)(() => {
    var _input$visibleFieldNa;
    let q = FALLBACK_ESQL_QUERY;
    if (input !== null && input !== void 0 && input.query && (0, _esql_utils.isESQLQuery)(input === null || input === void 0 ? void 0 : input.query)) q = input.query;
    if (delayedESQLQuery && (0, _esql_utils.isESQLQuery)(delayedESQLQuery)) q = delayedESQLQuery;
    if (input !== null && input !== void 0 && input.savedSearch && (0, _esql_utils.isESQLQuery)(input.savedSearch.searchSource.getField('query'))) {
      q = input.savedSearch.searchSource.getField('query');
    }
    return {
      currentDataView: input.dataView,
      query: q,
      // It's possible that in a dashboard setting, we will have additional filters and queries
      parentQuery: input === null || input === void 0 ? void 0 : input.query,
      parentFilters: input === null || input === void 0 ? void 0 : input.filters,
      visibleFieldNames: (_input$visibleFieldNa = input === null || input === void 0 ? void 0 : input.visibleFieldNames) !== null && _input$visibleFieldNa !== void 0 ? _input$visibleFieldNa : [],
      indexPattern: input === null || input === void 0 ? void 0 : input.indexPattern
    };
  }, [input.query, input.savedSearch, input.dataView, input === null || input === void 0 ? void 0 : input.filters, input === null || input === void 0 ? void 0 : input.visibleFieldNames, input === null || input === void 0 ? void 0 : input.indexPattern, delayedESQLQuery]);
  const restorableDefaults = (0, _react.useMemo)(() => getDefaultESQLDataVisualizerListState(dataVisualizerListState),
  // We just need to load the saved preference when the page is first loaded
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const [globalState, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const showEmptyFields = (_dataVisualizerListSt = dataVisualizerListState.showEmptyFields) !== null && _dataVisualizerListSt !== void 0 ? _dataVisualizerListSt : restorableDefaults.showEmptyFields;
  const limitSize = (_dataVisualizerListSt2 = dataVisualizerListState.limitSize) !== null && _dataVisualizerListSt2 !== void 0 ? _dataVisualizerListSt2 : restorableDefaults.limitSize;

  /** Search strategy **/
  const fieldStatsRequest = (0, _react.useMemo)(() => {
    var _uiSettings$get, _filter2, _filter2$bool;
    // Obtain the interval to use for date histogram aggregations
    // (such as the document count chart). Aim for 75 bars.
    const buckets = _timeBuckets;
    const tf = timefilter;
    if (!buckets || !tf || query.esql === '') return;

    // Safeguard to not ever run query if not supported
    if ((0, _esql_utils.isESQLQuery)(query)) {
      const unsupportedReasonForQuery = (0, _get_reason_fieldstats_unavailable_for_esql_query.getReasonIfFieldStatsUnavailableForQuery)(query);
      if (unsupportedReasonForQuery) {
        return;
      }
    }
    const activeBounds = tf.getActiveBounds();
    let earliest;
    let latest;
    if (activeBounds !== undefined && (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.timeFieldName) !== undefined) {
      var _activeBounds$min, _activeBounds$max;
      earliest = (_activeBounds$min = activeBounds.min) === null || _activeBounds$min === void 0 ? void 0 : _activeBounds$min.valueOf();
      latest = (_activeBounds$max = activeBounds.max) === null || _activeBounds$max === void 0 ? void 0 : _activeBounds$max.valueOf();
    }
    const bounds = tf.getActiveBounds();
    const barTarget = (_uiSettings$get = uiSettings.get(_dataService.UI_SETTINGS.HISTOGRAM_BAR_TARGET)) !== null && _uiSettings$get !== void 0 ? _uiSettings$get : _constants.DEFAULT_BAR_TARGET;
    buckets.setInterval('auto');
    if (bounds) {
      buckets.setBounds(bounds);
      buckets.setBarTarget(barTarget);
    }
    const aggInterval = buckets.getInterval();
    let filter = (0, _esQuery.buildEsQuery)(input.dataView, Array.isArray(parentQuery) ? parentQuery : [parentQuery], parentFilters !== null && parentFilters !== void 0 ? parentFilters : []);
    const timeRange = input.timeRange ? input.timeRange : timefilter.getTime();
    if (currentDataView !== null && currentDataView !== void 0 && currentDataView.timeFieldName) {
      var _filter, _filter$bool;
      if (Array.isArray((_filter = filter) === null || _filter === void 0 ? void 0 : (_filter$bool = _filter.bool) === null || _filter$bool === void 0 ? void 0 : _filter$bool.filter)) {
        filter.bool.filter.push({
          range: {
            [currentDataView.timeFieldName]: {
              format: 'strict_date_optional_time',
              gte: timeRange.from,
              lte: timeRange.to
            }
          }
        });
      } else {
        filter = {
          bool: {
            must: [],
            filter: [{
              range: {
                [currentDataView.timeFieldName]: {
                  format: 'strict_date_optional_time',
                  gte: timeRange.from,
                  lte: timeRange.to
                }
              }
            }],
            should: [],
            must_not: []
          }
        };
      }
    }

    // Ensure that we don't query frozen data
    if (filter.bool === undefined) {
      filter.bool = Object.create(null);
    }
    if (filter.bool && filter.bool.must_not === undefined) {
      filter.bool.must_not = [];
    }
    if (filter.bool && Array.isArray((_filter2 = filter) === null || _filter2 === void 0 ? void 0 : (_filter2$bool = _filter2.bool) === null || _filter2$bool === void 0 ? void 0 : _filter2$bool.must_not)) {
      filter.bool.must_not.push({
        term: {
          _tier: 'data_frozen'
        }
      });
    }
    return {
      id: input.id,
      earliest,
      latest,
      aggInterval,
      intervalMs: aggInterval === null || aggInterval === void 0 ? void 0 : aggInterval.asMilliseconds(),
      searchQuery: query,
      limit: limitSize !== undefined ? parseInt(limitSize, 10) : _esql_constants.DEFAULT_ESQL_LIMIT,
      sessionId: undefined,
      indexPattern,
      timeFieldName: currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.timeFieldName,
      runtimeFieldMap: currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.getRuntimeMappings(),
      lastRefresh,
      filter,
      timeRange
    };
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [_timeBuckets, timefilter,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  JSON.stringify({
    query,
    parentQuery,
    parentFilters
  }), currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.timeFieldName, lastRefresh, limitSize, (_input$timeRange = input.timeRange) === null || _input$timeRange === void 0 ? void 0 : _input$timeRange.from, (_input$timeRange2 = input.timeRange) === null || _input$timeRange2 === void 0 ? void 0 : _input$timeRange2.to]);
  (0, _react.useEffect)(() => {
    // Force refresh on index pattern change
    setLastRefresh(Date.now());
  }, [setLastRefresh]);
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.time) !== undefined) {
      timefilter.setTime({
        from: globalState.time.from,
        to: globalState.time.to
      });
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.time), timefilter]);
  (0, _react.useEffect)(() => {
    const timeUpdateSubscription = (0, _rxjs.merge)(timefilter.getTimeUpdate$(), timefilter.getAutoRefreshFetch$(), _mlDatePicker.mlTimefilterRefresh$).subscribe(() => {
      setGlobalState({
        time: timefilter.getTime(),
        refreshInterval: timefilter.getRefreshInterval()
      });
      setLastRefresh(Date.now());
    });
    return () => {
      timeUpdateSubscription.unsubscribe();
    };
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined) {
      timefilter.setRefreshInterval(globalState.refreshInterval);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval), timefilter]);
  const {
    documentCountStats,
    totalCount,
    overallStats,
    totalFields,
    overallStatsProgress,
    columns,
    cancelOverallStatsRequest,
    timeFieldName,
    queryHistoryStatus,
    exampleDocs
  } = (0, _use_esql_overall_stats_data.useESQLOverallStatsData)(fieldStatsRequest);
  const [metricConfigs, setMetricConfigs] = (0, _react.useState)(defaults.metricConfigs);
  const [metricsLoaded] = (0, _react.useState)(defaults.metricsLoaded);
  const [metricsStats, setMetricsStats] = (0, _react.useState)();
  const [nonMetricConfigs, setNonMetricConfigs] = (0, _react.useState)(defaults.nonMetricConfigs);
  const [nonMetricsLoaded] = (0, _react.useState)(defaults.nonMetricsLoaded);
  const [fieldStatFieldsToFetch, setFieldStatFieldsToFetch] = (0, _react.useState)();
  const visibleFieldTypes = (_dataVisualizerListSt3 = dataVisualizerListState.visibleFieldTypes) !== null && _dataVisualizerListSt3 !== void 0 ? _dataVisualizerListSt3 : restorableDefaults.visibleFieldTypes;
  const [expandedRows, setExpandedRows] = (0, _react.useState)([]);
  const onVisibilityChange = (0, _react.useCallback)((visible, item) => {
    if (visible) {
      setExpandedRows(prev => [...prev, item.fieldName]);
    } else {
      setExpandedRows(prev => prev.filter(fieldName => fieldName !== item.fieldName));
    }
  }, []);
  const hasExpandedRows = (0, _react.useMemo)(() => expandedRows.length > 0, [expandedRows]);
  (0, _react.useEffect)(function updateFieldStatFieldsToFetch() {
    var _filteredItems$filter;
    if ((dataVisualizerListState === null || dataVisualizerListState === void 0 ? void 0 : dataVisualizerListState.showDistributions) === false && !hasExpandedRows) {
      setFieldStatFieldsToFetch(undefined);
      return;
    }
    const {
      sortField,
      sortDirection
    } = dataVisualizerListState;

    // Otherwise, sort the list of fields by the initial sort field and sort direction
    // Then divide into chunks by the initial page size

    const itemsSorter = _eui.Comparators.property(sortField, _eui.Comparators.default(sortDirection));
    const preslicedSortedConfigs = [...nonMetricConfigs, ...metricConfigs].map(c => {
      var _c$stats, _c$stats2;
      return {
        ...c,
        name: c.fieldName,
        docCount: (_c$stats = c.stats) === null || _c$stats === void 0 ? void 0 : _c$stats.count,
        cardinality: (_c$stats2 = c.stats) === null || _c$stats2 === void 0 ? void 0 : _c$stats2.cardinality
      };
    }).sort(itemsSorter);
    const filteredItems = (0, _filter_fields.filterFields)(preslicedSortedConfigs, dataVisualizerListState.visibleFieldNames, dataVisualizerListState.visibleFieldTypes);
    const {
      pageIndex,
      pageSize
    } = dataVisualizerListState;
    const pageOfConfigs = (_filteredItems$filter = filteredItems.filteredFields) === null || _filteredItems$filter === void 0 ? void 0 : _filteredItems$filter.slice(pageIndex * pageSize, (pageIndex + 1) * pageSize).filter(d => d.existsInDocs === true);
    setFieldStatFieldsToFetch(pageOfConfigs);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [dataVisualizerListState.pageIndex, dataVisualizerListState.pageSize, dataVisualizerListState.sortField, dataVisualizerListState.sortDirection, nonMetricConfigs, metricConfigs, dataVisualizerListState === null || dataVisualizerListState === void 0 ? void 0 : dataVisualizerListState.showDistributions, hasExpandedRows]);
  const {
    fieldStats,
    fieldStatsProgress,
    cancelFieldStatsRequest
  } = (0, _use_esql_field_stats_data.useESQLFieldStatsData)({
    searchQuery: fieldStatsRequest === null || fieldStatsRequest === void 0 ? void 0 : fieldStatsRequest.searchQuery,
    columns: fieldStatFieldsToFetch,
    filter: fieldStatsRequest === null || fieldStatsRequest === void 0 ? void 0 : fieldStatsRequest.filter,
    limit: (_fieldStatsRequest$li = fieldStatsRequest === null || fieldStatsRequest === void 0 ? void 0 : fieldStatsRequest.limit) !== null && _fieldStatsRequest$li !== void 0 ? _fieldStatsRequest$li : _esql_constants.DEFAULT_ESQL_LIMIT,
    timeRange: fieldStatsRequest === null || fieldStatsRequest === void 0 ? void 0 : fieldStatsRequest.timeRange
  });
  (0, _react.useEffect)(function resetFieldStatsFieldToFetch() {
    // If query returns 0 document, no need to do more work here
    if (totalCount === undefined) {
      setFieldStatFieldsToFetch(undefined);
    }
    if (totalCount === 0) {
      setMetricConfigs(defaults.metricConfigs);
      setNonMetricConfigs(defaults.nonMetricConfigs);
      setMetricsStats(undefined);
      setFieldStatFieldsToFetch(undefined);
    }
  }, [totalCount]);
  const createMetricCards = (0, _react.useCallback)(() => {
    if (!columns || !overallStats) return;
    const configs = [];
    const aggregatableExistsFields = overallStats.aggregatableExistsFields || [];
    const allMetricFields = columns.filter(f => {
      return f.secondaryType === _fieldTypes.KBN_FIELD_TYPES.NUMBER;
    });
    const metricExistsFields = allMetricFields.filter(f => {
      return aggregatableExistsFields.find(existsF => {
        return existsF.fieldName === f.name;
      });
    });
    let _aggregatableFields = overallStats.aggregatableExistsFields;
    if (allMetricFields.length !== metricExistsFields.length && metricsLoaded === true) {
      _aggregatableFields = _aggregatableFields.concat(overallStats.aggregatableNotExistsFields);
    }
    const metricFieldsToShow = metricsLoaded === true && showEmptyFields === true ? allMetricFields : metricExistsFields;
    metricFieldsToShow.forEach(field => {
      var _fieldData$existsInDo;
      const fieldData = _aggregatableFields.find(f => {
        return f.fieldName === field.name;
      });
      if (!fieldData) return;
      const metricConfig = {
        ...field,
        ...fieldData,
        loading: (_fieldData$existsInDo = fieldData === null || fieldData === void 0 ? void 0 : fieldData.existsInDocs) !== null && _fieldData$existsInDo !== void 0 ? _fieldData$existsInDo : true,
        fieldFormat: data.fieldFormats.deserialize({
          id: field.secondaryType
        }),
        aggregatable: true,
        deletable: false,
        type: (0, _fieldUtils.getFieldType)(field)
      };
      configs.push(metricConfig);
    });
    setMetricsStats({
      totalMetricFieldsCount: allMetricFields.length,
      visibleMetricsCount: metricFieldsToShow.length
    });
    setMetricConfigs(configs);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [metricsLoaded, overallStats, showEmptyFields, columns, currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.id]);
  const createNonMetricCards = (0, _react.useCallback)(() => {
    if (!columns || !overallStats) return;
    const allNonMetricFields = columns.filter(f => {
      return f.secondaryType !== _fieldTypes.KBN_FIELD_TYPES.NUMBER;
    });
    // Obtain the list of all non-metric fields which appear in documents
    // (aggregatable or not aggregatable).
    const populatedNonMetricFields = []; // Kibana index pattern non metric fields.
    let nonMetricFieldData = []; // Basic non metric field data loaded from requesting overall stats.
    const aggregatableExistsFields = overallStats.aggregatableExistsFields || [];
    const nonAggregatableExistsFields = overallStats.nonAggregatableExistsFields || [];
    allNonMetricFields.forEach(f => {
      const checkAggregatableField = aggregatableExistsFields.find(existsField => existsField.fieldName === f.name);
      if (checkAggregatableField !== undefined) {
        populatedNonMetricFields.push(f);
        nonMetricFieldData.push(checkAggregatableField);
      } else {
        const checkNonAggregatableField = nonAggregatableExistsFields.find(existsField => existsField.fieldName === f.name);
        if (checkNonAggregatableField !== undefined) {
          populatedNonMetricFields.push(f);
          nonMetricFieldData.push(checkNonAggregatableField);
        }
      }
    });
    if (allNonMetricFields.length !== nonMetricFieldData.length && showEmptyFields === true) {
      // Combine the field data obtained from Elasticsearch into a single array.
      nonMetricFieldData = nonMetricFieldData.concat(overallStats.aggregatableNotExistsFields, overallStats.nonAggregatableNotExistsFields);
    }
    const nonMetricFieldsToShow = showEmptyFields ? allNonMetricFields : populatedNonMetricFields;
    const configs = [];
    nonMetricFieldsToShow.forEach(field => {
      var _fieldData$existsInDo2;
      const fieldData = nonMetricFieldData.find(f => f.fieldName === field.name);
      const nonMetricConfig = {
        ...(fieldData ? fieldData : {}),
        secondaryType: (0, _fieldUtils.getFieldType)(field),
        loading: (_fieldData$existsInDo2 = fieldData === null || fieldData === void 0 ? void 0 : fieldData.existsInDocs) !== null && _fieldData$existsInDo2 !== void 0 ? _fieldData$existsInDo2 : true,
        deletable: false,
        fieldFormat: data.fieldFormats.deserialize({
          id: field.secondaryType
        })
      };

      // Map the field type from the Kibana index pattern to the field type
      // used in the data visualizer.
      const dataVisualizerType = (0, _fieldUtils.getFieldType)(field);
      if (dataVisualizerType !== undefined) {
        nonMetricConfig.type = dataVisualizerType;
      } else {
        // Add a flag to indicate that this is one of the 'other' Kibana
        // field types that do not yet have a specific card type.
        nonMetricConfig.type = field.type;
        nonMetricConfig.isUnsupportedType = true;
      }
      if (field.name !== nonMetricConfig.fieldName) {
        nonMetricConfig.displayName = field.name;
      }
      configs.push(nonMetricConfig);
    });
    setNonMetricConfigs(configs);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [columns, nonMetricsLoaded, overallStats, showEmptyFields]);
  const fieldsCountStats = (0, _react.useMemo)(() => {
    if (!overallStats) return;
    let _visibleFieldsCount = 0;
    const _totalFieldsCount = totalFields !== null && totalFields !== void 0 ? totalFields : 0;
    if (showEmptyFields === true) {
      _visibleFieldsCount = _totalFieldsCount;
    } else {
      _visibleFieldsCount = overallStats.aggregatableExistsFields.length + overallStats.nonAggregatableExistsFields.length;
    }
    return {
      visibleFieldsCount: _visibleFieldsCount,
      totalFieldsCount: _totalFieldsCount
    };
  }, [overallStats, showEmptyFields, totalFields]);
  (0, _react.useEffect)(() => {
    createMetricCards();
    createNonMetricCards();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [overallStats, showEmptyFields]);
  const configs = (0, _react.useMemo)(() => {
    let combinedConfigs = [...nonMetricConfigs, ...metricConfigs];
    combinedConfigs = (0, _filter_fields.filterFields)(combinedConfigs, visibleFieldNames, visibleFieldTypes).filteredFields;
    const examples = exampleDocs === null || exampleDocs === void 0 ? void 0 : exampleDocs.reduce((map, exampleDoc) => {
      map.set(exampleDoc.fieldName, exampleDoc);
      return map;
    }, new Map());
    if (fieldStatsProgress.loaded === 100 && fieldStats) {
      combinedConfigs = combinedConfigs.map(c => {
        var _ref, _fieldStats$get;
        const loadedFullStats = (_ref = (_fieldStats$get = fieldStats.get(c.fieldName)) !== null && _fieldStats$get !== void 0 ? _fieldStats$get : examples === null || examples === void 0 ? void 0 : examples.get(c.fieldName)) !== null && _ref !== void 0 ? _ref : {};
        return loadedFullStats ? {
          ...c,
          loading: false,
          stats: {
            ...c.stats,
            ...loadedFullStats
          }
        } : c;
      });
    }
    return combinedConfigs;
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [nonMetricConfigs, metricConfigs, visibleFieldTypes, visibleFieldNames, fieldStatsProgress.loaded, dataVisualizerListState.pageIndex, dataVisualizerListState.pageSize, exampleDocs]);
  const getItemIdToExpandedRowMap = (0, _react.useCallback)(function (itemIds, items) {
    return itemIds.reduce((map, fieldName) => {
      const item = items.find(fieldVisConfig => fieldVisConfig.fieldName === fieldName);
      if (item !== undefined) {
        map[fieldName] = /*#__PURE__*/_react.default.createElement(_index_based_expanded_row.IndexBasedDataVisualizerExpandedRow, {
          item: item,
          dataView: currentDataView,
          esql: query.esql,
          totalDocuments: totalCount,
          typeAccessor: "secondaryType",
          timeFieldName: timeFieldName,
          onAddFilter: input.onAddFilter,
          onVisibilityChange: onVisibilityChange,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 646,
            columnNumber: 13
          }
        });
      }
      return map;
    }, {});
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [currentDataView, totalCount, query.esql, timeFieldName, onVisibilityChange]);
  const combinedProgress = (0, _react.useMemo)(() => totalCount === 0 ? overallStatsProgress.loaded : overallStatsProgress.loaded * 0.3 + fieldStatsProgress.loaded * 0.7, [totalCount, overallStatsProgress.loaded, fieldStatsProgress.loaded]);
  const resetData = (0, _react.useCallback)(q => {
    // When user submits a new query
    // resets all current requests and other data
    if (cancelOverallStatsRequest) {
      cancelOverallStatsRequest();
    }
    if (cancelFieldStatsRequest) {
      cancelFieldStatsRequest();
    }
    // Reset field stats to fetch state
    setFieldStatFieldsToFetch(undefined);
    setMetricConfigs(defaults.metricConfigs);
    setNonMetricConfigs(defaults.nonMetricConfigs);
  }, [cancelFieldStatsRequest, cancelOverallStatsRequest]);
  (0, _react.useEffect)(() => {
    var _input$esqlQuery;
    if ((previousQuery === null || previousQuery === void 0 ? void 0 : previousQuery.esql) !== (input === null || input === void 0 ? void 0 : (_input$esqlQuery = input.esqlQuery) === null || _input$esqlQuery === void 0 ? void 0 : _input$esqlQuery.esql)) {
      resetData();
      setDelayedESQLQuery(input === null || input === void 0 ? void 0 : input.esqlQuery);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [input === null || input === void 0 ? void 0 : (_input$esqlQuery2 = input.esqlQuery) === null || _input$esqlQuery2 === void 0 ? void 0 : _input$esqlQuery2.esql, resetData]);
  return {
    totalCount,
    progress: combinedProgress,
    overallStatsProgress,
    configs,
    // Column with action to lens, data view editor, etc
    // set to nothing for now
    extendedColumns: undefined,
    documentCountStats,
    metricsStats,
    overallStats,
    timefilter,
    setLastRefresh,
    getItemIdToExpandedRowMap,
    cancelOverallStatsRequest,
    cancelFieldStatsRequest,
    resetData,
    limitSize,
    showEmptyFields,
    fieldsCountStats,
    timeFieldName,
    queryHistoryStatus
  };
};
exports.useESQLDataVisualizerData = useESQLDataVisualizerData;