"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataDriftDistributionChart = void 0;
var _charts = require("@elastic/charts");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/field-formats-plugin/common");
var _i18n = require("@kbn/i18n");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _eui = require("@elastic/eui");
var _no_charts_data = require("./no_charts_data");
var _constants = require("../constants");
var _data_drift_chart_tooltip_body = require("../data_drift_chart_tooltip_body");
var _default_value_formatter = require("./default_value_formatter");
var _storage = require("../../index_data_visualizer/types/storage");
var _data_drift = require("../../index_data_visualizer/types/data_drift");
var _kibana_context = require("../../kibana_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/data_drift/charts/data_drift_distribution_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CHART_HEIGHT = 150;
const showAsAreaChartOption = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.showAsAreaChartOptionLabel', {
  defaultMessage: 'Show as area chart'
});
const showAsBarChartOption = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.showAsBarChartOptionLabel', {
  defaultMessage: 'Show as bar chart'
});
const visualizeComparisonChartType = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.visualizeComparisonTypeLabel', {
  defaultMessage: 'Visualize comparison type'
});
const visualizeComparisonChartIcons = [{
  id: _data_drift.DATA_DRIFT_COMPARISON_CHART_TYPE.AREA,
  label: showAsAreaChartOption,
  iconType: 'visArea'
}, {
  id: _data_drift.DATA_DRIFT_COMPARISON_CHART_TYPE.BAR,
  label: showAsBarChartOption,
  iconType: 'visBarVertical'
}];
const DataDriftDistributionChart = ({
  item,
  colors,
  secondaryType
}) => {
  const {
    services: {
      charts
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const xAxisFormatter = (0, _default_value_formatter.useFieldFormatter)((0, _default_value_formatter.getFieldFormatType)(secondaryType));
  const yAxisFormatter = (0, _default_value_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.NUMBER);
  const [comparisonChartType, setComparisonChartType] = (0, _mlLocalStorage.useStorage)(_storage.DV_DATA_DRIFT_DISTRIBUTION_CHART_TYPE,
  // By default we will set default comparison chart in expanded row as area chart
  _data_drift.DATA_DRIFT_COMPARISON_CHART_TYPE.AREA);
  const chartBaseTheme = charts.theme.useChartsBaseTheme();
  const chartThemeOverrides = (0, _react.useMemo)(() => {
    return {
      background: {
        color: 'transparent'
      }
    };
  }, []);
  if (!item || item.comparisonDistribution.length === 0) return /*#__PURE__*/_react.default.createElement(_no_charts_data.NoChartsData, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 65
    }
  });
  const {
    featureName,
    fieldType,
    comparisonDistribution: data
  } = item;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "s",
    legend: visualizeComparisonChartType,
    options: visualizeComparisonChartIcons,
    idSelected: comparisonChartType,
    onChange: id => setComparisonChartType(id),
    isIconOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: '100%',
      height: CHART_HEIGHT
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: CHART_HEIGHT
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    body: _data_drift_chart_tooltip_body.DataComparisonChartTooltipBody,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [chartThemeOverrides],
    baseTheme: chartBaseTheme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    tickFormat: xAxisFormatter,
    labelFormat: xAxisFormatter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "vertical",
    position: _charts.Position.Left,
    tickFormat: yAxisFormatter,
    domain: {
      min: 0,
      max: 1
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }), comparisonChartType === _data_drift.DATA_DRIFT_COMPARISON_CHART_TYPE.BAR ? /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "dataVisualizer.barDistributionComparisonChart",
    name: featureName,
    xScaleType: fieldType === _constants.DATA_COMPARISON_TYPE.NUMERIC ? _charts.ScaleType.Linear : _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['percentage'],
    splitSeriesAccessors: ['g'],
    data: data,
    color: identifier => {
      const key = identifier.seriesKeys[0];
      return key === _constants.COMPARISON_LABEL ? colors.comparisonColor : colors.referenceColor;
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: "dataVisualizer.overlapDistributionComparisonChart",
    name: _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.distributionComparisonChartName', {
      defaultMessage: 'Distribution comparison of {referenceLabel} and {comparisonLabel} data for {fieldName}',
      values: {
        referenceLabel: _constants.REFERENCE_LABEL.toLowerCase(),
        comparisonLabel: _constants.COMPARISON_LABEL.toLowerCase(),
        fieldName: featureName
      }
    }),
    xScaleType: fieldType === _constants.DATA_COMPARISON_TYPE.NUMERIC ? _charts.ScaleType.Linear : _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['percentage'],
    splitSeriesAccessors: ['g'],
    data: data,
    curve: _charts.CurveType.CURVE_STEP,
    color: identifier => {
      const key = identifier.seriesKeys[0];
      return key === _constants.COMPARISON_LABEL ? colors.comparisonColor : colors.referenceColor;
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  }))));
};
exports.DataDriftDistributionChart = DataDriftDistributionChart;