"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardAPIGetResultSchema = getDashboardAPIGetResultSchema;
exports.getDashboardGetResultSchema = getDashboardGetResultSchema;
var _configSchema = require("@kbn/config-schema");
var _common = require("./common");
var _meta_schemas = require("../../../api/meta_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getDashboardGetResultSchema() {
  return _configSchema.schema.object({
    item: (0, _common.getDashboardItemSchema)(),
    meta: _meta_schemas.resolveMetaSchema
  }, {
    unknowns: 'forbid'
  });
}
function getDashboardAPIGetResultSchema() {
  return _configSchema.schema.object({
    id: _configSchema.schema.string(),
    type: _configSchema.schema.string(),
    data: (0, _common.getDashboardDataSchema)(),
    meta: _configSchema.schema.allOf([_meta_schemas.baseMetaSchema, _meta_schemas.createdMetaSchema, _meta_schemas.updatedMetaSchema, _meta_schemas.resolveMetaSchema])
  }, {
    unknowns: 'forbid'
  });
}