"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardDrilldownConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/presentation-util-plugin/public");
var _i18n = require("./i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dashboard_enhanced/public/services/drilldowns/abstract_dashboard_drilldown/components/dashboard_drilldown_config/dashboard_drilldown_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DashboardDrilldownOptions = (0, _public.withSuspense)(_public.DashboardDrilldownOptionsComponent, null);
const DashboardDrilldownConfig = ({
  dashboards,
  onDashboardSelect,
  onSearchChange,
  isLoading,
  error,
  config,
  onConfigChange
}) => {
  var _dashboards$find;
  const selectedTitle = ((_dashboards$find = dashboards.find(item => item.value === config.dashboardId)) === null || _dashboards$find === void 0 ? void 0 : _dashboards$find.label) || '';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.txtChooseDestinationDashboard,
    fullWidth: true,
    isInvalid: !!error,
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    async: true,
    selectedOptions: config.dashboardId ? [{
      label: selectedTitle,
      value: config.dashboardId
    }] : [],
    options: dashboards,
    onChange: ([{
      value = ''
    } = {
      value: ''
    }]) => onDashboardSelect(value),
    onSearchChange: onSearchChange,
    isLoading: isLoading,
    singleSelection: {
      asPlainText: true
    },
    fullWidth: true,
    "data-test-subj": 'dashboardDrilldownSelectDashboard',
    isInvalid: !!error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(DashboardDrilldownOptions, {
    options: config,
    onOptionChange: onConfigChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }));
};
exports.DashboardDrilldownConfig = DashboardDrilldownConfig;