"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternIndicesPreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _auto_follow_pattern = require("../services/auto_follow_pattern");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/components/auto_follow_pattern_indices_preview.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AutoFollowPatternIndicesPreview = ({
  prefix,
  suffix,
  leaderIndexPatterns
}) => {
  const {
    indicesPreview
  } = (0, _auto_follow_pattern.getPreviewIndicesFromAutoFollowPattern)({
    prefix,
    suffix,
    leaderIndexPatterns
  });
  const title = _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternForm.indicesPreviewTitle', {
    defaultMessage: 'Index name examples'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: title,
    iconType: "indexMapping",
    "data-test-subj": "autoFollowPatternIndicesPreview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.autoFollowPatternForm.indicesPreviewDescription",
    defaultMessage: "The above settings will generate index names that look like this:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, indicesPreview.map(({
    followPattern: {
      prefix,
      suffix,
      template
    }
  }, i) => /*#__PURE__*/_react.default.createElement("li", {
    key: i,
    "data-test-subj": "indexPreview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }, prefix, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 13
    }
  }, template), suffix))));
};
exports.AutoFollowPatternIndicesPreview = AutoFollowPatternIndicesPreview;