"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Coerced = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// @kbn/config-schema objects and records supports a json string as input if it can be
// safely parsed using JSON.parse and if the resulting value is a plain object.
// https://github.com/elastic/kibana/blob/main/src/platform/packages/shared/kbn-config-schema/README.md#schemaobject
// this is not built into zod objects so we need to add it as a preprocessor
const parseJsonPreprocessor = (value, ctx) => {
  if (typeof value === 'string') {
    try {
      return JSON.parse(value);
    } catch (e) {
      ctx.addIssue({
        code: _zod.ZodIssueCode.custom,
        message: e.message
      });
    }
  }
  return value;
};
const Coerced = objSchema => {
  return _zod.z.preprocess(parseJsonPreprocessor, objSchema);
};
exports.Coerced = Coerced;