"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRefreshCaseViewPage = void 0;
var _react = require("react");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../containers/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Using react-query queryClient to invalidate all the
 * case view page cache namespace.
 *
 * This effectively clears the cache for all the case view pages and
 * forces the page to fetch all the data again. Including
 * metrics, actions, comments, etc.
 */

const useRefreshCaseViewPage = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(_constants.casesQueriesKeys.caseView());
    queryClient.invalidateQueries(_constants.casesQueriesKeys.tags());
    queryClient.invalidateQueries(_constants.casesQueriesKeys.categories());
  }, [queryClient]);
};
exports.useRefreshCaseViewPage = useRefreshCaseViewPage;