"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SELECTED_CASES = exports.SEARCH_PLACEHOLDER = exports.SAVE_SELECTION = exports.EDITED_CASES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EDITED_CASES = totalCases => _i18n.i18n.translate('xpack.cases.containers.editedCases', {
  values: {
    totalCases
  },
  defaultMessage: 'Edited {totalCases, plural, =1 {case} other {{totalCases} cases}}'
});
exports.EDITED_CASES = EDITED_CASES;
const SELECTED_CASES = totalCases => _i18n.i18n.translate('xpack.cases.actions.headerSubtitle', {
  values: {
    totalCases
  },
  defaultMessage: 'Selected cases: {totalCases}'
});
exports.SELECTED_CASES = SELECTED_CASES;
const SAVE_SELECTION = exports.SAVE_SELECTION = _i18n.i18n.translate('xpack.cases.actions.saveSelection', {
  defaultMessage: 'Save selection'
});
const SEARCH_PLACEHOLDER = exports.SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.cases.actions.searchPlaceholder', {
  defaultMessage: 'Search'
});