"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KioskControls = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _time_duration = require("../../../lib/time_duration");
var _i18n2 = require("../../../../i18n");
var _custom_interval = require("./custom_interval");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/view_menu/kiosk_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  time: timeStrings
} = _i18n2.UnitStrings;
const {
  getSecondsText,
  getMinutesText
} = timeStrings;
const strings = {
  getCycleFormLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderKioskControl.cycleFormLabel', {
    defaultMessage: 'Change cycling interval'
  }),
  getTitle: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderKioskControl.controlTitle', {
    defaultMessage: 'Cycle fullscreen pages'
  }),
  getAutoplayListDurationManualText: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderKioskControl.autoplayListDurationManual', {
    defaultMessage: 'Manually'
  }),
  getDisableTooltip: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderKioskControl.disableTooltip', {
    defaultMessage: 'Disable auto-play'
  })
};
const ListGroup = ({
  children,
  ...rest
}) => /*#__PURE__*/_react.default.createElement("ul", (0, _extends2.default)({
  style: {
    listStyle: 'none',
    margin: 0
  }
}, rest, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 71,
    columnNumber: 3
  }
}), [children]);
const generateId = (0, _eui.htmlIdGenerator)();
const KioskControls = ({
  autoplayInterval,
  onSetInterval
}) => {
  const disableAutoplay = (0, _react.useCallback)(() => {
    onSetInterval(0);
  }, [onSetInterval]);
  const RefreshItem = ({
    duration,
    label,
    descriptionId
  }) => /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => onSetInterval(duration),
    "aria-describedby": descriptionId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, label));
  const interval = (0, _time_duration.timeDuration)(autoplayInterval);
  const intervalTitleId = generateId();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "spaceBetween",
    className: "canvasViewMenu__kioskSettings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceAround",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  }, strings.getTitle()), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 15
    }
  }, autoplayInterval > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, timeStrings.getCycleTimeText(interval.length, interval.format)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, strings.getAutoplayListDurationManualText())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, autoplayInterval > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: strings.getDisableTooltip(),
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    onClick: disableAutoplay,
    "aria-label": strings.getDisableTooltip(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 21
    }
  }))) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    id: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, strings.getCycleFormLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ListGroup, {
    "aria-labelledby": intervalTitleId,
    className: "canvasControlSettings__list",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 5000,
    label: getSecondsText(5),
    descriptionId: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 10000,
    label: getSecondsText(10),
    descriptionId: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 30000,
    label: getSecondsText(30),
    descriptionId: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 60000,
    label: getMinutesText(1),
    descriptionId: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 300000,
    label: getMinutesText(5),
    descriptionId: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 900000,
    label: getMinutesText(15),
    descriptionId: intervalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_custom_interval.CustomInterval, {
    onSubmit: value => onSetInterval(value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  })));
};
exports.KioskControls = KioskControls;
KioskControls.propTypes = {
  autoplayInterval: _propTypes.default.number.isRequired,
  onSetInterval: _propTypes.default.func.isRequired
};