"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardFetcher = useDashboardFetcher;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_fetcher = require("./use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDashboardFetcher(query) {
  const {
    services: {
      dashboard
    }
  } = (0, _public.useKibana)();
  const [result, setResult] = (0, _react.useState)({
    data: [],
    status: _use_fetcher.FETCH_STATUS.NOT_INITIATED
  });
  (0, _react.useEffect)(() => {
    const getDashboards = async () => {
      setResult({
        data: [],
        status: _use_fetcher.FETCH_STATUS.LOADING
      });
      try {
        const findDashboardsService = await (dashboard === null || dashboard === void 0 ? void 0 : dashboard.findDashboardsService());
        const {
          dashboards
        } = await findDashboardsService.search({
          search: query !== null && query !== void 0 ? query : '',
          per_page: 1000
        });
        setResult({
          data: dashboards,
          status: _use_fetcher.FETCH_STATUS.SUCCESS
        });
      } catch {
        setResult({
          data: [],
          status: _use_fetcher.FETCH_STATUS.FAILURE
        });
      }
    };
    getDashboards();
  }, [dashboard, query]);
  return result;
}