"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectWithPlaceholder = exports.NO_SELECTION = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/select_with_placeholder/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NO_SELECTION = exports.NO_SELECTION = '__NO_SELECTION__';
const DEFAULT_PLACEHOLDER = _i18n.i18n.translate('xpack.apm.selectPlaceholder', {
  defaultMessage: 'Select option:'
});

/**
 * This component addresses some cross-browser inconsistencies of `EuiSelect`
 * with `hasNoInitialSelection`. It uses the `placeholder` prop to populate
 * the first option as the initial, not selected option.
 */
// eslint-disable-next-line react/function-component-definition
const SelectWithPlaceholder = props => {
  const placeholder = props.placeholder || DEFAULT_PLACEHOLDER;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
    "data-test-subj": "apmSelectWithPlaceholderSelect"
  }, props, {
    options: [{
      text: placeholder,
      value: NO_SELECTION
    }, ...(props.options || [])],
    value: (0, _lodash.isEmpty)(props.value) ? NO_SELECTION : props.value,
    onChange: e => {
      if (props.onChange) {
        const customEvent = Object.assign(e, {
          target: Object.assign(e.target, {
            value: e.target.value === NO_SELECTION ? '' : e.target.value
          })
        });
        props.onChange(customEvent);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }));
};
exports.SelectWithPlaceholder = SelectWithPlaceholder;