"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatencyChart = LatencyChart;
exports.filterNil = filterNil;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _get_comparison_options = require("../../time_comparison/get_comparison_options");
var _latency_aggregation_types = require("../../../../../common/latency_aggregation_types");
var _formatters = require("../../../../../common/utils/formatters");
var _use_license_context = require("../../../../context/license/use_license_context");
var _use_transaction_latency_chart_fetcher = require("../../../../hooks/use_transaction_latency_chart_fetcher");
var _timeseries_chart_with_context = require("../timeseries_chart_with_context");
var _helper = require("../transaction_charts/helper");
var _ml_header = require("../transaction_charts/ml_header");
var urlHelpers = _interopRequireWildcard(require("../../links/url_helpers"));
var _get_comparison_chart_theme = require("../../time_comparison/get_comparison_chart_theme");
var _use_environments_context = require("../../../../context/environments_context/use_environments_context");
var _apm_ml_detectors = require("../../../../../common/anomaly_detection/apm_ml_detectors");
var _use_preferred_service_anomaly_timeseries = require("../../../../hooks/use_preferred_service_anomaly_timeseries");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _get_latency_chart_screen_context = require("./get_latency_chart_screen_context");
var _latency_aggregation_type_select = require("./latency_aggregation_type_select");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/latency_chart/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function filterNil(value) {
  return value != null;
}
function LatencyChart({
  height,
  kuery
}) {
  var _useApmPluginContext$;
  const history = (0, _reactRouterDom.useHistory)();
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  const license = (0, _use_license_context.useLicenseContext)();
  const {
    query: {
      comparisonEnabled,
      latencyAggregationType,
      offset
    },
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/overview', '/services/{serviceName}/transactions', '/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/overview', '/mobile-services/{serviceName}/transactions', '/mobile-services/{serviceName}/transactions/view');
  const {
    environment
  } = (0, _use_environments_context.useEnvironmentsContext)();
  const {
    transactionType,
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const transactionName = 'transactionName' in query ? query.transactionName : null;
  const {
    latencyChartsData,
    latencyChartsStatus,
    bucketSizeInSeconds,
    start,
    end
  } = (0, _use_transaction_latency_chart_fetcher.useTransactionLatencyChartsFetcher)({
    kuery,
    environment,
    transactionName,
    latencyAggregationType: (0, _latency_aggregation_types.getLatencyAggregationType)(latencyAggregationType)
  });
  const {
    currentPeriod,
    previousPeriod
  } = latencyChartsData;
  const preferredAnomalyTimeseries = (0, _use_preferred_service_anomaly_timeseries.usePreferredServiceAnomalyTimeseries)(_apm_ml_detectors.AnomalyDetectorType.txLatency);
  const anomalyTimeseriesColor = previousPeriod === null || previousPeriod === void 0 ? void 0 : previousPeriod.color;
  const timeseries = [currentPeriod, comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriod : undefined].filter(filterNil);
  const latencyMaxY = (0, _helper.getMaxY)(timeseries);
  const latencyFormatter = (0, _formatters.getDurationFormatter)(latencyMaxY);
  const setScreenContext = (_useApmPluginContext$ = (0, _use_apm_plugin_context.useApmPluginContext)().observabilityAIAssistant) === null || _useApmPluginContext$ === void 0 ? void 0 : _useApmPluginContext$.service.setScreenContext;
  (0, _react.useEffect)(() => {
    return setScreenContext === null || setScreenContext === void 0 ? void 0 : setScreenContext((0, _get_latency_chart_screen_context.getLatencyChartScreenContext)({
      serviceName,
      transactionName: transactionName !== null && transactionName !== void 0 ? transactionName : undefined,
      transactionType,
      environment,
      bucketSizeInSeconds
    }));
  }, [serviceName, transactionName, transactionType, environment, setScreenContext, bucketSizeInSeconds, start, end]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.apm.serviceOverview.latencyChartTitle', {
    defaultMessage: 'Latency'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_latency_aggregation_type_select.LatencyAggregationTypeSelect, {
    latencyAggregationType: latencyAggregationType,
    onChange: type => {
      urlHelpers.push(history, {
        query: {
          latencyAggregationType: type
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_header.MLHeader, {
    hasValidMlLicense: license === null || license === void 0 ? void 0 : license.getFeature('ml').isAvailable,
    mlJobId: preferredAnomalyTimeseries === null || preferredAnomalyTimeseries === void 0 ? void 0 : preferredAnomalyTimeseries.jobId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_context.TimeseriesChartWithContext, {
    height: height,
    fetchStatus: latencyChartsStatus,
    id: "latencyChart",
    customTheme: comparisonChartTheme,
    timeseries: timeseries,
    yLabelFormat: (0, _helper.getResponseTimeTickFormatter)(latencyFormatter),
    anomalyTimeseries: preferredAnomalyTimeseries ? {
      ...preferredAnomalyTimeseries,
      color: anomalyTimeseriesColor
    } : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  })));
}