"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GiveFeedbackHeaderLink = GiveFeedbackHeaderLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _get_path_for_feedback = require("../../../../utils/get_path_for_feedback");
var _kibana_environment_context = require("../../../../context/kibana_environment_context/kibana_environment_context");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _get_storage_explorer_links = require("../../../app/storage_explorer/get_storage_explorer_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/app_root/apm_header_action_menu/give_feedback_header_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const APM_FEEDBACK_LINK = 'https://ela.st/services-feedback';
function GiveFeedbackHeaderLink() {
  const {
    config
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    pathname
  } = window.location;
  const {
    featureFlags
  } = config;
  const kibanaEnvironment = (0, _react.useContext)(_kibana_environment_context.KibanaEnvironmentContext);
  const {
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  } = kibanaEnvironment;
  const sanitizedPath = (0, _get_path_for_feedback.getPathForFeedback)(pathname);
  const isStorageExplorerFeedback = location.pathname.includes('/storage-explorer') && featureFlags.storageExplorerAvailable;
  return isStorageExplorerFeedback ? /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    "data-test-subj": "apmGiveFeedbackLink",
    href: (0, _get_storage_explorer_links.getStorageExplorerFeedbackHref)(),
    target: "_blank",
    iconType: "popout",
    iconSide: "right",
    color: "primary",
    "aria-label": _i18n.i18n.translate('xpack.apm.views.storageExplorer.giveFeedbackAriaLabel', {
      defaultMessage: 'Give feedback on storage explorer'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.apm.views.storageExplorer.giveFeedback', {
    defaultMessage: 'Give feedback'
  })) : /*#__PURE__*/_react.default.createElement(_public.FeatureFeedbackButton, {
    "data-test-subj": "infraApmFeedbackLink",
    formUrl: APM_FEEDBACK_LINK,
    kibanaVersion: kibanaVersion,
    isCloudEnv: isCloudEnv,
    isServerlessEnv: isServerlessEnv,
    sanitizedPath: sanitizedPath,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
}