"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResourceContents = ResourceContents;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _apm = require("../../../../../common/es_fields/apm");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_map/popover/resource_contents.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ItemRow = _styled.default.div`
  line-height: 2;
`;
const SubduedDescriptionListTitle = (0, _styled.default)(_eui.EuiDescriptionListTitle)`
  &&& {
    color: ${({
  theme
}) => theme.euiTheme.colors.textSubdued};
  }
`;
function ResourceContents({
  elementData
}) {
  const nodeData = elementData;
  const subtype = nodeData[_apm.SPAN_SUBTYPE];
  const type = nodeData[_apm.SPAN_TYPE];
  const listItems = [{
    title: _i18n.i18n.translate('xpack.apm.serviceMap.typePopoverStat', {
      defaultMessage: 'Type'
    }),
    description: type
  }, {
    title: _i18n.i18n.translate('xpack.apm.serviceMap.subtypePopoverStat', {
      defaultMessage: 'Subtype'
    }),
    description: subtype
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, listItems.map(({
    title,
    description
  }) => description && /*#__PURE__*/_react.default.createElement("div", {
    key: title,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(ItemRow, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(SubduedDescriptionListTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 17
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 17
    }
  }, description)))));
}