"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmServicesTable = ApmServicesTable;
exports.getServiceColumns = getServiceColumns;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _service_health_status = require("../../../../../common/service_health_status");
var _service_inventory = require("../../../../../common/service_inventory");
var _transaction_types = require("../../../../../common/transaction_types");
var _formatters = require("../../../../../common/utils/formatters");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_breakpoints = require("../../../../hooks/use_breakpoints");
var _use_fallback_to_transactions_fetcher = require("../../../../hooks/use_fallback_to_transactions_fetcher");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _style = require("../../../../utils/style");
var _aggregated_transactions_badge = require("../../../shared/aggregated_transactions_badge");
var _get_timeseries_color = require("../../../shared/charts/helper/get_timeseries_color");
var _environment_badge = require("../../../shared/environment_badge");
var _service_link = require("../../../shared/links/apm/service_link");
var _list_metric = require("../../../shared/list_metric");
var _managed_table = require("../../../shared/managed_table");
var _column_header_with_tooltip = require("./column_header_with_tooltip");
var _health_badge = require("./health_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_inventory/service_list/apm_services_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getServiceColumns({
  query,
  showTransactionTypeColumn,
  comparisonDataLoading,
  comparisonData,
  breakpoints,
  showHealthStatusColumn,
  showAlertsColumn,
  link,
  serviceOverflowCount
}) {
  const {
    isSmall,
    isLarge,
    isXl
  } = breakpoints;
  const showWhenSmallOrGreaterThanLarge = isSmall || !isLarge;
  const showWhenSmallOrGreaterThanXL = isSmall || !isXl;
  return [...(showAlertsColumn ? [{
    field: _service_inventory.ServiceInventoryFieldName.AlertsCount,
    name: /*#__PURE__*/_react.default.createElement(_column_header_with_tooltip.ColumnHeaderWithTooltip, {
      tooltipContent: _i18n.i18n.translate('xpack.apm.servicesTable.tooltip.alertsCount', {
        defaultMessage: 'The count of the active alerts'
      }),
      label: _i18n.i18n.translate('xpack.apm.servicesTable.alertsColumnLabel', {
        defaultMessage: 'Alerts'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 15
      }
    }),
    width: `${_style.unit * 6}px`,
    sortable: true,
    render: (_, {
      serviceName,
      alertsCount
    }) => {
      if (!alertsCount) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "bottom",
        content: _i18n.i18n.translate('xpack.apm.home.servicesTable.tooltip.activeAlertsExplanation', {
          defaultMessage: 'Active alerts'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        "data-test-subj": "serviceInventoryAlertsBadgeLink",
        iconType: "warning",
        color: "danger",
        href: link('/services/{serviceName}/alerts', {
          path: {
            serviceName
          },
          query: {
            ...query,
            alertStatus: _ruleDataUtils.ALERT_STATUS_ACTIVE
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 19
        }
      }, alertsCount));
    }
  }] : []), ...(showHealthStatusColumn ? [{
    field: _service_inventory.ServiceInventoryFieldName.HealthStatus,
    name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.servicesTable.healthColumnLabel', {
      defaultMessage: 'Health'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      iconProps: {
        className: 'eui-alignTop'
      },
      position: "right",
      color: "subdued",
      content: _i18n.i18n.translate('xpack.apm.servicesTable.healthColumnLabel.tooltip', {
        defaultMessage: 'Health status is determined by the latency anomalies detected by the ML jobs specific to the selected service environment and the supported transaction types. These transaction types include "page-load", "request", and "mobile".'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 17
      }
    })),
    width: `${_style.unit * 6}px`,
    sortable: true,
    render: (_, {
      healthStatus
    }) => {
      return /*#__PURE__*/_react.default.createElement(_health_badge.HealthBadge, {
        healthStatus: healthStatus !== null && healthStatus !== void 0 ? healthStatus : _service_health_status.ServiceHealthStatus.unknown,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 22
        }
      });
    }
  }] : []), {
    field: _service_inventory.ServiceInventoryFieldName.ServiceName,
    name: _i18n.i18n.translate('xpack.apm.servicesTable.nameColumnLabel', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    render: (_, {
      serviceName,
      agentName,
      transactionType
    }) => /*#__PURE__*/_react.default.createElement(_service_link.ServiceLink, {
      agentName: agentName,
      query: {
        ...query,
        transactionType
      },
      serviceName: serviceName,
      serviceOverflowCount: serviceOverflowCount,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 9
      }
    })
  }, ...(showWhenSmallOrGreaterThanLarge ? [{
    field: _service_inventory.ServiceInventoryFieldName.Environments,
    name: _i18n.i18n.translate('xpack.apm.servicesTable.environmentColumnLabel', {
      defaultMessage: 'Environment'
    }),
    width: `${_style.unit * 9}px`,
    sortable: true,
    render: (_, {
      environments
    }) => /*#__PURE__*/_react.default.createElement(_environment_badge.EnvironmentBadge, {
      environments: environments !== null && environments !== void 0 ? environments : [],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 46
      }
    })
  }] : []), ...(showTransactionTypeColumn && showWhenSmallOrGreaterThanXL ? [{
    field: _service_inventory.ServiceInventoryFieldName.TransactionType,
    name: _i18n.i18n.translate('xpack.apm.servicesTable.transactionColumnLabel', {
      defaultMessage: 'Transaction type'
    }),
    width: `${_style.unit * 8}px`,
    sortable: true
  }] : []), {
    field: _service_inventory.ServiceInventoryFieldName.Latency,
    name: _i18n.i18n.translate('xpack.apm.servicesTable.latencyAvgColumnLabel', {
      defaultMessage: 'Latency (avg.)'
    }),
    sortable: true,
    dataType: 'number',
    render: (_, {
      serviceName,
      latency
    }) => {
      var _comparisonData$curre, _comparisonData$previ;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LATENCY_AVG);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        isLoading: comparisonDataLoading,
        series: comparisonData === null || comparisonData === void 0 ? void 0 : (_comparisonData$curre = comparisonData.currentPeriod[serviceName]) === null || _comparisonData$curre === void 0 ? void 0 : _comparisonData$curre.latency,
        comparisonSeries: comparisonData === null || comparisonData === void 0 ? void 0 : (_comparisonData$previ = comparisonData.previousPeriod[serviceName]) === null || _comparisonData$previ === void 0 ? void 0 : _comparisonData$previ.latency,
        hideSeries: !showWhenSmallOrGreaterThanLarge,
        color: currentPeriodColor,
        valueLabel: (0, _formatters.asMillisecondDuration)(latency || 0),
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 220,
          columnNumber: 11
        }
      });
    },
    align: _eui.RIGHT_ALIGNMENT
  }, {
    field: _service_inventory.ServiceInventoryFieldName.Throughput,
    name: _i18n.i18n.translate('xpack.apm.servicesTable.throughputColumnLabel', {
      defaultMessage: 'Throughput'
    }),
    sortable: true,
    dataType: 'number',
    render: (_, {
      serviceName,
      throughput
    }) => {
      var _comparisonData$curre2, _comparisonData$previ2;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.THROUGHPUT);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        isLoading: comparisonDataLoading,
        series: comparisonData === null || comparisonData === void 0 ? void 0 : (_comparisonData$curre2 = comparisonData.currentPeriod[serviceName]) === null || _comparisonData$curre2 === void 0 ? void 0 : _comparisonData$curre2.throughput,
        comparisonSeries: comparisonData === null || comparisonData === void 0 ? void 0 : (_comparisonData$previ2 = comparisonData.previousPeriod[serviceName]) === null || _comparisonData$previ2 === void 0 ? void 0 : _comparisonData$previ2.throughput,
        hideSeries: !showWhenSmallOrGreaterThanLarge,
        color: currentPeriodColor,
        valueLabel: (0, _formatters.asTransactionRate)(throughput),
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 246,
          columnNumber: 11
        }
      });
    },
    align: _eui.RIGHT_ALIGNMENT
  }, {
    field: _service_inventory.ServiceInventoryFieldName.TransactionErrorRate,
    name: _i18n.i18n.translate('xpack.apm.servicesTable.transactionErrorRate', {
      defaultMessage: 'Failed transaction rate'
    }),
    sortable: true,
    dataType: 'number',
    render: (_, {
      serviceName,
      transactionErrorRate
    }) => {
      var _comparisonData$curre3, _comparisonData$previ3;
      const valueLabel = (0, _formatters.asPercent)(transactionErrorRate, 1);
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.FAILED_TRANSACTION_RATE);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        isLoading: comparisonDataLoading,
        series: comparisonData === null || comparisonData === void 0 ? void 0 : (_comparisonData$curre3 = comparisonData.currentPeriod[serviceName]) === null || _comparisonData$curre3 === void 0 ? void 0 : _comparisonData$curre3.transactionErrorRate,
        comparisonSeries: comparisonData === null || comparisonData === void 0 ? void 0 : (_comparisonData$previ3 = comparisonData.previousPeriod[serviceName]) === null || _comparisonData$previ3 === void 0 ? void 0 : _comparisonData$previ3.transactionErrorRate,
        hideSeries: !showWhenSmallOrGreaterThanLarge,
        color: currentPeriodColor,
        valueLabel: valueLabel,
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 272,
          columnNumber: 11
        }
      });
    },
    align: _eui.RIGHT_ALIGNMENT
  }];
}
function ApmServicesTable({
  status,
  items,
  noItemsMessage,
  comparisonDataLoading,
  comparisonData,
  displayHealthStatus,
  displayAlerts,
  initialSortField,
  initialSortDirection,
  initialPageSize,
  sortFn,
  serviceOverflowCount,
  maxCountExceeded,
  onChangeSearchQuery,
  onChangeRenderedItems,
  onChangeItemIndices
}) {
  const breakpoints = (0, _use_breakpoints.useBreakpoints)();
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    link
  } = (0, _use_apm_router.useApmRouter)();
  const showTransactionTypeColumn = items.some(({
    transactionType
  }) => transactionType && !(0, _transaction_types.isDefaultTransactionType)(transactionType));
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/services');
  const {
    kuery
  } = query;
  const {
    fallbackToTransactions
  } = (0, _use_fallback_to_transactions_fetcher.useFallbackToTransactionsFetcher)({
    kuery
  });
  const serviceColumns = (0, _react.useMemo)(() => {
    return getServiceColumns({
      // removes pagination and sort instructions from the query so it won't be passed down to next route
      query: (0, _lodash.omit)(query, 'page', 'pageSize', 'sortDirection', 'sortField'),
      showTransactionTypeColumn,
      comparisonDataLoading,
      comparisonData,
      breakpoints,
      showHealthStatusColumn: displayHealthStatus,
      showAlertsColumn: displayAlerts,
      link,
      serviceOverflowCount
    });
  }, [query, showTransactionTypeColumn, comparisonDataLoading, comparisonData, breakpoints, displayHealthStatus, displayAlerts, link, serviceOverflowCount]);
  const isTableSearchBarEnabled = core.uiSettings.get(_common.apmEnableServiceInventoryTableSearchBar, true);
  const tableSearchBar = (0, _react.useMemo)(() => {
    return {
      isEnabled: isTableSearchBarEnabled,
      fieldsToSearch: ['serviceName'],
      maxCountExceeded,
      onChangeSearchQuery,
      placeholder: _i18n.i18n.translate('xpack.apm.servicesTable.filterServicesPlaceholder', {
        defaultMessage: 'Search services by name'
      }),
      techPreview: true
    };
  }, [isTableSearchBarEnabled, maxCountExceeded, onChangeSearchQuery]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 9
    }
  }, fallbackToTransactions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_aggregated_transactions_badge.AggregatedTransactionsBadge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 15
    }
  })), maxCountExceeded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "top",
    type: "warning",
    color: "danger",
    content: _i18n.i18n.translate('xpack.apm.servicesTable.tooltip.maxCountExceededWarning', {
      defaultMessage: 'The limit of 1,000 services is exceeded. Please use the query bar to narrow down the results or create service groups.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "top",
    type: "question",
    color: "subdued",
    content: _i18n.i18n.translate('xpack.apm.servicesTable.tooltip.metricsExplanation', {
      defaultMessage: 'Service metrics are aggregated on their transaction type, which can be request or page-load. If neither exists, metrics are aggregated on the top available transaction type.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.servicesTable.metricsExplanationLabel', {
    defaultMessage: 'What are these metrics?'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    isLoading: (0, _use_fetcher.isPending)(status),
    error: (0, _use_fetcher.isFailure)(status),
    columns: serviceColumns,
    items: items,
    noItemsMessage: noItemsMessage,
    initialSortField: initialSortField,
    initialSortDirection: initialSortDirection,
    initialPageSize: initialPageSize,
    sortFn: sortFn,
    onChangeRenderedItems: onChangeRenderedItems,
    onChangeItemIndices: onChangeItemIndices,
    tableSearchBar: tableSearchBar,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 9
    }
  })));
}