"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticsIndexPatternSettings = DiagnosticsIndexPatternSettings;
exports.getIsIndexPatternTabOk = getIsIndexPatternTabOk;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_diagnostics = require("./context/use_diagnostics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/diagnostics/index_pattern_settings_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DiagnosticsIndexPatternSettings() {
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    diagnosticsBundle,
    status
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  if (status === _use_fetcher.FETCH_STATUS.LOADING) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 12
      }
    });
  }
  const indexTemplatesByIndexPattern = diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.indexTemplatesByIndexPattern;
  if (!indexTemplatesByIndexPattern || (indexTemplatesByIndexPattern === null || indexTemplatesByIndexPattern === void 0 ? void 0 : indexTemplatesByIndexPattern.length) === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 12
      }
    }, "No settings to display");
  }
  const elms = indexTemplatesByIndexPattern.map(({
    indexPattern,
    indexTemplates
  }) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: indexPattern,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 11
      }
    }, indexPattern)), !(indexTemplates !== null && indexTemplates !== void 0 && indexTemplates.length) && /*#__PURE__*/_react.default.createElement("em", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 37
      }
    }, "No matching index templates"), indexTemplates === null || indexTemplates === void 0 ? void 0 : indexTemplates.map(({
      templateName,
      templateIndexPatterns,
      priority,
      isNonStandard
    }) => {
      const text = priority ? `(Priority: ${priority})` : isNonStandard ? `(legacy template)` : '';
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        key: templateName,
        content: `${templateIndexPatterns.join(', ')} ${text}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: isNonStandard ? 'warning' : 'hollow',
        css: {
          marginRight: '5px',
          marginTop: '5px'
        },
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 15
        }
      }, templateName));
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }));
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, "This section lists the index patterns specified in", ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmMatchingIndexTemplatesSeeDetailsLink",
    href: router.link('/settings/apm-indices'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, "APM Index Settings"), ' ', "and which index templates they match. The priority and index pattern of each index template can be seen by hovering over the item."), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), elms);
}
function getIsIndexPatternTabOk(diagnosticsBundle) {
  if (!diagnosticsBundle) {
    return true;
  }
  const hasError = diagnosticsBundle.indexTemplatesByIndexPattern.some(({
    indexTemplates
  }) => indexTemplates.some(({
    isNonStandard
  }) => isNonStandard));
  return !hasError;
}