"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.create = create;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _audit_events = require("../../../../lib/audit_events");
var _lib = require("../../../../lib");
var _lib2 = require("../../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function create({
  context,
  action: {
    actionTypeId,
    name,
    config,
    secrets
  },
  options
}) {
  var _actionType$validate, _context$auditLogger3;
  const id = (options === null || options === void 0 ? void 0 : options.id) || _server.SavedObjectsUtils.generateId();
  try {
    await context.authorization.ensureAuthorized({
      operation: 'create',
      actionTypeId
    });
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.connectorAuditEvent)({
      action: _audit_events.ConnectorAuditAction.CREATE,
      savedObject: {
        type: 'action',
        id
      },
      error
    }));
    throw error;
  }
  const foundInMemoryConnector = context.inMemoryConnectors.find(connector => connector.id === id);
  if (context.actionTypeRegistry.isSystemActionType(actionTypeId) || foundInMemoryConnector !== null && foundInMemoryConnector !== void 0 && foundInMemoryConnector.isSystemAction) {
    throw _boom.default.badRequest(_i18n.i18n.translate('xpack.actions.serverSideErrors.systemActionCreationForbidden', {
      defaultMessage: 'System action creation is forbidden. Action type: {actionTypeId}.',
      values: {
        actionTypeId
      }
    }));
  }
  if (foundInMemoryConnector !== null && foundInMemoryConnector !== void 0 && foundInMemoryConnector.isPreconfigured) {
    throw _boom.default.badRequest(_i18n.i18n.translate('xpack.actions.serverSideErrors.predefinedIdConnectorAlreadyExists', {
      defaultMessage: 'This {id} already exists in a preconfigured action.',
      values: {
        id
      }
    }));
  }
  const actionType = context.actionTypeRegistry.get(actionTypeId);
  const configurationUtilities = context.actionTypeRegistry.getUtils();
  const validatedActionTypeConfig = (0, _lib.validateConfig)(actionType, config, {
    configurationUtilities
  });
  const validatedActionTypeSecrets = (0, _lib.validateSecrets)(actionType, secrets, {
    configurationUtilities
  });
  if ((_actionType$validate = actionType.validate) !== null && _actionType$validate !== void 0 && _actionType$validate.connector) {
    (0, _lib.validateConnector)(actionType, {
      config,
      secrets
    });
  }
  context.actionTypeRegistry.ensureActionTypeEnabled(actionTypeId);
  const hookServices = {
    scopedClusterClient: context.scopedClusterClient
  };
  if (actionType.preSaveHook) {
    try {
      await actionType.preSaveHook({
        connectorId: id,
        config,
        secrets,
        logger: context.logger,
        request: context.request,
        services: hookServices,
        isUpdate: false
      });
    } catch (error) {
      var _context$auditLogger2;
      (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.connectorAuditEvent)({
        action: _audit_events.ConnectorAuditAction.CREATE,
        savedObject: {
          type: 'action',
          id
        },
        error
      }));
      throw error;
    }
  }
  (_context$auditLogger3 = context.auditLogger) === null || _context$auditLogger3 === void 0 ? void 0 : _context$auditLogger3.log((0, _audit_events.connectorAuditEvent)({
    action: _audit_events.ConnectorAuditAction.CREATE,
    savedObject: {
      type: 'action',
      id
    },
    outcome: 'unknown'
  }));
  const result = await (0, _lib.tryCatch)(async () => await context.unsecuredSavedObjectsClient.create('action', {
    actionTypeId,
    name,
    isMissingSecrets: false,
    config: validatedActionTypeConfig,
    secrets: validatedActionTypeSecrets
  }, {
    id
  }));
  const wasSuccessful = !(result instanceof Error);
  const label = `connectorId: "${id}"; type: ${actionTypeId}`;
  const tags = ['post-save-hook', id];
  if (actionType.postSaveHook) {
    try {
      await actionType.postSaveHook({
        connectorId: id,
        config,
        secrets,
        logger: context.logger,
        request: context.request,
        services: hookServices,
        isUpdate: false,
        wasSuccessful
      });
    } catch (err) {
      context.logger.error(`postSaveHook create error for ${label}: ${err.message}`, {
        tags
      });
    }
  }
  if (!wasSuccessful) {
    throw result;
  }
  return {
    id: result.id,
    actionTypeId: result.attributes.actionTypeId,
    isMissingSecrets: result.attributes.isMissingSecrets,
    name: result.attributes.name,
    config: result.attributes.config,
    isPreconfigured: false,
    isSystemAction: false,
    isDeprecated: (0, _lib2.isConnectorDeprecated)(result.attributes),
    isConnectorTypeDeprecated: context.actionTypeRegistry.isDeprecated(actionTypeId)
  };
}