"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cloneResolvedValueBinding = cloneResolvedValueBinding;
const cloneBindingCache_1 = require("./cloneBindingCache");
/**
 * Clones a ResolvedValueBinding
 */
function cloneResolvedValueBinding(binding) {
    return {
        cache: (0, cloneBindingCache_1.cloneBindingCache)(binding.cache),
        factory: binding.factory,
        id: binding.id,
        isSatisfiedBy: binding.isSatisfiedBy,
        metadata: binding.metadata,
        moduleId: binding.moduleId,
        onActivation: binding.onActivation,
        onDeactivation: binding.onDeactivation,
        scope: binding.scope,
        serviceIdentifier: binding.serviceIdentifier,
        type: binding.type,
    };
}
//# sourceMappingURL=cloneResolvedValueBinding.js.map