"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableHeaderCell = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _accessibility = require("../accessibility");
var _icon = require("../icon");
var _inner_text = require("../inner_text");
var _tool_tip = require("../tool_tip");
var _utils = require("./utils");
var _responsive_context = require("./mobile/responsive_context");
var _table_cell_content = require("./_table_cell_content");
var _table_cells_shared = require("./table_cells_shared.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "align", "onSort", "isSorted", "isSortAscending", "className", "scope", "mobileOptions", "width", "style", "readOnly", "tooltipProps", "description", "append"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var CellContents = function CellContents(_ref) {
  var className = _ref.className,
    align = _ref.align,
    tooltipProps = _ref.tooltipProps,
    description = _ref.description,
    children = _ref.children,
    canSort = _ref.canSort,
    isSorted = _ref.isSorted,
    isSortAscending = _ref.isSortAscending;
  var tooltipIcon = tooltipProps ? canSort ? (0, _react2.jsx)(_icon.EuiIcon, _extends({
    className: "euiTableSortIcon",
    type: tooltipProps.icon || 'question',
    size: "m",
    color: "subdued"
  }, tooltipProps.iconProps)) : (0, _react2.jsx)(_tool_tip.EuiIconTip, _extends({
    content: tooltipProps.content,
    type: tooltipProps.icon || 'question',
    size: "m",
    color: "subdued",
    position: "top",
    iconProps: _objectSpread({
      role: 'button'
    }, tooltipProps.iconProps)
  }, tooltipProps.tooltipProps)) : null;
  return (0, _react2.jsx)(_table_cell_content.EuiTableCellContent, {
    className: className,
    align: align,
    textOnly: false,
    truncateText: null
  }, (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
    return (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiTableHeaderCell.titleTextWithDesc",
      default: "{innerText}; {description}",
      values: {
        innerText: innerText,
        description: description
      }
    }, function (titleTextWithDesc) {
      return (0, _react2.jsx)("span", {
        title: description ? titleTextWithDesc : innerText,
        ref: ref,
        className: "eui-textTruncate"
      }, children);
    });
  }), description && (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, description)), tooltipIcon, isSorted ? (0, _react2.jsx)(_icon.EuiIcon, {
    className: "euiTableSortIcon",
    type: isSortAscending ? 'sortUp' : 'sortDown',
    size: "m"
  }) : canSort ? (0, _react2.jsx)(_icon.EuiIcon, {
    className: "euiTableSortIcon euiTableSortIcon--sortable",
    type: "sortable",
    size: "m",
    color: "subdued" // Tinted a bit further via CSS
  }) : null);
};
var EuiTableHeaderCell = exports.EuiTableHeaderCell = function EuiTableHeaderCell(_ref2) {
  var children = _ref2.children,
    _ref2$align = _ref2.align,
    align = _ref2$align === void 0 ? _services.LEFT_ALIGNMENT : _ref2$align,
    onSort = _ref2.onSort,
    isSorted = _ref2.isSorted,
    isSortAscending = _ref2.isSortAscending,
    className = _ref2.className,
    scope = _ref2.scope,
    mobileOptions = _ref2.mobileOptions,
    width = _ref2.width,
    style = _ref2.style,
    readOnly = _ref2.readOnly,
    tooltipProps = _ref2.tooltipProps,
    description = _ref2.description,
    append = _ref2.append,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_table_cells_shared.euiTableHeaderFooterCellStyles);
  var isResponsive = (0, _responsive_context.useEuiTableIsResponsive)();
  var hideForDesktop = !isResponsive && (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.only);
  var hideForMobile = isResponsive && (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.show) === false;
  if (hideForDesktop || hideForMobile) return null;
  var classes = (0, _classnames.default)('euiTableHeaderCell', className);
  var inlineStyles = (0, _utils.resolveWidthAsStyle)(style, width);
  var CellComponent = children ? 'th' : 'td';
  var cellScope = CellComponent === 'th' ? scope !== null && scope !== void 0 ? scope : 'col' : undefined; // `scope` is only valid on `th` elements

  var canSort = !!(onSort && !readOnly);
  var ariaSortValue;
  if (isSorted) {
    ariaSortValue = isSortAscending ? 'ascending' : 'descending';
  } else if (canSort) {
    ariaSortValue = 'none';
  }
  var cellContentsProps = {
    css: styles.euiTableHeaderCell__content,
    align: align,
    tooltipProps: tooltipProps,
    description: description,
    canSort: canSort,
    isSorted: isSorted,
    isSortAscending: isSortAscending,
    children: children
  };
  return (0, _react2.jsx)(CellComponent, _extends({
    css: styles.euiTableHeaderCell,
    className: classes,
    scope: cellScope,
    role: "columnheader",
    "aria-sort": ariaSortValue,
    style: inlineStyles
  }, rest), canSort ? (0, _react2.jsx)(_tool_tip.EuiToolTip, _extends({
    content: tooltipProps === null || tooltipProps === void 0 ? void 0 : tooltipProps.content
  }, tooltipProps === null || tooltipProps === void 0 ? void 0 : tooltipProps.tooltipProps, {
    display: "block"
  }), (0, _react2.jsx)("button", {
    type: "button",
    css: styles.euiTableHeaderCell__button,
    className: (0, _classnames.default)('euiTableHeaderButton', {
      'euiTableHeaderButton-isSorted': isSorted
    }),
    onClick: onSort,
    "data-test-subj": "tableHeaderSortButton"
  }, (0, _react2.jsx)(CellContents, cellContentsProps))) : (0, _react2.jsx)(CellContents, cellContentsProps), append);
};
EuiTableHeaderCell.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  align: _propTypes.default.any,
  isSortAscending: _propTypes.default.bool,
  isSorted: _propTypes.default.bool,
  mobileOptions: _propTypes.default.any,
  onSort: _propTypes.default.func,
  scope: _propTypes.default.any,
  width: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]),
  /** Allows adding an icon with a tooltip displayed next to the name */tooltipProps: _propTypes.default.shape({
    /** The main content of the tooltip */content: _propTypes.default.node.isRequired,
    /**
       * The icon type to display
       * @default 'question'
       */
    icon: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "alert", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "backgroundTask", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkCircle", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "code", "codeApp", "color", "comment", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controls", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "export", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flask", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "info", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plugs", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "question", "quote", "readOnly", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "streamsClassic", "streamsWired", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "thumbDown", "thumbUp", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "watchesApp", "web", "wordWrap", "wordWrapDisabled", "workflowsApp", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
    /** Additional props for EuiIcon */iconProps: _propTypes.default.any,
    /** Additional props for the EuiToolip */tooltipProps: _propTypes.default.shape({
      /**
         * Passes onto the span wrapping the trigger.
         */
      anchorClassName: _propTypes.default.string,
      /**
         * Passes onto the span wrapping the trigger.
         */
      anchorProps: _propTypes.default.shape({
        className: _propTypes.default.string,
        "aria-label": _propTypes.default.string,
        "data-test-subj": _propTypes.default.string,
        css: _propTypes.default.any
      }),
      /**
         * Passes onto the tooltip itself, not the trigger.
         */
      className: _propTypes.default.string,
      /**
         * The main content of your tooltip.
         */
      content: _propTypes.default.node,
      /**
         * Common display alternatives for the anchor wrapper
         */
      display: _propTypes.default.any,
      /**
         * An optional title for your tooltip.
         */
      title: _propTypes.default.node,
      /**
         * Unless you provide one, this will be randomly generated.
         */
      id: _propTypes.default.string,
      /**
         * When `true`, the tooltip's position is re-calculated when the user
         * scrolls. This supports having fixed-position tooltip anchors.
         *
         * When nesting an `EuiTooltip` in a scrollable container, `repositionOnScroll` should be `true`
         */
      repositionOnScroll: _propTypes.default.bool,
      /**
         * Disables the tooltip content being read by screen readers when focusing the trigger element.
         * Do not use when the trigger `aria-label` and tooltip `content` can be rephrased to be standalone
         * information (action & additional information).
         * Enable this prop only when the trigger has a descriptive label that either duplicates or includes
         * the tooltip content and would result in repetitive output.
         * @default false
         */
      disableScreenReaderOutput: _propTypes.default.bool,
      /**
         * If supplied, called when mouse movement causes the tool tip to be
         * hidden.
         */
      onMouseOut: _propTypes.default.func,
      /**
         * Offset in pixels from the anchor. Defaults to 16.
         */
      offset: _propTypes.default.number,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any,
      delay: _propTypes.default.any,
      position: _propTypes.default.any
    })
  }),
  description: _propTypes.default.string,
  /**
       * Shows the sort indicator but removes the button
       */
  readOnly: _propTypes.default.bool,
  /**
       * Content rendered outside the visible cell content wrapper. Useful for, e.g. screen reader text.
       *
       * Used by EuiBasicTable to render hidden copy markers
       */
  append: _propTypes.default.node
};