"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSuperDatePickerStyles = exports._buttonStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _high_contrast = require("../../../global_styling/functions/high_contrast");
var _form = require("../../form/form.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1e4qgxg-euiSuperDatePicker__range",
  styles: "flex-grow:1;overflow:hidden;label:euiSuperDatePicker__range;"
} : {
  name: "1e4qgxg-euiSuperDatePicker__range",
  styles: "flex-grow:1;overflow:hidden;label:euiSuperDatePicker__range;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiSuperDatePickerStyles = exports.euiSuperDatePickerStyles = function euiSuperDatePickerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var forms = (0, _form.euiFormVariables)(euiThemeContext);
  var inputWidth = euiTheme.base * 30;
  var buttonWidth = euiTheme.base * 7; // @see _button_display.styles.ts
  var gap = euiTheme.size.s;

  // Default restricted width
  var restrictedWidth = (0, _global_styling.mathWithUnits)(gap, function (gap) {
    return inputWidth + gap + buttonWidth;
  });

  // Set a sensible min-width for when width is auto
  var minFormWidth = parseFloat(forms.maxWidth) / 2;
  var autoMinWidth = (0, _global_styling.mathWithUnits)(gap, function (gap) {
    return minFormWidth + gap + buttonWidth;
  });

  // Needs updating colors
  var needsUpdatingBackgroundColor = euiTheme.components.superDatePickerBackgroundSuccees;
  var needsUpdatingTextColor = (0, _services.makeHighContrastColor)(euiTheme.colors.success)(needsUpdatingBackgroundColor);
  return {
    euiSuperDatePicker: /*#__PURE__*/(0, _react.css)("display:flex;gap:", gap, ";", (0, _global_styling.logicalCSS)('max-width', '100%'), " ", (0, _global_styling.euiMaxBreakpoint)(euiThemeContext, 'm'), "{", (0, _global_styling.logicalCSS)('width', '100%'), ";};label:euiSuperDatePicker;"),
    widths: {
      restricted: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', restrictedWidth), ";;label:restricted;"),
      full: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), ";;label:full;"),
      auto: /*#__PURE__*/(0, _react.css)("display:inline-flex;", (0, _global_styling.logicalCSS)('min-width', "min(".concat(autoMinWidth, ", 100%)")), " ", (0, _global_styling.logicalCSS)('width', 'auto'), ";;label:auto;")
    },
    // Special rendering cases that override all permutations of the above widths
    noUpdateButton: {
      // Skipping css`` and using the `label` key instead to reduce repeat Emotion generated classNames
      restricted: "\n        label: noUpdateButton;\n        ".concat((0, _global_styling.logicalCSS)('width', "".concat(inputWidth, "px")), ";\n      "),
      auto: "\n        label: noUpdateButton;\n        ".concat((0, _global_styling.logicalCSS)('min-width', "min(".concat(minFormWidth, "px, 100%)")), ";\n      "),
      full: "\n        label: noUpdateButton;\n      "
    },
    isAutoRefreshOnly: {
      // display: block over flex is required to have the nested .euiPopover wrap expand to the wrapper width
      restricted: "\n        label: isAutoRefreshOnly;\n        display: block;\n        ".concat((0, _global_styling.logicalCSS)('width', forms.maxWidth), "\n      "),
      auto: "\n        label: isAutoRefreshOnly;\n      ",
      full: "\n        label: isAutoRefreshOnly;\n        display: block;\n      "
    },
    // isQuickSelectOnly forces `width` to be `auto`
    isQuickSelectOnly: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', 0), ".euiFormControlLayout__prepend{", (0, _global_styling.logicalCSS)('max-width', 'none'), ";}.euiFormControlLayoutDelimited__delimiter:first-child{", (0, _global_styling.logicalCSS)('padding-horizontal', 0), ";};label:isQuickSelectOnly;"),
    euiSuperDatePicker__range: _ref,
    euiSuperDatePicker__rangeInput: /*#__PURE__*/(0, _react.css)("flex-grow:1;", (0, _global_styling.logicalCSS)('width', 'auto'), " overflow:hidden;;label:euiSuperDatePicker__rangeInput;"),
    euiSuperDatePicker__prettyFormat: /*#__PURE__*/(0, _react.css)(_buttonStyles(euiThemeContext), " text-align:start;--euiFormControlStateHoverColor:", forms.borderHovered, ";", (0, _form.euiFormControlDefaultShadow)(euiThemeContext), " &:focus{", (0, _form.euiFormControlFocusStyles)(euiThemeContext), ";}", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      preferred: "\n          border: none;\n        "
    }), ";;label:euiSuperDatePicker__prettyFormat;"),
    // Form states
    states: {
      euiSuperDatePicker__formControlLayout: /*#__PURE__*/(0, _react.css)(".euiFormControlLayout__childrenWrapper{--euiFormControlStateHoverColor:", forms.borderHovered, ";", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
        none: "\n              ".concat((0, _form.euiFormControlDefaultShadow)(euiThemeContext), "\n              box-shadow: none;\n            "),
        preferred: 'border: none;'
      }), ".euiDatePopoverButton:not(.euiDatePopoverButton-isSelected):hover{outline:none;}.euiPopover{border-radius:", forms.controlBorderRadius, ";&:first-child{", (0, _global_styling.logicalCSS)('border-top-left-radius', 'inherit'), " ", (0, _global_styling.logicalCSS)('border-bottom-left-radius', 'inherit'), ";}&:last-child{", (0, _global_styling.logicalCSS)('border-top-right-radius', 'inherit'), " ", (0, _global_styling.logicalCSS)('border-bottom-right-radius', 'inherit'), ";}}.euiDatePopoverButton{background-color:transparent;border-radius:inherit;}};label:euiSuperDatePicker__formControlLayout;"),
      default: /*#__PURE__*/(0, _react.css)(".euiFormControlLayout__childrenWrapper{color:", forms.textColor, ";background-color:", forms.backgroundColor, ";}.euiDatePopoverButton{--euiFormControlStateHoverColor:", forms.borderHovered, ";box-shadow:none;}.euiDatePopoverButton:focus,.euiPopover-isOpen .euiDatePopoverButton{", (0, _form.euiFormControlFocusStyles)(euiThemeContext), ";};label:default;"),
      disabled: /*#__PURE__*/(0, _react.css)(".euiFormControlLayout__childrenWrapper{", (0, _form.euiFormControlDisabledStyles)(euiThemeContext), ";};label:disabled;"),
      invalid: /*#__PURE__*/(0, _react.css)(".euiFormControlLayout__childrenWrapper{color:", euiTheme.colors.textDanger, ";background-color:", forms.backgroundColor, ";&:has(.euiPopover-isOpen, .euiDatePopoverButton:focus){--euiFormControlStateColor:", forms.borderColor, ";--euiFormControlStateHoverColor:", forms.borderHovered, ";}&:not(:has(.euiPopover-isOpen, .euiDatePopoverButton:focus)){", (0, _form.euiFormControlInvalidStyles)(euiThemeContext), ";}.euiDatePopoverButton:focus,.euiPopover-isOpen .euiDatePopoverButton{", (0, _form.euiFormControlFocusStyles)(euiThemeContext), ";}};label:invalid;"),
      needsUpdating: /*#__PURE__*/(0, _react.css)(".euiFormControlLayout__childrenWrapper{--euiFormControlStateColor:", euiTheme.colors.success, ";--euiFormControlStateHoverColor:", euiTheme.colors.success, ";--euiFormControlStateWidth:", euiTheme.border.width.thin, ";color:", needsUpdatingTextColor, ";background-color:", needsUpdatingBackgroundColor, ";", _form.euiFormControlHighlightBorderStyles, " &:has(.euiPopover-isOpen),&:focus-within{--euiFormControlStateColor:", forms.borderColor, ";--euiFormControlStateHoverColor:", forms.borderHovered, ";}}.euiFormControlLayoutDelimited__delimiter{color:inherit;}.euiDatePopoverButton{", (0, _form.euiFormControlDefaultShadow)(euiThemeContext, {
        withBorder: false,
        withBackgroundColor: false
      }), " background-color:inherit;box-shadow:none;}.euiDatePopoverButton:focus,.euiPopover-isOpen .euiDatePopoverButton{", (0, _form.euiFormControlFocusStyles)(euiThemeContext), ";};label:needsUpdating;")
    }
  };
};
var _buttonStyles = exports._buttonStyles = function _buttonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', '100%'), " ", (0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.s), " font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize, ";white-space:nowrap;text-overflow:ellipsis;overflow:hidden;color:inherit;background-color:inherit;&:disabled{cursor:not-allowed;}");
};