"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiComboBoxPill = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _badge = require("../../badge");
var _i18n = require("../../i18n");
var _utils = require("../utils");
var _combo_box_pill = require("./combo_box_pill.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "color", "onClick", "onClickAriaLabel", "onClose", "option"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiComboBoxPill = exports.EuiComboBoxPill = function EuiComboBoxPill(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'hollow' : _ref$color,
    onClick = _ref.onClick,
    onClickAriaLabel = _ref.onClickAriaLabel,
    onClose = _ref.onClose,
    option = _ref.option,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiComboBoxPill', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_combo_box_pill.euiComboBoxPillStyles);
  var cssStyles = styles.euiComboBoxPill;
  var onClickProps = onClick && onClickAriaLabel ? {
    onClick: onClick,
    onClickAriaLabel: onClickAriaLabel
  } : {};
  var content = (0, _react2.jsx)(_utils.EuiComboBoxOptionAppendPrepend, {
    option: option,
    classNamePrefix: "euiComboBoxPill"
  }, (0, _react2.jsx)("span", {
    className: "eui-textTruncate"
  }, children));
  if (onClose) {
    return (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiComboBoxPill.removeSelection",
      default: "Remove {children} from selection in this group",
      values: {
        children: children
      }
    }, function (removeSelection) {
      return (0, _react2.jsx)(_badge.EuiBadge, _extends({
        css: cssStyles,
        className: classes,
        color: color,
        "data-test-subj": "euiComboBoxPill",
        iconOnClick: function iconOnClick() {
          return onClose(option);
        },
        iconOnClickAriaLabel: removeSelection,
        iconSide: "right",
        iconType: "cross",
        title: children
      }, onClickProps, rest), content);
    });
  }
  return (0, _react2.jsx)(_badge.EuiBadge, _extends({
    css: cssStyles,
    className: classes,
    color: color,
    "data-test-subj": "euiComboBoxPill",
    title: children
  }, rest, onClickProps), content);
};