"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  AccessDeniedException: () => AccessDeniedException,
  AdditionalResultAttributeValueType: () => AdditionalResultAttributeValueType,
  AlfrescoEntity: () => AlfrescoEntity,
  AssociateEntitiesToExperienceCommand: () => AssociateEntitiesToExperienceCommand,
  AssociatePersonasToEntitiesCommand: () => AssociatePersonasToEntitiesCommand,
  AttributeSuggestionsMode: () => AttributeSuggestionsMode,
  BatchDeleteDocumentCommand: () => BatchDeleteDocumentCommand,
  BatchDeleteFeaturedResultsSetCommand: () => BatchDeleteFeaturedResultsSetCommand,
  BatchGetDocumentStatusCommand: () => BatchGetDocumentStatusCommand,
  BatchPutDocumentCommand: () => BatchPutDocumentCommand,
  ClearQuerySuggestionsCommand: () => ClearQuerySuggestionsCommand,
  ConditionOperator: () => ConditionOperator,
  ConflictException: () => ConflictException,
  ConfluenceAttachmentFieldName: () => ConfluenceAttachmentFieldName,
  ConfluenceAuthenticationType: () => ConfluenceAuthenticationType,
  ConfluenceBlogFieldName: () => ConfluenceBlogFieldName,
  ConfluencePageFieldName: () => ConfluencePageFieldName,
  ConfluenceSpaceFieldName: () => ConfluenceSpaceFieldName,
  ConfluenceVersion: () => ConfluenceVersion,
  ContentType: () => ContentType,
  CreateAccessControlConfigurationCommand: () => CreateAccessControlConfigurationCommand,
  CreateDataSourceCommand: () => CreateDataSourceCommand,
  CreateExperienceCommand: () => CreateExperienceCommand,
  CreateFaqCommand: () => CreateFaqCommand,
  CreateFeaturedResultsSetCommand: () => CreateFeaturedResultsSetCommand,
  CreateIndexCommand: () => CreateIndexCommand,
  CreateIndexRequestFilterSensitiveLog: () => CreateIndexRequestFilterSensitiveLog,
  CreateQuerySuggestionsBlockListCommand: () => CreateQuerySuggestionsBlockListCommand,
  CreateThesaurusCommand: () => CreateThesaurusCommand,
  DataSourceStatus: () => DataSourceStatus,
  DataSourceSyncJobStatus: () => DataSourceSyncJobStatus,
  DataSourceType: () => DataSourceType,
  DatabaseEngineType: () => DatabaseEngineType,
  DeleteAccessControlConfigurationCommand: () => DeleteAccessControlConfigurationCommand,
  DeleteDataSourceCommand: () => DeleteDataSourceCommand,
  DeleteExperienceCommand: () => DeleteExperienceCommand,
  DeleteFaqCommand: () => DeleteFaqCommand,
  DeleteIndexCommand: () => DeleteIndexCommand,
  DeletePrincipalMappingCommand: () => DeletePrincipalMappingCommand,
  DeleteQuerySuggestionsBlockListCommand: () => DeleteQuerySuggestionsBlockListCommand,
  DeleteThesaurusCommand: () => DeleteThesaurusCommand,
  DescribeAccessControlConfigurationCommand: () => DescribeAccessControlConfigurationCommand,
  DescribeDataSourceCommand: () => DescribeDataSourceCommand,
  DescribeExperienceCommand: () => DescribeExperienceCommand,
  DescribeFaqCommand: () => DescribeFaqCommand,
  DescribeFeaturedResultsSetCommand: () => DescribeFeaturedResultsSetCommand,
  DescribeIndexCommand: () => DescribeIndexCommand,
  DescribeIndexResponseFilterSensitiveLog: () => DescribeIndexResponseFilterSensitiveLog,
  DescribePrincipalMappingCommand: () => DescribePrincipalMappingCommand,
  DescribeQuerySuggestionsBlockListCommand: () => DescribeQuerySuggestionsBlockListCommand,
  DescribeQuerySuggestionsConfigCommand: () => DescribeQuerySuggestionsConfigCommand,
  DescribeThesaurusCommand: () => DescribeThesaurusCommand,
  DisassociateEntitiesFromExperienceCommand: () => DisassociateEntitiesFromExperienceCommand,
  DisassociatePersonasFromEntitiesCommand: () => DisassociatePersonasFromEntitiesCommand,
  DocumentAttributeValueType: () => DocumentAttributeValueType,
  DocumentStatus: () => DocumentStatus,
  EndpointType: () => EndpointType,
  EntityDisplayDataFilterSensitiveLog: () => EntityDisplayDataFilterSensitiveLog,
  EntityType: () => EntityType,
  ErrorCode: () => ErrorCode,
  ExperienceEntitiesSummaryFilterSensitiveLog: () => ExperienceEntitiesSummaryFilterSensitiveLog,
  ExperienceStatus: () => ExperienceStatus,
  FaqFileFormat: () => FaqFileFormat,
  FaqStatus: () => FaqStatus,
  FeaturedResultsConflictException: () => FeaturedResultsConflictException,
  FeaturedResultsSetStatus: () => FeaturedResultsSetStatus,
  FsxFileSystemType: () => FsxFileSystemType,
  GetQuerySuggestionsCommand: () => GetQuerySuggestionsCommand,
  GetSnapshotsCommand: () => GetSnapshotsCommand,
  HighlightType: () => HighlightType,
  IndexEdition: () => IndexEdition,
  IndexStatus: () => IndexStatus,
  InternalServerException: () => InternalServerException,
  Interval: () => Interval,
  InvalidRequestException: () => InvalidRequestException,
  IssueSubEntity: () => IssueSubEntity,
  Kendra: () => Kendra,
  KendraClient: () => KendraClient,
  KendraServiceException: () => KendraServiceException,
  KeyLocation: () => KeyLocation,
  ListAccessControlConfigurationsCommand: () => ListAccessControlConfigurationsCommand,
  ListDataSourceSyncJobsCommand: () => ListDataSourceSyncJobsCommand,
  ListDataSourcesCommand: () => ListDataSourcesCommand,
  ListEntityPersonasCommand: () => ListEntityPersonasCommand,
  ListExperienceEntitiesCommand: () => ListExperienceEntitiesCommand,
  ListExperienceEntitiesResponseFilterSensitiveLog: () => ListExperienceEntitiesResponseFilterSensitiveLog,
  ListExperiencesCommand: () => ListExperiencesCommand,
  ListFaqsCommand: () => ListFaqsCommand,
  ListFeaturedResultsSetsCommand: () => ListFeaturedResultsSetsCommand,
  ListGroupsOlderThanOrderingIdCommand: () => ListGroupsOlderThanOrderingIdCommand,
  ListIndicesCommand: () => ListIndicesCommand,
  ListQuerySuggestionsBlockListsCommand: () => ListQuerySuggestionsBlockListsCommand,
  ListTagsForResourceCommand: () => ListTagsForResourceCommand,
  ListThesauriCommand: () => ListThesauriCommand,
  MetricType: () => MetricType,
  MissingAttributeKeyStrategy: () => MissingAttributeKeyStrategy,
  Mode: () => Mode,
  Order: () => Order,
  Persona: () => Persona,
  PrincipalMappingStatus: () => PrincipalMappingStatus,
  PrincipalType: () => PrincipalType,
  PutPrincipalMappingCommand: () => PutPrincipalMappingCommand,
  QueryCommand: () => QueryCommand,
  QueryIdentifiersEnclosingOption: () => QueryIdentifiersEnclosingOption,
  QueryResultFormat: () => QueryResultFormat,
  QueryResultType: () => QueryResultType,
  QuerySuggestionsBlockListStatus: () => QuerySuggestionsBlockListStatus,
  QuerySuggestionsStatus: () => QuerySuggestionsStatus,
  ReadAccessType: () => ReadAccessType,
  RelevanceType: () => RelevanceType,
  ResourceAlreadyExistException: () => ResourceAlreadyExistException,
  ResourceInUseException: () => ResourceInUseException,
  ResourceNotFoundException: () => ResourceNotFoundException,
  ResourceUnavailableException: () => ResourceUnavailableException,
  RetrieveCommand: () => RetrieveCommand,
  SalesforceChatterFeedIncludeFilterType: () => SalesforceChatterFeedIncludeFilterType,
  SalesforceKnowledgeArticleState: () => SalesforceKnowledgeArticleState,
  SalesforceStandardObjectName: () => SalesforceStandardObjectName,
  ScoreConfidence: () => ScoreConfidence,
  ServerSideEncryptionConfigurationFilterSensitiveLog: () => ServerSideEncryptionConfigurationFilterSensitiveLog,
  ServiceNowAuthenticationType: () => ServiceNowAuthenticationType,
  ServiceNowBuildVersionType: () => ServiceNowBuildVersionType,
  ServiceQuotaExceededException: () => ServiceQuotaExceededException,
  SharePointOnlineAuthenticationType: () => SharePointOnlineAuthenticationType,
  SharePointVersion: () => SharePointVersion,
  SlackEntity: () => SlackEntity,
  SortOrder: () => SortOrder,
  StartDataSourceSyncJobCommand: () => StartDataSourceSyncJobCommand,
  StopDataSourceSyncJobCommand: () => StopDataSourceSyncJobCommand,
  SubmitFeedbackCommand: () => SubmitFeedbackCommand,
  SuggestionType: () => SuggestionType,
  TagResourceCommand: () => TagResourceCommand,
  ThesaurusStatus: () => ThesaurusStatus,
  ThrottlingException: () => ThrottlingException,
  Type: () => Type,
  UntagResourceCommand: () => UntagResourceCommand,
  UpdateAccessControlConfigurationCommand: () => UpdateAccessControlConfigurationCommand,
  UpdateDataSourceCommand: () => UpdateDataSourceCommand,
  UpdateExperienceCommand: () => UpdateExperienceCommand,
  UpdateFeaturedResultsSetCommand: () => UpdateFeaturedResultsSetCommand,
  UpdateIndexCommand: () => UpdateIndexCommand,
  UpdateQuerySuggestionsBlockListCommand: () => UpdateQuerySuggestionsBlockListCommand,
  UpdateQuerySuggestionsConfigCommand: () => UpdateQuerySuggestionsConfigCommand,
  UpdateThesaurusCommand: () => UpdateThesaurusCommand,
  UserContextPolicy: () => UserContextPolicy,
  UserGroupResolutionMode: () => UserGroupResolutionMode,
  ValidationException: () => ValidationException,
  WarningCode: () => WarningCode,
  WebCrawlerMode: () => WebCrawlerMode,
  __Client: () => import_smithy_client.Client,
  paginateGetSnapshots: () => paginateGetSnapshots,
  paginateListAccessControlConfigurations: () => paginateListAccessControlConfigurations,
  paginateListDataSourceSyncJobs: () => paginateListDataSourceSyncJobs,
  paginateListDataSources: () => paginateListDataSources,
  paginateListEntityPersonas: () => paginateListEntityPersonas,
  paginateListExperienceEntities: () => paginateListExperienceEntities,
  paginateListExperiences: () => paginateListExperiences,
  paginateListFaqs: () => paginateListFaqs,
  paginateListGroupsOlderThanOrderingId: () => paginateListGroupsOlderThanOrderingId,
  paginateListIndices: () => paginateListIndices,
  paginateListQuerySuggestionsBlockLists: () => paginateListQuerySuggestionsBlockLists,
  paginateListThesauri: () => paginateListThesauri
});
module.exports = __toCommonJS(index_exports);

// src/KendraClient.ts
var import_middleware_host_header = require("@aws-sdk/middleware-host-header");
var import_middleware_logger = require("@aws-sdk/middleware-logger");
var import_middleware_recursion_detection = require("@aws-sdk/middleware-recursion-detection");
var import_middleware_user_agent = require("@aws-sdk/middleware-user-agent");
var import_config_resolver = require("@smithy/config-resolver");
var import_core = require("@smithy/core");
var import_middleware_content_length = require("@smithy/middleware-content-length");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_middleware_retry = require("@smithy/middleware-retry");

var import_httpAuthSchemeProvider = require("./auth/httpAuthSchemeProvider");

// src/endpoint/EndpointParameters.ts
var resolveClientEndpointParameters = /* @__PURE__ */ __name((options) => {
  return Object.assign(options, {
    useDualstackEndpoint: options.useDualstackEndpoint ?? false,
    useFipsEndpoint: options.useFipsEndpoint ?? false,
    defaultSigningName: "kendra"
  });
}, "resolveClientEndpointParameters");
var commonParams = {
  UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
  Endpoint: { type: "builtInParams", name: "endpoint" },
  Region: { type: "builtInParams", name: "region" },
  UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
};

// src/KendraClient.ts
var import_runtimeConfig = require("././runtimeConfig");

// src/runtimeExtensions.ts
var import_region_config_resolver = require("@aws-sdk/region-config-resolver");
var import_protocol_http = require("@smithy/protocol-http");
var import_smithy_client = require("@smithy/smithy-client");

// src/auth/httpAuthExtensionConfiguration.ts
var getHttpAuthExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
  const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
  let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
  let _credentials = runtimeConfig.credentials;
  return {
    setHttpAuthScheme(httpAuthScheme) {
      const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
      if (index === -1) {
        _httpAuthSchemes.push(httpAuthScheme);
      } else {
        _httpAuthSchemes.splice(index, 1, httpAuthScheme);
      }
    },
    httpAuthSchemes() {
      return _httpAuthSchemes;
    },
    setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
      _httpAuthSchemeProvider = httpAuthSchemeProvider;
    },
    httpAuthSchemeProvider() {
      return _httpAuthSchemeProvider;
    },
    setCredentials(credentials) {
      _credentials = credentials;
    },
    credentials() {
      return _credentials;
    }
  };
}, "getHttpAuthExtensionConfiguration");
var resolveHttpAuthRuntimeConfig = /* @__PURE__ */ __name((config) => {
  return {
    httpAuthSchemes: config.httpAuthSchemes(),
    httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
    credentials: config.credentials()
  };
}, "resolveHttpAuthRuntimeConfig");

// src/runtimeExtensions.ts
var resolveRuntimeExtensions = /* @__PURE__ */ __name((runtimeConfig, extensions) => {
  const extensionConfiguration = Object.assign(
    (0, import_region_config_resolver.getAwsRegionExtensionConfiguration)(runtimeConfig),
    (0, import_smithy_client.getDefaultExtensionConfiguration)(runtimeConfig),
    (0, import_protocol_http.getHttpHandlerExtensionConfiguration)(runtimeConfig),
    getHttpAuthExtensionConfiguration(runtimeConfig)
  );
  extensions.forEach((extension) => extension.configure(extensionConfiguration));
  return Object.assign(
    runtimeConfig,
    (0, import_region_config_resolver.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
    (0, import_smithy_client.resolveDefaultRuntimeConfig)(extensionConfiguration),
    (0, import_protocol_http.resolveHttpHandlerRuntimeConfig)(extensionConfiguration),
    resolveHttpAuthRuntimeConfig(extensionConfiguration)
  );
}, "resolveRuntimeExtensions");

// src/KendraClient.ts
var KendraClient = class extends import_smithy_client.Client {
  static {
    __name(this, "KendraClient");
  }
  /**
   * The resolved configuration of KendraClient class. This is resolved and normalized from the {@link KendraClientConfig | constructor configuration interface}.
   */
  config;
  constructor(...[configuration]) {
    const _config_0 = (0, import_runtimeConfig.getRuntimeConfig)(configuration || {});
    super(_config_0);
    this.initConfig = _config_0;
    const _config_1 = resolveClientEndpointParameters(_config_0);
    const _config_2 = (0, import_middleware_user_agent.resolveUserAgentConfig)(_config_1);
    const _config_3 = (0, import_middleware_retry.resolveRetryConfig)(_config_2);
    const _config_4 = (0, import_config_resolver.resolveRegionConfig)(_config_3);
    const _config_5 = (0, import_middleware_host_header.resolveHostHeaderConfig)(_config_4);
    const _config_6 = (0, import_middleware_endpoint.resolveEndpointConfig)(_config_5);
    const _config_7 = (0, import_httpAuthSchemeProvider.resolveHttpAuthSchemeConfig)(_config_6);
    const _config_8 = resolveRuntimeExtensions(_config_7, configuration?.extensions || []);
    this.config = _config_8;
    this.middlewareStack.use((0, import_middleware_user_agent.getUserAgentPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_retry.getRetryPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_content_length.getContentLengthPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_host_header.getHostHeaderPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_logger.getLoggerPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_recursion_detection.getRecursionDetectionPlugin)(this.config));
    this.middlewareStack.use(
      (0, import_core.getHttpAuthSchemeEndpointRuleSetPlugin)(this.config, {
        httpAuthSchemeParametersProvider: import_httpAuthSchemeProvider.defaultKendraHttpAuthSchemeParametersProvider,
        identityProviderConfigProvider: /* @__PURE__ */ __name(async (config) => new import_core.DefaultIdentityProviderConfig({
          "aws.auth#sigv4": config.credentials
        }), "identityProviderConfigProvider")
      })
    );
    this.middlewareStack.use((0, import_core.getHttpSigningPlugin)(this.config));
  }
  /**
   * Destroy underlying resources, like sockets. It's usually not necessary to do this.
   * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
   * Otherwise, sockets might stay open for quite a long time before the server terminates them.
   */
  destroy() {
    super.destroy();
  }
};

// src/Kendra.ts


// src/commands/AssociateEntitiesToExperienceCommand.ts

var import_middleware_serde = require("@smithy/middleware-serde");


// src/protocols/Aws_json1_1.ts
var import_core2 = require("@aws-sdk/core");


var import_uuid = require("uuid");

// src/models/KendraServiceException.ts

var KendraServiceException = class _KendraServiceException extends import_smithy_client.ServiceException {
  static {
    __name(this, "KendraServiceException");
  }
  /**
   * @internal
   */
  constructor(options) {
    super(options);
    Object.setPrototypeOf(this, _KendraServiceException.prototype);
  }
};

// src/models/models_0.ts

var AccessDeniedException = class _AccessDeniedException extends KendraServiceException {
  static {
    __name(this, "AccessDeniedException");
  }
  name = "AccessDeniedException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AccessDeniedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AccessDeniedException.prototype);
    this.Message = opts.Message;
  }
};
var HighlightType = {
  STANDARD: "STANDARD",
  THESAURUS_SYNONYM: "THESAURUS_SYNONYM"
};
var AdditionalResultAttributeValueType = {
  TEXT_WITH_HIGHLIGHTS_VALUE: "TEXT_WITH_HIGHLIGHTS_VALUE"
};
var AlfrescoEntity = {
  blog: "blog",
  documentLibrary: "documentLibrary",
  wiki: "wiki"
};
var EntityType = {
  GROUP: "GROUP",
  USER: "USER"
};
var InternalServerException = class _InternalServerException extends KendraServiceException {
  static {
    __name(this, "InternalServerException");
  }
  name = "InternalServerException";
  $fault = "server";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InternalServerException",
      $fault: "server",
      ...opts
    });
    Object.setPrototypeOf(this, _InternalServerException.prototype);
    this.Message = opts.Message;
  }
};
var ResourceAlreadyExistException = class _ResourceAlreadyExistException extends KendraServiceException {
  static {
    __name(this, "ResourceAlreadyExistException");
  }
  name = "ResourceAlreadyExistException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceAlreadyExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceAlreadyExistException.prototype);
    this.Message = opts.Message;
  }
};
var ResourceNotFoundException = class _ResourceNotFoundException extends KendraServiceException {
  static {
    __name(this, "ResourceNotFoundException");
  }
  name = "ResourceNotFoundException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
var ThrottlingException = class _ThrottlingException extends KendraServiceException {
  static {
    __name(this, "ThrottlingException");
  }
  name = "ThrottlingException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ThrottlingException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ThrottlingException.prototype);
    this.Message = opts.Message;
  }
};
var ValidationException = class _ValidationException extends KendraServiceException {
  static {
    __name(this, "ValidationException");
  }
  name = "ValidationException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ValidationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ValidationException.prototype);
    this.Message = opts.Message;
  }
};
var Persona = {
  OWNER: "OWNER",
  VIEWER: "VIEWER"
};
var AttributeSuggestionsMode = {
  ACTIVE: "ACTIVE",
  INACTIVE: "INACTIVE"
};
var ErrorCode = {
  INTERNAL_ERROR: "InternalError",
  INVALID_REQUEST: "InvalidRequest"
};
var ConflictException = class _ConflictException extends KendraServiceException {
  static {
    __name(this, "ConflictException");
  }
  name = "ConflictException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ConflictException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ConflictException.prototype);
    this.Message = opts.Message;
  }
};
var DocumentStatus = {
  FAILED: "FAILED",
  INDEXED: "INDEXED",
  NOT_FOUND: "NOT_FOUND",
  PROCESSING: "PROCESSING",
  UPDATED: "UPDATED",
  UPDATE_FAILED: "UPDATE_FAILED"
};
var ConditionOperator = {
  BeginsWith: "BeginsWith",
  Contains: "Contains",
  Equals: "Equals",
  Exists: "Exists",
  GreaterThan: "GreaterThan",
  GreaterThanOrEquals: "GreaterThanOrEquals",
  LessThan: "LessThan",
  LessThanOrEquals: "LessThanOrEquals",
  NotContains: "NotContains",
  NotEquals: "NotEquals",
  NotExists: "NotExists"
};
var ReadAccessType = {
  ALLOW: "ALLOW",
  DENY: "DENY"
};
var PrincipalType = {
  GROUP: "GROUP",
  USER: "USER"
};
var ContentType = {
  CSV: "CSV",
  HTML: "HTML",
  JSON: "JSON",
  MD: "MD",
  MS_EXCEL: "MS_EXCEL",
  MS_WORD: "MS_WORD",
  PDF: "PDF",
  PLAIN_TEXT: "PLAIN_TEXT",
  PPT: "PPT",
  RTF: "RTF",
  XML: "XML",
  XSLT: "XSLT"
};
var ServiceQuotaExceededException = class _ServiceQuotaExceededException extends KendraServiceException {
  static {
    __name(this, "ServiceQuotaExceededException");
  }
  name = "ServiceQuotaExceededException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ServiceQuotaExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ServiceQuotaExceededException.prototype);
    this.Message = opts.Message;
  }
};
var ConfluenceAttachmentFieldName = {
  AUTHOR: "AUTHOR",
  CONTENT_TYPE: "CONTENT_TYPE",
  CREATED_DATE: "CREATED_DATE",
  DISPLAY_URL: "DISPLAY_URL",
  FILE_SIZE: "FILE_SIZE",
  ITEM_TYPE: "ITEM_TYPE",
  PARENT_ID: "PARENT_ID",
  SPACE_KEY: "SPACE_KEY",
  SPACE_NAME: "SPACE_NAME",
  URL: "URL",
  VERSION: "VERSION"
};
var ConfluenceAuthenticationType = {
  HTTP_BASIC: "HTTP_BASIC",
  PAT: "PAT"
};
var ConfluenceBlogFieldName = {
  AUTHOR: "AUTHOR",
  DISPLAY_URL: "DISPLAY_URL",
  ITEM_TYPE: "ITEM_TYPE",
  LABELS: "LABELS",
  PUBLISH_DATE: "PUBLISH_DATE",
  SPACE_KEY: "SPACE_KEY",
  SPACE_NAME: "SPACE_NAME",
  URL: "URL",
  VERSION: "VERSION"
};
var ConfluencePageFieldName = {
  AUTHOR: "AUTHOR",
  CONTENT_STATUS: "CONTENT_STATUS",
  CREATED_DATE: "CREATED_DATE",
  DISPLAY_URL: "DISPLAY_URL",
  ITEM_TYPE: "ITEM_TYPE",
  LABELS: "LABELS",
  MODIFIED_DATE: "MODIFIED_DATE",
  PARENT_ID: "PARENT_ID",
  SPACE_KEY: "SPACE_KEY",
  SPACE_NAME: "SPACE_NAME",
  URL: "URL",
  VERSION: "VERSION"
};
var ConfluenceSpaceFieldName = {
  DISPLAY_URL: "DISPLAY_URL",
  ITEM_TYPE: "ITEM_TYPE",
  SPACE_KEY: "SPACE_KEY",
  URL: "URL"
};
var ConfluenceVersion = {
  CLOUD: "CLOUD",
  SERVER: "SERVER"
};
var DatabaseEngineType = {
  RDS_AURORA_MYSQL: "RDS_AURORA_MYSQL",
  RDS_AURORA_POSTGRESQL: "RDS_AURORA_POSTGRESQL",
  RDS_MYSQL: "RDS_MYSQL",
  RDS_POSTGRESQL: "RDS_POSTGRESQL"
};
var QueryIdentifiersEnclosingOption = {
  DOUBLE_QUOTES: "DOUBLE_QUOTES",
  NONE: "NONE"
};
var FsxFileSystemType = {
  WINDOWS: "WINDOWS"
};
var Type = {
  ON_PREMISE: "ON_PREMISE",
  SAAS: "SAAS"
};
var IssueSubEntity = {
  ATTACHMENTS: "ATTACHMENTS",
  COMMENTS: "COMMENTS",
  WORKLOGS: "WORKLOGS"
};
var SalesforceChatterFeedIncludeFilterType = {
  ACTIVE_USER: "ACTIVE_USER",
  STANDARD_USER: "STANDARD_USER"
};
var SalesforceKnowledgeArticleState = {
  ARCHIVED: "ARCHIVED",
  DRAFT: "DRAFT",
  PUBLISHED: "PUBLISHED"
};
var SalesforceStandardObjectName = {
  ACCOUNT: "ACCOUNT",
  CAMPAIGN: "CAMPAIGN",
  CASE: "CASE",
  CONTACT: "CONTACT",
  CONTRACT: "CONTRACT",
  DOCUMENT: "DOCUMENT",
  GROUP: "GROUP",
  IDEA: "IDEA",
  LEAD: "LEAD",
  OPPORTUNITY: "OPPORTUNITY",
  PARTNER: "PARTNER",
  PRICEBOOK: "PRICEBOOK",
  PRODUCT: "PRODUCT",
  PROFILE: "PROFILE",
  SOLUTION: "SOLUTION",
  TASK: "TASK",
  USER: "USER"
};
var ServiceNowAuthenticationType = {
  HTTP_BASIC: "HTTP_BASIC",
  OAUTH2: "OAUTH2"
};
var ServiceNowBuildVersionType = {
  LONDON: "LONDON",
  OTHERS: "OTHERS"
};
var SharePointOnlineAuthenticationType = {
  HTTP_BASIC: "HTTP_BASIC",
  OAUTH2: "OAUTH2"
};
var SharePointVersion = {
  SHAREPOINT_2013: "SHAREPOINT_2013",
  SHAREPOINT_2016: "SHAREPOINT_2016",
  SHAREPOINT_2019: "SHAREPOINT_2019",
  SHAREPOINT_ONLINE: "SHAREPOINT_ONLINE"
};
var SlackEntity = {
  DIRECT_MESSAGE: "DIRECT_MESSAGE",
  GROUP_MESSAGE: "GROUP_MESSAGE",
  PRIVATE_CHANNEL: "PRIVATE_CHANNEL",
  PUBLIC_CHANNEL: "PUBLIC_CHANNEL"
};
var WebCrawlerMode = {
  EVERYTHING: "EVERYTHING",
  HOST_ONLY: "HOST_ONLY",
  SUBDOMAINS: "SUBDOMAINS"
};
var DataSourceType = {
  ALFRESCO: "ALFRESCO",
  BOX: "BOX",
  CONFLUENCE: "CONFLUENCE",
  CUSTOM: "CUSTOM",
  DATABASE: "DATABASE",
  FSX: "FSX",
  GITHUB: "GITHUB",
  GOOGLEDRIVE: "GOOGLEDRIVE",
  JIRA: "JIRA",
  ONEDRIVE: "ONEDRIVE",
  QUIP: "QUIP",
  S3: "S3",
  SALESFORCE: "SALESFORCE",
  SERVICENOW: "SERVICENOW",
  SHAREPOINT: "SHAREPOINT",
  SLACK: "SLACK",
  TEMPLATE: "TEMPLATE",
  WEBCRAWLER: "WEBCRAWLER",
  WORKDOCS: "WORKDOCS"
};
var FaqFileFormat = {
  CSV: "CSV",
  CSV_WITH_HEADER: "CSV_WITH_HEADER",
  JSON: "JSON"
};
var FeaturedResultsSetStatus = {
  ACTIVE: "ACTIVE",
  INACTIVE: "INACTIVE"
};
var FeaturedResultsConflictException = class _FeaturedResultsConflictException extends KendraServiceException {
  static {
    __name(this, "FeaturedResultsConflictException");
  }
  name = "FeaturedResultsConflictException";
  $fault = "client";
  /**
   * <p>An explanation for the conflicting queries.</p>
   * @public
   */
  Message;
  /**
   * <p>A list of the conflicting queries, including the query text, the name for
   *             the featured results set, and the identifier of the featured results set.</p>
   * @public
   */
  ConflictingItems;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FeaturedResultsConflictException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FeaturedResultsConflictException.prototype);
    this.Message = opts.Message;
    this.ConflictingItems = opts.ConflictingItems;
  }
};
var IndexEdition = {
  DEVELOPER_EDITION: "DEVELOPER_EDITION",
  ENTERPRISE_EDITION: "ENTERPRISE_EDITION",
  GEN_AI_ENTERPRISE_EDITION: "GEN_AI_ENTERPRISE_EDITION"
};
var UserContextPolicy = {
  ATTRIBUTE_FILTER: "ATTRIBUTE_FILTER",
  USER_TOKEN: "USER_TOKEN"
};
var UserGroupResolutionMode = {
  AWS_SSO: "AWS_SSO",
  NONE: "NONE"
};
var KeyLocation = {
  SECRET_MANAGER: "SECRET_MANAGER",
  URL: "URL"
};
var DataSourceStatus = {
  ACTIVE: "ACTIVE",
  CREATING: "CREATING",
  DELETING: "DELETING",
  FAILED: "FAILED",
  UPDATING: "UPDATING"
};
var EndpointType = {
  HOME: "HOME"
};
var ExperienceStatus = {
  ACTIVE: "ACTIVE",
  CREATING: "CREATING",
  DELETING: "DELETING",
  FAILED: "FAILED"
};
var FaqStatus = {
  ACTIVE: "ACTIVE",
  CREATING: "CREATING",
  DELETING: "DELETING",
  FAILED: "FAILED",
  UPDATING: "UPDATING"
};
var Order = {
  ASCENDING: "ASCENDING",
  DESCENDING: "DESCENDING"
};
var DocumentAttributeValueType = {
  DATE_VALUE: "DATE_VALUE",
  LONG_VALUE: "LONG_VALUE",
  STRING_LIST_VALUE: "STRING_LIST_VALUE",
  STRING_VALUE: "STRING_VALUE"
};
var IndexStatus = {
  ACTIVE: "ACTIVE",
  CREATING: "CREATING",
  DELETING: "DELETING",
  FAILED: "FAILED",
  SYSTEM_UPDATING: "SYSTEM_UPDATING",
  UPDATING: "UPDATING"
};
var PrincipalMappingStatus = {
  DELETED: "DELETED",
  DELETING: "DELETING",
  FAILED: "FAILED",
  PROCESSING: "PROCESSING",
  SUCCEEDED: "SUCCEEDED"
};
var QuerySuggestionsBlockListStatus = {
  ACTIVE: "ACTIVE",
  ACTIVE_BUT_UPDATE_FAILED: "ACTIVE_BUT_UPDATE_FAILED",
  CREATING: "CREATING",
  DELETING: "DELETING",
  FAILED: "FAILED",
  UPDATING: "UPDATING"
};
var Mode = {
  ENABLED: "ENABLED",
  LEARN_ONLY: "LEARN_ONLY"
};
var QuerySuggestionsStatus = {
  ACTIVE: "ACTIVE",
  UPDATING: "UPDATING"
};
var ThesaurusStatus = {
  ACTIVE: "ACTIVE",
  ACTIVE_BUT_UPDATE_FAILED: "ACTIVE_BUT_UPDATE_FAILED",
  CREATING: "CREATING",
  DELETING: "DELETING",
  FAILED: "FAILED",
  UPDATING: "UPDATING"
};
var SuggestionType = {
  DOCUMENT_ATTRIBUTES: "DOCUMENT_ATTRIBUTES",
  QUERY: "QUERY"
};
var Interval = {
  ONE_MONTH_AGO: "ONE_MONTH_AGO",
  ONE_WEEK_AGO: "ONE_WEEK_AGO",
  THIS_MONTH: "THIS_MONTH",
  THIS_WEEK: "THIS_WEEK",
  TWO_MONTHS_AGO: "TWO_MONTHS_AGO",
  TWO_WEEKS_AGO: "TWO_WEEKS_AGO"
};
var MetricType = {
  AGG_QUERY_DOC_METRICS: "AGG_QUERY_DOC_METRICS",
  DOCS_BY_CLICK_COUNT: "DOCS_BY_CLICK_COUNT",
  QUERIES_BY_COUNT: "QUERIES_BY_COUNT",
  QUERIES_BY_ZERO_CLICK_RATE: "QUERIES_BY_ZERO_CLICK_RATE",
  QUERIES_BY_ZERO_RESULT_RATE: "QUERIES_BY_ZERO_RESULT_RATE",
  TREND_QUERY_DOC_METRICS: "TREND_QUERY_DOC_METRICS"
};
var InvalidRequestException = class _InvalidRequestException extends KendraServiceException {
  static {
    __name(this, "InvalidRequestException");
  }
  name = "InvalidRequestException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRequestException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRequestException.prototype);
    this.Message = opts.Message;
  }
};
var DataSourceSyncJobStatus = {
  ABORTED: "ABORTED",
  FAILED: "FAILED",
  INCOMPLETE: "INCOMPLETE",
  STOPPING: "STOPPING",
  SUCCEEDED: "SUCCEEDED",
  SYNCING: "SYNCING",
  SYNCING_INDEXING: "SYNCING_INDEXING"
};
var ResourceUnavailableException = class _ResourceUnavailableException extends KendraServiceException {
  static {
    __name(this, "ResourceUnavailableException");
  }
  name = "ResourceUnavailableException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceUnavailableException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceUnavailableException.prototype);
    this.Message = opts.Message;
  }
};
var MissingAttributeKeyStrategy = {
  COLLAPSE: "COLLAPSE",
  EXPAND: "EXPAND",
  IGNORE: "IGNORE"
};
var SortOrder = {
  ASC: "ASC",
  DESC: "DESC"
};
var QueryResultType = {
  ANSWER: "ANSWER",
  DOCUMENT: "DOCUMENT",
  QUESTION_ANSWER: "QUESTION_ANSWER"
};
var QueryResultFormat = {
  TABLE: "TABLE",
  TEXT: "TEXT"
};
var ServerSideEncryptionConfigurationFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.KmsKeyId && { KmsKeyId: import_smithy_client.SENSITIVE_STRING }
}), "ServerSideEncryptionConfigurationFilterSensitiveLog");
var CreateIndexRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.ServerSideEncryptionConfiguration && {
    ServerSideEncryptionConfiguration: ServerSideEncryptionConfigurationFilterSensitiveLog(
      obj.ServerSideEncryptionConfiguration
    )
  }
}), "CreateIndexRequestFilterSensitiveLog");
var DescribeIndexResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.ServerSideEncryptionConfiguration && {
    ServerSideEncryptionConfiguration: ServerSideEncryptionConfigurationFilterSensitiveLog(
      obj.ServerSideEncryptionConfiguration
    )
  }
}), "DescribeIndexResponseFilterSensitiveLog");
var EntityDisplayDataFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.UserName && { UserName: import_smithy_client.SENSITIVE_STRING },
  ...obj.GroupName && { GroupName: import_smithy_client.SENSITIVE_STRING },
  ...obj.IdentifiedUserName && { IdentifiedUserName: import_smithy_client.SENSITIVE_STRING },
  ...obj.FirstName && { FirstName: import_smithy_client.SENSITIVE_STRING },
  ...obj.LastName && { LastName: import_smithy_client.SENSITIVE_STRING }
}), "EntityDisplayDataFilterSensitiveLog");
var ExperienceEntitiesSummaryFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.DisplayData && { DisplayData: EntityDisplayDataFilterSensitiveLog(obj.DisplayData) }
}), "ExperienceEntitiesSummaryFilterSensitiveLog");
var ListExperienceEntitiesResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.SummaryItems && {
    SummaryItems: obj.SummaryItems.map((item) => ExperienceEntitiesSummaryFilterSensitiveLog(item))
  }
}), "ListExperienceEntitiesResponseFilterSensitiveLog");

// src/models/models_1.ts
var ScoreConfidence = {
  HIGH: "HIGH",
  LOW: "LOW",
  MEDIUM: "MEDIUM",
  NOT_AVAILABLE: "NOT_AVAILABLE",
  VERY_HIGH: "VERY_HIGH"
};
var WarningCode = {
  QUERY_LANGUAGE_INVALID_SYNTAX: "QUERY_LANGUAGE_INVALID_SYNTAX"
};
var ResourceInUseException = class _ResourceInUseException extends KendraServiceException {
  static {
    __name(this, "ResourceInUseException");
  }
  name = "ResourceInUseException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceInUseException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceInUseException.prototype);
    this.Message = opts.Message;
  }
};
var RelevanceType = {
  NOT_RELEVANT: "NOT_RELEVANT",
  RELEVANT: "RELEVANT"
};

// src/protocols/Aws_json1_1.ts
var se_AssociateEntitiesToExperienceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("AssociateEntitiesToExperience");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_AssociateEntitiesToExperienceCommand");
var se_AssociatePersonasToEntitiesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("AssociatePersonasToEntities");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_AssociatePersonasToEntitiesCommand");
var se_BatchDeleteDocumentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("BatchDeleteDocument");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_BatchDeleteDocumentCommand");
var se_BatchDeleteFeaturedResultsSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("BatchDeleteFeaturedResultsSet");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_BatchDeleteFeaturedResultsSetCommand");
var se_BatchGetDocumentStatusCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("BatchGetDocumentStatus");
  let body;
  body = JSON.stringify(se_BatchGetDocumentStatusRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_BatchGetDocumentStatusCommand");
var se_BatchPutDocumentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("BatchPutDocument");
  let body;
  body = JSON.stringify(se_BatchPutDocumentRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_BatchPutDocumentCommand");
var se_ClearQuerySuggestionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ClearQuerySuggestions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ClearQuerySuggestionsCommand");
var se_CreateAccessControlConfigurationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateAccessControlConfiguration");
  let body;
  body = JSON.stringify(se_CreateAccessControlConfigurationRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateAccessControlConfigurationCommand");
var se_CreateDataSourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateDataSource");
  let body;
  body = JSON.stringify(se_CreateDataSourceRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDataSourceCommand");
var se_CreateExperienceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateExperience");
  let body;
  body = JSON.stringify(se_CreateExperienceRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateExperienceCommand");
var se_CreateFaqCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateFaq");
  let body;
  body = JSON.stringify(se_CreateFaqRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateFaqCommand");
var se_CreateFeaturedResultsSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateFeaturedResultsSet");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateFeaturedResultsSetCommand");
var se_CreateIndexCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateIndex");
  let body;
  body = JSON.stringify(se_CreateIndexRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateIndexCommand");
var se_CreateQuerySuggestionsBlockListCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateQuerySuggestionsBlockList");
  let body;
  body = JSON.stringify(se_CreateQuerySuggestionsBlockListRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateQuerySuggestionsBlockListCommand");
var se_CreateThesaurusCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateThesaurus");
  let body;
  body = JSON.stringify(se_CreateThesaurusRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateThesaurusCommand");
var se_DeleteAccessControlConfigurationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteAccessControlConfiguration");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteAccessControlConfigurationCommand");
var se_DeleteDataSourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteDataSource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDataSourceCommand");
var se_DeleteExperienceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteExperience");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteExperienceCommand");
var se_DeleteFaqCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteFaq");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteFaqCommand");
var se_DeleteIndexCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteIndex");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteIndexCommand");
var se_DeletePrincipalMappingCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeletePrincipalMapping");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeletePrincipalMappingCommand");
var se_DeleteQuerySuggestionsBlockListCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteQuerySuggestionsBlockList");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteQuerySuggestionsBlockListCommand");
var se_DeleteThesaurusCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteThesaurus");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteThesaurusCommand");
var se_DescribeAccessControlConfigurationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeAccessControlConfiguration");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeAccessControlConfigurationCommand");
var se_DescribeDataSourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeDataSource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDataSourceCommand");
var se_DescribeExperienceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeExperience");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeExperienceCommand");
var se_DescribeFaqCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeFaq");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeFaqCommand");
var se_DescribeFeaturedResultsSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeFeaturedResultsSet");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeFeaturedResultsSetCommand");
var se_DescribeIndexCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeIndex");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeIndexCommand");
var se_DescribePrincipalMappingCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribePrincipalMapping");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribePrincipalMappingCommand");
var se_DescribeQuerySuggestionsBlockListCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeQuerySuggestionsBlockList");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeQuerySuggestionsBlockListCommand");
var se_DescribeQuerySuggestionsConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeQuerySuggestionsConfig");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeQuerySuggestionsConfigCommand");
var se_DescribeThesaurusCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeThesaurus");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeThesaurusCommand");
var se_DisassociateEntitiesFromExperienceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DisassociateEntitiesFromExperience");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DisassociateEntitiesFromExperienceCommand");
var se_DisassociatePersonasFromEntitiesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DisassociatePersonasFromEntities");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DisassociatePersonasFromEntitiesCommand");
var se_GetQuerySuggestionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetQuerySuggestions");
  let body;
  body = JSON.stringify(se_GetQuerySuggestionsRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetQuerySuggestionsCommand");
var se_GetSnapshotsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetSnapshots");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetSnapshotsCommand");
var se_ListAccessControlConfigurationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListAccessControlConfigurations");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListAccessControlConfigurationsCommand");
var se_ListDataSourcesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListDataSources");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListDataSourcesCommand");
var se_ListDataSourceSyncJobsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListDataSourceSyncJobs");
  let body;
  body = JSON.stringify(se_ListDataSourceSyncJobsRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListDataSourceSyncJobsCommand");
var se_ListEntityPersonasCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListEntityPersonas");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListEntityPersonasCommand");
var se_ListExperienceEntitiesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListExperienceEntities");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListExperienceEntitiesCommand");
var se_ListExperiencesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListExperiences");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListExperiencesCommand");
var se_ListFaqsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListFaqs");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListFaqsCommand");
var se_ListFeaturedResultsSetsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListFeaturedResultsSets");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListFeaturedResultsSetsCommand");
var se_ListGroupsOlderThanOrderingIdCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListGroupsOlderThanOrderingId");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListGroupsOlderThanOrderingIdCommand");
var se_ListIndicesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListIndices");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListIndicesCommand");
var se_ListQuerySuggestionsBlockListsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListQuerySuggestionsBlockLists");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListQuerySuggestionsBlockListsCommand");
var se_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListTagsForResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTagsForResourceCommand");
var se_ListThesauriCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListThesauri");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListThesauriCommand");
var se_PutPrincipalMappingCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutPrincipalMapping");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutPrincipalMappingCommand");
var se_QueryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("Query");
  let body;
  body = JSON.stringify(se_QueryRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_QueryCommand");
var se_RetrieveCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("Retrieve");
  let body;
  body = JSON.stringify(se_RetrieveRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RetrieveCommand");
var se_StartDataSourceSyncJobCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StartDataSourceSyncJob");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartDataSourceSyncJobCommand");
var se_StopDataSourceSyncJobCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StopDataSourceSyncJob");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StopDataSourceSyncJobCommand");
var se_SubmitFeedbackCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("SubmitFeedback");
  let body;
  body = JSON.stringify(se_SubmitFeedbackRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SubmitFeedbackCommand");
var se_TagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("TagResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_TagResourceCommand");
var se_UntagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UntagResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UntagResourceCommand");
var se_UpdateAccessControlConfigurationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateAccessControlConfiguration");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateAccessControlConfigurationCommand");
var se_UpdateDataSourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateDataSource");
  let body;
  body = JSON.stringify(se_UpdateDataSourceRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateDataSourceCommand");
var se_UpdateExperienceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateExperience");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateExperienceCommand");
var se_UpdateFeaturedResultsSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateFeaturedResultsSet");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateFeaturedResultsSetCommand");
var se_UpdateIndexCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateIndex");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateIndexCommand");
var se_UpdateQuerySuggestionsBlockListCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateQuerySuggestionsBlockList");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateQuerySuggestionsBlockListCommand");
var se_UpdateQuerySuggestionsConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateQuerySuggestionsConfig");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateQuerySuggestionsConfigCommand");
var se_UpdateThesaurusCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateThesaurus");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateThesaurusCommand");
var de_AssociateEntitiesToExperienceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_AssociateEntitiesToExperienceCommand");
var de_AssociatePersonasToEntitiesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_AssociatePersonasToEntitiesCommand");
var de_BatchDeleteDocumentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_BatchDeleteDocumentCommand");
var de_BatchDeleteFeaturedResultsSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_BatchDeleteFeaturedResultsSetCommand");
var de_BatchGetDocumentStatusCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_BatchGetDocumentStatusCommand");
var de_BatchPutDocumentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_BatchPutDocumentCommand");
var de_ClearQuerySuggestionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_ClearQuerySuggestionsCommand");
var de_CreateAccessControlConfigurationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateAccessControlConfigurationCommand");
var de_CreateDataSourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDataSourceCommand");
var de_CreateExperienceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateExperienceCommand");
var de_CreateFaqCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateFaqCommand");
var de_CreateFeaturedResultsSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateFeaturedResultsSetCommand");
var de_CreateIndexCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateIndexCommand");
var de_CreateQuerySuggestionsBlockListCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateQuerySuggestionsBlockListCommand");
var de_CreateThesaurusCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateThesaurusCommand");
var de_DeleteAccessControlConfigurationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteAccessControlConfigurationCommand");
var de_DeleteDataSourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteDataSourceCommand");
var de_DeleteExperienceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteExperienceCommand");
var de_DeleteFaqCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteFaqCommand");
var de_DeleteIndexCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteIndexCommand");
var de_DeletePrincipalMappingCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeletePrincipalMappingCommand");
var de_DeleteQuerySuggestionsBlockListCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteQuerySuggestionsBlockListCommand");
var de_DeleteThesaurusCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteThesaurusCommand");
var de_DescribeAccessControlConfigurationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeAccessControlConfigurationCommand");
var de_DescribeDataSourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeDataSourceResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDataSourceCommand");
var de_DescribeExperienceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeExperienceResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeExperienceCommand");
var de_DescribeFaqCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeFaqResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeFaqCommand");
var de_DescribeFeaturedResultsSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeFeaturedResultsSetCommand");
var de_DescribeIndexCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeIndexResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeIndexCommand");
var de_DescribePrincipalMappingCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribePrincipalMappingResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribePrincipalMappingCommand");
var de_DescribeQuerySuggestionsBlockListCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeQuerySuggestionsBlockListResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeQuerySuggestionsBlockListCommand");
var de_DescribeQuerySuggestionsConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeQuerySuggestionsConfigResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeQuerySuggestionsConfigCommand");
var de_DescribeThesaurusCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeThesaurusResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeThesaurusCommand");
var de_DisassociateEntitiesFromExperienceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DisassociateEntitiesFromExperienceCommand");
var de_DisassociatePersonasFromEntitiesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DisassociatePersonasFromEntitiesCommand");
var de_GetQuerySuggestionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetQuerySuggestionsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetQuerySuggestionsCommand");
var de_GetSnapshotsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetSnapshotsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetSnapshotsCommand");
var de_ListAccessControlConfigurationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListAccessControlConfigurationsCommand");
var de_ListDataSourcesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListDataSourcesResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListDataSourcesCommand");
var de_ListDataSourceSyncJobsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListDataSourceSyncJobsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListDataSourceSyncJobsCommand");
var de_ListEntityPersonasCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListEntityPersonasResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListEntityPersonasCommand");
var de_ListExperienceEntitiesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListExperienceEntitiesCommand");
var de_ListExperiencesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListExperiencesResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListExperiencesCommand");
var de_ListFaqsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListFaqsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListFaqsCommand");
var de_ListFeaturedResultsSetsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListFeaturedResultsSetsCommand");
var de_ListGroupsOlderThanOrderingIdCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListGroupsOlderThanOrderingIdCommand");
var de_ListIndicesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListIndicesResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListIndicesCommand");
var de_ListQuerySuggestionsBlockListsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListQuerySuggestionsBlockListsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListQuerySuggestionsBlockListsCommand");
var de_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTagsForResourceCommand");
var de_ListThesauriCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListThesauriResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListThesauriCommand");
var de_PutPrincipalMappingCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_PutPrincipalMappingCommand");
var de_QueryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_QueryResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_QueryCommand");
var de_RetrieveCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_RetrieveResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RetrieveCommand");
var de_StartDataSourceSyncJobCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartDataSourceSyncJobCommand");
var de_StopDataSourceSyncJobCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_StopDataSourceSyncJobCommand");
var de_SubmitFeedbackCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_SubmitFeedbackCommand");
var de_TagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_TagResourceCommand");
var de_UntagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UntagResourceCommand");
var de_UpdateAccessControlConfigurationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateAccessControlConfigurationCommand");
var de_UpdateDataSourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UpdateDataSourceCommand");
var de_UpdateExperienceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UpdateExperienceCommand");
var de_UpdateFeaturedResultsSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateFeaturedResultsSetCommand");
var de_UpdateIndexCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UpdateIndexCommand");
var de_UpdateQuerySuggestionsBlockListCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UpdateQuerySuggestionsBlockListCommand");
var de_UpdateQuerySuggestionsConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UpdateQuerySuggestionsConfigCommand");
var de_UpdateThesaurusCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UpdateThesaurusCommand");
var de_CommandError = /* @__PURE__ */ __name(async (output, context) => {
  const parsedOutput = {
    ...output,
    body: await (0, import_core2.parseJsonErrorBody)(output.body, context)
  };
  const errorCode = (0, import_core2.loadRestJsonErrorCode)(output, parsedOutput.body);
  switch (errorCode) {
    case "AccessDeniedException":
    case "com.amazonaws.kendra#AccessDeniedException":
      throw await de_AccessDeniedExceptionRes(parsedOutput, context);
    case "InternalServerException":
    case "com.amazonaws.kendra#InternalServerException":
      throw await de_InternalServerExceptionRes(parsedOutput, context);
    case "ResourceAlreadyExistException":
    case "com.amazonaws.kendra#ResourceAlreadyExistException":
      throw await de_ResourceAlreadyExistExceptionRes(parsedOutput, context);
    case "ResourceNotFoundException":
    case "com.amazonaws.kendra#ResourceNotFoundException":
      throw await de_ResourceNotFoundExceptionRes(parsedOutput, context);
    case "ThrottlingException":
    case "com.amazonaws.kendra#ThrottlingException":
      throw await de_ThrottlingExceptionRes(parsedOutput, context);
    case "ValidationException":
    case "com.amazonaws.kendra#ValidationException":
      throw await de_ValidationExceptionRes(parsedOutput, context);
    case "ConflictException":
    case "com.amazonaws.kendra#ConflictException":
      throw await de_ConflictExceptionRes(parsedOutput, context);
    case "ServiceQuotaExceededException":
    case "com.amazonaws.kendra#ServiceQuotaExceededException":
      throw await de_ServiceQuotaExceededExceptionRes(parsedOutput, context);
    case "FeaturedResultsConflictException":
    case "com.amazonaws.kendra#FeaturedResultsConflictException":
      throw await de_FeaturedResultsConflictExceptionRes(parsedOutput, context);
    case "InvalidRequestException":
    case "com.amazonaws.kendra#InvalidRequestException":
      throw await de_InvalidRequestExceptionRes(parsedOutput, context);
    case "ResourceUnavailableException":
    case "com.amazonaws.kendra#ResourceUnavailableException":
      throw await de_ResourceUnavailableExceptionRes(parsedOutput, context);
    case "ResourceInUseException":
    case "com.amazonaws.kendra#ResourceInUseException":
      throw await de_ResourceInUseExceptionRes(parsedOutput, context);
    default:
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody,
        errorCode
      });
  }
}, "de_CommandError");
var de_AccessDeniedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AccessDeniedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AccessDeniedExceptionRes");
var de_ConflictExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ConflictException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ConflictExceptionRes");
var de_FeaturedResultsConflictExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new FeaturedResultsConflictException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FeaturedResultsConflictExceptionRes");
var de_InternalServerExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InternalServerException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InternalServerExceptionRes");
var de_InvalidRequestExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRequestException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRequestExceptionRes");
var de_ResourceAlreadyExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceAlreadyExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceAlreadyExistExceptionRes");
var de_ResourceInUseExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceInUseException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceInUseExceptionRes");
var de_ResourceNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceNotFoundExceptionRes");
var de_ResourceUnavailableExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceUnavailableException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceUnavailableExceptionRes");
var de_ServiceQuotaExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ServiceQuotaExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ServiceQuotaExceededExceptionRes");
var de_ThrottlingExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ThrottlingException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ThrottlingExceptionRes");
var de_ValidationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ValidationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ValidationExceptionRes");
var se_AttributeFilter = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AndAllFilters: /* @__PURE__ */ __name((_) => se_AttributeFilterList(_, context), "AndAllFilters"),
    ContainsAll: /* @__PURE__ */ __name((_) => se_DocumentAttribute(_, context), "ContainsAll"),
    ContainsAny: /* @__PURE__ */ __name((_) => se_DocumentAttribute(_, context), "ContainsAny"),
    EqualsTo: /* @__PURE__ */ __name((_) => se_DocumentAttribute(_, context), "EqualsTo"),
    GreaterThan: /* @__PURE__ */ __name((_) => se_DocumentAttribute(_, context), "GreaterThan"),
    GreaterThanOrEquals: /* @__PURE__ */ __name((_) => se_DocumentAttribute(_, context), "GreaterThanOrEquals"),
    LessThan: /* @__PURE__ */ __name((_) => se_DocumentAttribute(_, context), "LessThan"),
    LessThanOrEquals: /* @__PURE__ */ __name((_) => se_DocumentAttribute(_, context), "LessThanOrEquals"),
    NotFilter: /* @__PURE__ */ __name((_) => se_AttributeFilter(_, context), "NotFilter"),
    OrAllFilters: /* @__PURE__ */ __name((_) => se_AttributeFilterList(_, context), "OrAllFilters")
  });
}, "se_AttributeFilter");
var se_AttributeFilterList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_AttributeFilter(entry, context);
  });
}, "se_AttributeFilterList");
var se_AttributeSuggestionsGetConfig = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AdditionalResponseAttributes: import_smithy_client._json,
    AttributeFilter: /* @__PURE__ */ __name((_) => se_AttributeFilter(_, context), "AttributeFilter"),
    SuggestionAttributes: import_smithy_client._json,
    UserContext: import_smithy_client._json
  });
}, "se_AttributeSuggestionsGetConfig");
var se_BatchGetDocumentStatusRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    DocumentInfoList: /* @__PURE__ */ __name((_) => se_DocumentInfoList(_, context), "DocumentInfoList"),
    IndexId: []
  });
}, "se_BatchGetDocumentStatusRequest");
var se_BatchPutDocumentRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    CustomDocumentEnrichmentConfiguration: /* @__PURE__ */ __name((_) => se_CustomDocumentEnrichmentConfiguration(_, context), "CustomDocumentEnrichmentConfiguration"),
    Documents: /* @__PURE__ */ __name((_) => se_DocumentList(_, context), "Documents"),
    IndexId: [],
    RoleArn: []
  });
}, "se_BatchPutDocumentRequest");
var se_ClickFeedback = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClickTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "ClickTime"),
    ResultId: []
  });
}, "se_ClickFeedback");
var se_ClickFeedbackList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_ClickFeedback(entry, context);
  });
}, "se_ClickFeedbackList");
var se_CreateAccessControlConfigurationRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AccessControlList: import_smithy_client._json,
    ClientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    Description: [],
    HierarchicalAccessControlList: import_smithy_client._json,
    IndexId: [],
    Name: []
  });
}, "se_CreateAccessControlConfigurationRequest");
var se_CreateDataSourceRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    Configuration: /* @__PURE__ */ __name((_) => se_DataSourceConfiguration(_, context), "Configuration"),
    CustomDocumentEnrichmentConfiguration: /* @__PURE__ */ __name((_) => se_CustomDocumentEnrichmentConfiguration(_, context), "CustomDocumentEnrichmentConfiguration"),
    Description: [],
    IndexId: [],
    LanguageCode: [],
    Name: [],
    RoleArn: [],
    Schedule: [],
    Tags: import_smithy_client._json,
    Type: [],
    VpcConfiguration: import_smithy_client._json
  });
}, "se_CreateDataSourceRequest");
var se_CreateExperienceRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    Configuration: import_smithy_client._json,
    Description: [],
    IndexId: [],
    Name: [],
    RoleArn: []
  });
}, "se_CreateExperienceRequest");
var se_CreateFaqRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    Description: [],
    FileFormat: [],
    IndexId: [],
    LanguageCode: [],
    Name: [],
    RoleArn: [],
    S3Path: import_smithy_client._json,
    Tags: import_smithy_client._json
  });
}, "se_CreateFaqRequest");
var se_CreateIndexRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    Description: [],
    Edition: [],
    Name: [],
    RoleArn: [],
    ServerSideEncryptionConfiguration: import_smithy_client._json,
    Tags: import_smithy_client._json,
    UserContextPolicy: [],
    UserGroupResolutionConfiguration: import_smithy_client._json,
    UserTokenConfigurations: import_smithy_client._json
  });
}, "se_CreateIndexRequest");
var se_CreateQuerySuggestionsBlockListRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    Description: [],
    IndexId: [],
    Name: [],
    RoleArn: [],
    SourceS3Path: import_smithy_client._json,
    Tags: import_smithy_client._json
  });
}, "se_CreateQuerySuggestionsBlockListRequest");
var se_CreateThesaurusRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    Description: [],
    IndexId: [],
    Name: [],
    RoleArn: [],
    SourceS3Path: import_smithy_client._json,
    Tags: import_smithy_client._json
  });
}, "se_CreateThesaurusRequest");
var se_CustomDocumentEnrichmentConfiguration = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    InlineConfigurations: /* @__PURE__ */ __name((_) => se_InlineCustomDocumentEnrichmentConfigurationList(_, context), "InlineConfigurations"),
    PostExtractionHookConfiguration: /* @__PURE__ */ __name((_) => se_HookConfiguration(_, context), "PostExtractionHookConfiguration"),
    PreExtractionHookConfiguration: /* @__PURE__ */ __name((_) => se_HookConfiguration(_, context), "PreExtractionHookConfiguration"),
    RoleArn: []
  });
}, "se_CustomDocumentEnrichmentConfiguration");
var se_DataSourceConfiguration = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AlfrescoConfiguration: import_smithy_client._json,
    BoxConfiguration: import_smithy_client._json,
    ConfluenceConfiguration: import_smithy_client._json,
    DatabaseConfiguration: import_smithy_client._json,
    FsxConfiguration: import_smithy_client._json,
    GitHubConfiguration: import_smithy_client._json,
    GoogleDriveConfiguration: import_smithy_client._json,
    JiraConfiguration: import_smithy_client._json,
    OneDriveConfiguration: import_smithy_client._json,
    QuipConfiguration: import_smithy_client._json,
    S3Configuration: import_smithy_client._json,
    SalesforceConfiguration: import_smithy_client._json,
    ServiceNowConfiguration: import_smithy_client._json,
    SharePointConfiguration: import_smithy_client._json,
    SlackConfiguration: import_smithy_client._json,
    TemplateConfiguration: /* @__PURE__ */ __name((_) => se_TemplateConfiguration(_, context), "TemplateConfiguration"),
    WebCrawlerConfiguration: /* @__PURE__ */ __name((_) => se_WebCrawlerConfiguration(_, context), "WebCrawlerConfiguration"),
    WorkDocsConfiguration: import_smithy_client._json
  });
}, "se_DataSourceConfiguration");
var se_Document = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AccessControlConfigurationId: [],
    AccessControlList: import_smithy_client._json,
    Attributes: /* @__PURE__ */ __name((_) => se_DocumentAttributeList(_, context), "Attributes"),
    Blob: context.base64Encoder,
    ContentType: [],
    HierarchicalAccessControlList: import_smithy_client._json,
    Id: [],
    S3Path: import_smithy_client._json,
    Title: []
  });
}, "se_Document");
var se_DocumentAttribute = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    Key: [],
    Value: /* @__PURE__ */ __name((_) => se_DocumentAttributeValue(_, context), "Value")
  });
}, "se_DocumentAttribute");
var se_DocumentAttributeCondition = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ConditionDocumentAttributeKey: [],
    ConditionOnValue: /* @__PURE__ */ __name((_) => se_DocumentAttributeValue(_, context), "ConditionOnValue"),
    Operator: []
  });
}, "se_DocumentAttributeCondition");
var se_DocumentAttributeList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_DocumentAttribute(entry, context);
  });
}, "se_DocumentAttributeList");
var se_DocumentAttributeTarget = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    TargetDocumentAttributeKey: [],
    TargetDocumentAttributeValue: /* @__PURE__ */ __name((_) => se_DocumentAttributeValue(_, context), "TargetDocumentAttributeValue"),
    TargetDocumentAttributeValueDeletion: []
  });
}, "se_DocumentAttributeTarget");
var se_DocumentAttributeValue = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    DateValue: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "DateValue"),
    LongValue: [],
    StringListValue: import_smithy_client._json,
    StringValue: []
  });
}, "se_DocumentAttributeValue");
var se_DocumentInfo = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    Attributes: /* @__PURE__ */ __name((_) => se_DocumentAttributeList(_, context), "Attributes"),
    DocumentId: []
  });
}, "se_DocumentInfo");
var se_DocumentInfoList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_DocumentInfo(entry, context);
  });
}, "se_DocumentInfoList");
var se_DocumentList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_Document(entry, context);
  });
}, "se_DocumentList");
var se_Facet = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    DocumentAttributeKey: [],
    Facets: /* @__PURE__ */ __name((_) => se_FacetList(_, context), "Facets"),
    MaxResults: []
  });
}, "se_Facet");
var se_FacetList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_Facet(entry, context);
  });
}, "se_FacetList");
var se_GetQuerySuggestionsRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AttributeSuggestionsConfig: /* @__PURE__ */ __name((_) => se_AttributeSuggestionsGetConfig(_, context), "AttributeSuggestionsConfig"),
    IndexId: [],
    MaxSuggestionsCount: [],
    QueryText: [],
    SuggestionTypes: import_smithy_client._json
  });
}, "se_GetQuerySuggestionsRequest");
var se_HookConfiguration = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    InvocationCondition: /* @__PURE__ */ __name((_) => se_DocumentAttributeCondition(_, context), "InvocationCondition"),
    LambdaArn: [],
    S3Bucket: []
  });
}, "se_HookConfiguration");
var se_InlineCustomDocumentEnrichmentConfiguration = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    Condition: /* @__PURE__ */ __name((_) => se_DocumentAttributeCondition(_, context), "Condition"),
    DocumentContentDeletion: [],
    Target: /* @__PURE__ */ __name((_) => se_DocumentAttributeTarget(_, context), "Target")
  });
}, "se_InlineCustomDocumentEnrichmentConfiguration");
var se_InlineCustomDocumentEnrichmentConfigurationList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_InlineCustomDocumentEnrichmentConfiguration(entry, context);
  });
}, "se_InlineCustomDocumentEnrichmentConfigurationList");
var se_ListDataSourceSyncJobsRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    Id: [],
    IndexId: [],
    MaxResults: [],
    NextToken: [],
    StartTimeFilter: /* @__PURE__ */ __name((_) => se_TimeRange(_, context), "StartTimeFilter"),
    StatusFilter: []
  });
}, "se_ListDataSourceSyncJobsRequest");
var se_QueryRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AttributeFilter: /* @__PURE__ */ __name((_) => se_AttributeFilter(_, context), "AttributeFilter"),
    CollapseConfiguration: import_smithy_client._json,
    DocumentRelevanceOverrideConfigurations: import_smithy_client._json,
    Facets: /* @__PURE__ */ __name((_) => se_FacetList(_, context), "Facets"),
    IndexId: [],
    PageNumber: [],
    PageSize: [],
    QueryResultTypeFilter: [],
    QueryText: [],
    RequestedDocumentAttributes: import_smithy_client._json,
    SortingConfiguration: import_smithy_client._json,
    SortingConfigurations: import_smithy_client._json,
    SpellCorrectionConfiguration: import_smithy_client._json,
    UserContext: import_smithy_client._json,
    VisitorId: []
  });
}, "se_QueryRequest");
var se_RetrieveRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AttributeFilter: /* @__PURE__ */ __name((_) => se_AttributeFilter(_, context), "AttributeFilter"),
    DocumentRelevanceOverrideConfigurations: import_smithy_client._json,
    IndexId: [],
    PageNumber: [],
    PageSize: [],
    QueryText: [],
    RequestedDocumentAttributes: import_smithy_client._json,
    UserContext: import_smithy_client._json
  });
}, "se_RetrieveRequest");
var se_SubmitFeedbackRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClickFeedbackItems: /* @__PURE__ */ __name((_) => se_ClickFeedbackList(_, context), "ClickFeedbackItems"),
    IndexId: [],
    QueryId: [],
    RelevanceFeedbackItems: import_smithy_client._json
  });
}, "se_SubmitFeedbackRequest");
var se_Template = /* @__PURE__ */ __name((input, context) => {
  return input;
}, "se_Template");
var se_TemplateConfiguration = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    Template: /* @__PURE__ */ __name((_) => se_Template(_, context), "Template")
  });
}, "se_TemplateConfiguration");
var se_TimeRange = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    EndTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "EndTime"),
    StartTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "StartTime")
  });
}, "se_TimeRange");
var se_UpdateDataSourceRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    Configuration: /* @__PURE__ */ __name((_) => se_DataSourceConfiguration(_, context), "Configuration"),
    CustomDocumentEnrichmentConfiguration: /* @__PURE__ */ __name((_) => se_CustomDocumentEnrichmentConfiguration(_, context), "CustomDocumentEnrichmentConfiguration"),
    Description: [],
    Id: [],
    IndexId: [],
    LanguageCode: [],
    Name: [],
    RoleArn: [],
    Schedule: [],
    VpcConfiguration: import_smithy_client._json
  });
}, "se_UpdateDataSourceRequest");
var se_WebCrawlerConfiguration = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AuthenticationConfiguration: import_smithy_client._json,
    CrawlDepth: [],
    MaxContentSizePerPageInMegaBytes: import_smithy_client.serializeFloat,
    MaxLinksPerPage: [],
    MaxUrlsPerMinuteCrawlRate: [],
    ProxyConfiguration: import_smithy_client._json,
    UrlExclusionPatterns: import_smithy_client._json,
    UrlInclusionPatterns: import_smithy_client._json,
    Urls: import_smithy_client._json
  });
}, "se_WebCrawlerConfiguration");
var de_CollapsedResultDetail = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    DocumentAttribute: /* @__PURE__ */ __name((_) => de_DocumentAttribute(_, context), "DocumentAttribute"),
    ExpandedResults: /* @__PURE__ */ __name((_) => de_ExpandedResultList(_, context), "ExpandedResults")
  });
}, "de_CollapsedResultDetail");
var de_CustomDocumentEnrichmentConfiguration = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    InlineConfigurations: /* @__PURE__ */ __name((_) => de_InlineCustomDocumentEnrichmentConfigurationList(_, context), "InlineConfigurations"),
    PostExtractionHookConfiguration: /* @__PURE__ */ __name((_) => de_HookConfiguration(_, context), "PostExtractionHookConfiguration"),
    PreExtractionHookConfiguration: /* @__PURE__ */ __name((_) => de_HookConfiguration(_, context), "PreExtractionHookConfiguration"),
    RoleArn: import_smithy_client.expectString
  });
}, "de_CustomDocumentEnrichmentConfiguration");
var de_DataSourceConfiguration = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AlfrescoConfiguration: import_smithy_client._json,
    BoxConfiguration: import_smithy_client._json,
    ConfluenceConfiguration: import_smithy_client._json,
    DatabaseConfiguration: import_smithy_client._json,
    FsxConfiguration: import_smithy_client._json,
    GitHubConfiguration: import_smithy_client._json,
    GoogleDriveConfiguration: import_smithy_client._json,
    JiraConfiguration: import_smithy_client._json,
    OneDriveConfiguration: import_smithy_client._json,
    QuipConfiguration: import_smithy_client._json,
    S3Configuration: import_smithy_client._json,
    SalesforceConfiguration: import_smithy_client._json,
    ServiceNowConfiguration: import_smithy_client._json,
    SharePointConfiguration: import_smithy_client._json,
    SlackConfiguration: import_smithy_client._json,
    TemplateConfiguration: /* @__PURE__ */ __name((_) => de_TemplateConfiguration(_, context), "TemplateConfiguration"),
    WebCrawlerConfiguration: /* @__PURE__ */ __name((_) => de_WebCrawlerConfiguration(_, context), "WebCrawlerConfiguration"),
    WorkDocsConfiguration: import_smithy_client._json
  });
}, "de_DataSourceConfiguration");
var de_DataSourceSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedAt"),
    Id: import_smithy_client.expectString,
    LanguageCode: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    Type: import_smithy_client.expectString,
    UpdatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "UpdatedAt")
  });
}, "de_DataSourceSummary");
var de_DataSourceSummaryList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_DataSourceSummary(entry, context);
  });
  return retVal;
}, "de_DataSourceSummaryList");
var de_DataSourceSyncJob = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    DataSourceErrorCode: import_smithy_client.expectString,
    EndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "EndTime"),
    ErrorCode: import_smithy_client.expectString,
    ErrorMessage: import_smithy_client.expectString,
    ExecutionId: import_smithy_client.expectString,
    Metrics: import_smithy_client._json,
    StartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "StartTime"),
    Status: import_smithy_client.expectString
  });
}, "de_DataSourceSyncJob");
var de_DataSourceSyncJobHistoryList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_DataSourceSyncJob(entry, context);
  });
  return retVal;
}, "de_DataSourceSyncJobHistoryList");
var de_DescribeDataSourceResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Configuration: /* @__PURE__ */ __name((_) => de_DataSourceConfiguration(_, context), "Configuration"),
    CreatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedAt"),
    CustomDocumentEnrichmentConfiguration: /* @__PURE__ */ __name((_) => de_CustomDocumentEnrichmentConfiguration(_, context), "CustomDocumentEnrichmentConfiguration"),
    Description: import_smithy_client.expectString,
    ErrorMessage: import_smithy_client.expectString,
    Id: import_smithy_client.expectString,
    IndexId: import_smithy_client.expectString,
    LanguageCode: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    RoleArn: import_smithy_client.expectString,
    Schedule: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    Type: import_smithy_client.expectString,
    UpdatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "UpdatedAt"),
    VpcConfiguration: import_smithy_client._json
  });
}, "de_DescribeDataSourceResponse");
var de_DescribeExperienceResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Configuration: import_smithy_client._json,
    CreatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedAt"),
    Description: import_smithy_client.expectString,
    Endpoints: import_smithy_client._json,
    ErrorMessage: import_smithy_client.expectString,
    Id: import_smithy_client.expectString,
    IndexId: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    RoleArn: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    UpdatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "UpdatedAt")
  });
}, "de_DescribeExperienceResponse");
var de_DescribeFaqResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedAt"),
    Description: import_smithy_client.expectString,
    ErrorMessage: import_smithy_client.expectString,
    FileFormat: import_smithy_client.expectString,
    Id: import_smithy_client.expectString,
    IndexId: import_smithy_client.expectString,
    LanguageCode: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    RoleArn: import_smithy_client.expectString,
    S3Path: import_smithy_client._json,
    Status: import_smithy_client.expectString,
    UpdatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "UpdatedAt")
  });
}, "de_DescribeFaqResponse");
var de_DescribeIndexResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CapacityUnits: import_smithy_client._json,
    CreatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedAt"),
    Description: import_smithy_client.expectString,
    DocumentMetadataConfigurations: import_smithy_client._json,
    Edition: import_smithy_client.expectString,
    ErrorMessage: import_smithy_client.expectString,
    Id: import_smithy_client.expectString,
    IndexStatistics: import_smithy_client._json,
    Name: import_smithy_client.expectString,
    RoleArn: import_smithy_client.expectString,
    ServerSideEncryptionConfiguration: import_smithy_client._json,
    Status: import_smithy_client.expectString,
    UpdatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "UpdatedAt"),
    UserContextPolicy: import_smithy_client.expectString,
    UserGroupResolutionConfiguration: import_smithy_client._json,
    UserTokenConfigurations: import_smithy_client._json
  });
}, "de_DescribeIndexResponse");
var de_DescribePrincipalMappingResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    DataSourceId: import_smithy_client.expectString,
    GroupId: import_smithy_client.expectString,
    GroupOrderingIdSummaries: /* @__PURE__ */ __name((_) => de_GroupOrderingIdSummaries(_, context), "GroupOrderingIdSummaries"),
    IndexId: import_smithy_client.expectString
  });
}, "de_DescribePrincipalMappingResponse");
var de_DescribeQuerySuggestionsBlockListResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedAt"),
    Description: import_smithy_client.expectString,
    ErrorMessage: import_smithy_client.expectString,
    FileSizeBytes: import_smithy_client.expectLong,
    Id: import_smithy_client.expectString,
    IndexId: import_smithy_client.expectString,
    ItemCount: import_smithy_client.expectInt32,
    Name: import_smithy_client.expectString,
    RoleArn: import_smithy_client.expectString,
    SourceS3Path: import_smithy_client._json,
    Status: import_smithy_client.expectString,
    UpdatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "UpdatedAt")
  });
}, "de_DescribeQuerySuggestionsBlockListResponse");
var de_DescribeQuerySuggestionsConfigResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AttributeSuggestionsConfig: import_smithy_client._json,
    IncludeQueriesWithoutUserInformation: import_smithy_client.expectBoolean,
    LastClearTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastClearTime"),
    LastSuggestionsBuildTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastSuggestionsBuildTime"),
    MinimumNumberOfQueryingUsers: import_smithy_client.expectInt32,
    MinimumQueryCount: import_smithy_client.expectInt32,
    Mode: import_smithy_client.expectString,
    QueryLogLookBackWindowInDays: import_smithy_client.expectInt32,
    Status: import_smithy_client.expectString,
    TotalSuggestionsCount: import_smithy_client.expectInt32
  });
}, "de_DescribeQuerySuggestionsConfigResponse");
var de_DescribeThesaurusResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedAt"),
    Description: import_smithy_client.expectString,
    ErrorMessage: import_smithy_client.expectString,
    FileSizeBytes: import_smithy_client.expectLong,
    Id: import_smithy_client.expectString,
    IndexId: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    RoleArn: import_smithy_client.expectString,
    SourceS3Path: import_smithy_client._json,
    Status: import_smithy_client.expectString,
    SynonymRuleCount: import_smithy_client.expectLong,
    TermCount: import_smithy_client.expectLong,
    UpdatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "UpdatedAt")
  });
}, "de_DescribeThesaurusResponse");
var de_DocumentAttribute = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Key: import_smithy_client.expectString,
    Value: /* @__PURE__ */ __name((_) => de_DocumentAttributeValue(_, context), "Value")
  });
}, "de_DocumentAttribute");
var de_DocumentAttributeCondition = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ConditionDocumentAttributeKey: import_smithy_client.expectString,
    ConditionOnValue: /* @__PURE__ */ __name((_) => de_DocumentAttributeValue(_, context), "ConditionOnValue"),
    Operator: import_smithy_client.expectString
  });
}, "de_DocumentAttributeCondition");
var de_DocumentAttributeList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_DocumentAttribute(entry, context);
  });
  return retVal;
}, "de_DocumentAttributeList");
var de_DocumentAttributeTarget = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    TargetDocumentAttributeKey: import_smithy_client.expectString,
    TargetDocumentAttributeValue: /* @__PURE__ */ __name((_) => de_DocumentAttributeValue(_, context), "TargetDocumentAttributeValue"),
    TargetDocumentAttributeValueDeletion: import_smithy_client.expectBoolean
  });
}, "de_DocumentAttributeTarget");
var de_DocumentAttributeValue = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    DateValue: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "DateValue"),
    LongValue: import_smithy_client.expectLong,
    StringListValue: import_smithy_client._json,
    StringValue: import_smithy_client.expectString
  });
}, "de_DocumentAttributeValue");
var de_DocumentAttributeValueCountPair = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Count: import_smithy_client.expectInt32,
    DocumentAttributeValue: /* @__PURE__ */ __name((_) => de_DocumentAttributeValue(_, context), "DocumentAttributeValue"),
    FacetResults: /* @__PURE__ */ __name((_) => de_FacetResultList(_, context), "FacetResults")
  });
}, "de_DocumentAttributeValueCountPair");
var de_DocumentAttributeValueCountPairList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_DocumentAttributeValueCountPair(entry, context);
  });
  return retVal;
}, "de_DocumentAttributeValueCountPairList");
var de_ExpandedResultItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    DocumentAttributes: /* @__PURE__ */ __name((_) => de_DocumentAttributeList(_, context), "DocumentAttributes"),
    DocumentExcerpt: import_smithy_client._json,
    DocumentId: import_smithy_client.expectString,
    DocumentTitle: import_smithy_client._json,
    DocumentURI: import_smithy_client.expectString,
    Id: import_smithy_client.expectString
  });
}, "de_ExpandedResultItem");
var de_ExpandedResultList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ExpandedResultItem(entry, context);
  });
  return retVal;
}, "de_ExpandedResultList");
var de_ExperiencesSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedAt"),
    Endpoints: import_smithy_client._json,
    Id: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Status: import_smithy_client.expectString
  });
}, "de_ExperiencesSummary");
var de_ExperiencesSummaryList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ExperiencesSummary(entry, context);
  });
  return retVal;
}, "de_ExperiencesSummaryList");
var de_FacetResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    DocumentAttributeKey: import_smithy_client.expectString,
    DocumentAttributeValueCountPairs: /* @__PURE__ */ __name((_) => de_DocumentAttributeValueCountPairList(_, context), "DocumentAttributeValueCountPairs"),
    DocumentAttributeValueType: import_smithy_client.expectString
  });
}, "de_FacetResult");
var de_FacetResultList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_FacetResult(entry, context);
  });
  return retVal;
}, "de_FacetResultList");
var de_FaqSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedAt"),
    FileFormat: import_smithy_client.expectString,
    Id: import_smithy_client.expectString,
    LanguageCode: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    UpdatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "UpdatedAt")
  });
}, "de_FaqSummary");
var de_FaqSummaryItems = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_FaqSummary(entry, context);
  });
  return retVal;
}, "de_FaqSummaryItems");
var de_FeaturedResultsItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AdditionalAttributes: import_smithy_client._json,
    DocumentAttributes: /* @__PURE__ */ __name((_) => de_DocumentAttributeList(_, context), "DocumentAttributes"),
    DocumentExcerpt: import_smithy_client._json,
    DocumentId: import_smithy_client.expectString,
    DocumentTitle: import_smithy_client._json,
    DocumentURI: import_smithy_client.expectString,
    FeedbackToken: import_smithy_client.expectString,
    Id: import_smithy_client.expectString,
    Type: import_smithy_client.expectString
  });
}, "de_FeaturedResultsItem");
var de_FeaturedResultsItemList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_FeaturedResultsItem(entry, context);
  });
  return retVal;
}, "de_FeaturedResultsItemList");
var de_GetQuerySuggestionsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    QuerySuggestionsId: import_smithy_client.expectString,
    Suggestions: /* @__PURE__ */ __name((_) => de_SuggestionList(_, context), "Suggestions")
  });
}, "de_GetQuerySuggestionsResponse");
var de_GetSnapshotsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    SnapShotTimeFilter: /* @__PURE__ */ __name((_) => de_TimeRange(_, context), "SnapShotTimeFilter"),
    SnapshotsData: import_smithy_client._json,
    SnapshotsDataHeader: import_smithy_client._json
  });
}, "de_GetSnapshotsResponse");
var de_GroupOrderingIdSummaries = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_GroupOrderingIdSummary(entry, context);
  });
  return retVal;
}, "de_GroupOrderingIdSummaries");
var de_GroupOrderingIdSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    FailureReason: import_smithy_client.expectString,
    LastUpdatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastUpdatedAt"),
    OrderingId: import_smithy_client.expectLong,
    ReceivedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ReceivedAt"),
    Status: import_smithy_client.expectString
  });
}, "de_GroupOrderingIdSummary");
var de_HookConfiguration = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    InvocationCondition: /* @__PURE__ */ __name((_) => de_DocumentAttributeCondition(_, context), "InvocationCondition"),
    LambdaArn: import_smithy_client.expectString,
    S3Bucket: import_smithy_client.expectString
  });
}, "de_HookConfiguration");
var de_IndexConfigurationSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedAt"),
    Edition: import_smithy_client.expectString,
    Id: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    UpdatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "UpdatedAt")
  });
}, "de_IndexConfigurationSummary");
var de_IndexConfigurationSummaryList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_IndexConfigurationSummary(entry, context);
  });
  return retVal;
}, "de_IndexConfigurationSummaryList");
var de_InlineCustomDocumentEnrichmentConfiguration = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Condition: /* @__PURE__ */ __name((_) => de_DocumentAttributeCondition(_, context), "Condition"),
    DocumentContentDeletion: import_smithy_client.expectBoolean,
    Target: /* @__PURE__ */ __name((_) => de_DocumentAttributeTarget(_, context), "Target")
  });
}, "de_InlineCustomDocumentEnrichmentConfiguration");
var de_InlineCustomDocumentEnrichmentConfigurationList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_InlineCustomDocumentEnrichmentConfiguration(entry, context);
  });
  return retVal;
}, "de_InlineCustomDocumentEnrichmentConfigurationList");
var de_ListDataSourcesResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    SummaryItems: /* @__PURE__ */ __name((_) => de_DataSourceSummaryList(_, context), "SummaryItems")
  });
}, "de_ListDataSourcesResponse");
var de_ListDataSourceSyncJobsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    History: /* @__PURE__ */ __name((_) => de_DataSourceSyncJobHistoryList(_, context), "History"),
    NextToken: import_smithy_client.expectString
  });
}, "de_ListDataSourceSyncJobsResponse");
var de_ListEntityPersonasResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    SummaryItems: /* @__PURE__ */ __name((_) => de_PersonasSummaryList(_, context), "SummaryItems")
  });
}, "de_ListEntityPersonasResponse");
var de_ListExperiencesResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    SummaryItems: /* @__PURE__ */ __name((_) => de_ExperiencesSummaryList(_, context), "SummaryItems")
  });
}, "de_ListExperiencesResponse");
var de_ListFaqsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    FaqSummaryItems: /* @__PURE__ */ __name((_) => de_FaqSummaryItems(_, context), "FaqSummaryItems"),
    NextToken: import_smithy_client.expectString
  });
}, "de_ListFaqsResponse");
var de_ListIndicesResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    IndexConfigurationSummaryItems: /* @__PURE__ */ __name((_) => de_IndexConfigurationSummaryList(_, context), "IndexConfigurationSummaryItems"),
    NextToken: import_smithy_client.expectString
  });
}, "de_ListIndicesResponse");
var de_ListQuerySuggestionsBlockListsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    BlockListSummaryItems: /* @__PURE__ */ __name((_) => de_QuerySuggestionsBlockListSummaryItems(_, context), "BlockListSummaryItems"),
    NextToken: import_smithy_client.expectString
  });
}, "de_ListQuerySuggestionsBlockListsResponse");
var de_ListThesauriResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    ThesaurusSummaryItems: /* @__PURE__ */ __name((_) => de_ThesaurusSummaryItems(_, context), "ThesaurusSummaryItems")
  });
}, "de_ListThesauriResponse");
var de_PersonasSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedAt"),
    EntityId: import_smithy_client.expectString,
    Persona: import_smithy_client.expectString,
    UpdatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "UpdatedAt")
  });
}, "de_PersonasSummary");
var de_PersonasSummaryList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_PersonasSummary(entry, context);
  });
  return retVal;
}, "de_PersonasSummaryList");
var de_QueryResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    FacetResults: /* @__PURE__ */ __name((_) => de_FacetResultList(_, context), "FacetResults"),
    FeaturedResultsItems: /* @__PURE__ */ __name((_) => de_FeaturedResultsItemList(_, context), "FeaturedResultsItems"),
    QueryId: import_smithy_client.expectString,
    ResultItems: /* @__PURE__ */ __name((_) => de_QueryResultItemList(_, context), "ResultItems"),
    SpellCorrectedQueries: import_smithy_client._json,
    TotalNumberOfResults: import_smithy_client.expectInt32,
    Warnings: import_smithy_client._json
  });
}, "de_QueryResult");
var de_QueryResultItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AdditionalAttributes: import_smithy_client._json,
    CollapsedResultDetail: /* @__PURE__ */ __name((_) => de_CollapsedResultDetail(_, context), "CollapsedResultDetail"),
    DocumentAttributes: /* @__PURE__ */ __name((_) => de_DocumentAttributeList(_, context), "DocumentAttributes"),
    DocumentExcerpt: import_smithy_client._json,
    DocumentId: import_smithy_client.expectString,
    DocumentTitle: import_smithy_client._json,
    DocumentURI: import_smithy_client.expectString,
    FeedbackToken: import_smithy_client.expectString,
    Format: import_smithy_client.expectString,
    Id: import_smithy_client.expectString,
    ScoreAttributes: import_smithy_client._json,
    TableExcerpt: import_smithy_client._json,
    Type: import_smithy_client.expectString
  });
}, "de_QueryResultItem");
var de_QueryResultItemList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_QueryResultItem(entry, context);
  });
  return retVal;
}, "de_QueryResultItemList");
var de_QuerySuggestionsBlockListSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedAt"),
    Id: import_smithy_client.expectString,
    ItemCount: import_smithy_client.expectInt32,
    Name: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    UpdatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "UpdatedAt")
  });
}, "de_QuerySuggestionsBlockListSummary");
var de_QuerySuggestionsBlockListSummaryItems = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_QuerySuggestionsBlockListSummary(entry, context);
  });
  return retVal;
}, "de_QuerySuggestionsBlockListSummaryItems");
var de_RetrieveResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    QueryId: import_smithy_client.expectString,
    ResultItems: /* @__PURE__ */ __name((_) => de_RetrieveResultItemList(_, context), "ResultItems")
  });
}, "de_RetrieveResult");
var de_RetrieveResultItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Content: import_smithy_client.expectString,
    DocumentAttributes: /* @__PURE__ */ __name((_) => de_DocumentAttributeList(_, context), "DocumentAttributes"),
    DocumentId: import_smithy_client.expectString,
    DocumentTitle: import_smithy_client.expectString,
    DocumentURI: import_smithy_client.expectString,
    Id: import_smithy_client.expectString,
    ScoreAttributes: import_smithy_client._json
  });
}, "de_RetrieveResultItem");
var de_RetrieveResultItemList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_RetrieveResultItem(entry, context);
  });
  return retVal;
}, "de_RetrieveResultItemList");
var de_SourceDocument = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AdditionalAttributes: /* @__PURE__ */ __name((_) => de_DocumentAttributeList(_, context), "AdditionalAttributes"),
    DocumentId: import_smithy_client.expectString,
    SuggestionAttributes: import_smithy_client._json
  });
}, "de_SourceDocument");
var de_SourceDocuments = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_SourceDocument(entry, context);
  });
  return retVal;
}, "de_SourceDocuments");
var de_Suggestion = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Id: import_smithy_client.expectString,
    SourceDocuments: /* @__PURE__ */ __name((_) => de_SourceDocuments(_, context), "SourceDocuments"),
    Value: import_smithy_client._json
  });
}, "de_Suggestion");
var de_SuggestionList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Suggestion(entry, context);
  });
  return retVal;
}, "de_SuggestionList");
var de_Template = /* @__PURE__ */ __name((output, context) => {
  return output;
}, "de_Template");
var de_TemplateConfiguration = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Template: /* @__PURE__ */ __name((_) => de_Template(_, context), "Template")
  });
}, "de_TemplateConfiguration");
var de_ThesaurusSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedAt"),
    Id: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    UpdatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "UpdatedAt")
  });
}, "de_ThesaurusSummary");
var de_ThesaurusSummaryItems = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ThesaurusSummary(entry, context);
  });
  return retVal;
}, "de_ThesaurusSummaryItems");
var de_TimeRange = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    EndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "EndTime"),
    StartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "StartTime")
  });
}, "de_TimeRange");
var de_WebCrawlerConfiguration = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AuthenticationConfiguration: import_smithy_client._json,
    CrawlDepth: import_smithy_client.expectInt32,
    MaxContentSizePerPageInMegaBytes: import_smithy_client.limitedParseFloat32,
    MaxLinksPerPage: import_smithy_client.expectInt32,
    MaxUrlsPerMinuteCrawlRate: import_smithy_client.expectInt32,
    ProxyConfiguration: import_smithy_client._json,
    UrlExclusionPatterns: import_smithy_client._json,
    UrlInclusionPatterns: import_smithy_client._json,
    Urls: import_smithy_client._json
  });
}, "de_WebCrawlerConfiguration");
var deserializeMetadata = /* @__PURE__ */ __name((output) => ({
  httpStatusCode: output.statusCode,
  requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
  extendedRequestId: output.headers["x-amz-id-2"],
  cfId: output.headers["x-amz-cf-id"]
}), "deserializeMetadata");
var throwDefaultError = (0, import_smithy_client.withBaseException)(KendraServiceException);
var buildHttpRpcRequest = /* @__PURE__ */ __name(async (context, headers, path, resolvedHostname, body) => {
  const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
  const contents = {
    protocol,
    hostname,
    port,
    method: "POST",
    path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
    headers
  };
  if (resolvedHostname !== void 0) {
    contents.hostname = resolvedHostname;
  }
  if (body !== void 0) {
    contents.body = body;
  }
  return new import_protocol_http.HttpRequest(contents);
}, "buildHttpRpcRequest");
function sharedHeaders(operation) {
  return {
    "content-type": "application/x-amz-json-1.1",
    "x-amz-target": `AWSKendraFrontendService.${operation}`
  };
}
__name(sharedHeaders, "sharedHeaders");

// src/commands/AssociateEntitiesToExperienceCommand.ts
var AssociateEntitiesToExperienceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "AssociateEntitiesToExperience", {}).n("KendraClient", "AssociateEntitiesToExperienceCommand").f(void 0, void 0).ser(se_AssociateEntitiesToExperienceCommand).de(de_AssociateEntitiesToExperienceCommand).build() {
  static {
    __name(this, "AssociateEntitiesToExperienceCommand");
  }
};

// src/commands/AssociatePersonasToEntitiesCommand.ts



var AssociatePersonasToEntitiesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "AssociatePersonasToEntities", {}).n("KendraClient", "AssociatePersonasToEntitiesCommand").f(void 0, void 0).ser(se_AssociatePersonasToEntitiesCommand).de(de_AssociatePersonasToEntitiesCommand).build() {
  static {
    __name(this, "AssociatePersonasToEntitiesCommand");
  }
};

// src/commands/BatchDeleteDocumentCommand.ts



var BatchDeleteDocumentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "BatchDeleteDocument", {}).n("KendraClient", "BatchDeleteDocumentCommand").f(void 0, void 0).ser(se_BatchDeleteDocumentCommand).de(de_BatchDeleteDocumentCommand).build() {
  static {
    __name(this, "BatchDeleteDocumentCommand");
  }
};

// src/commands/BatchDeleteFeaturedResultsSetCommand.ts



var BatchDeleteFeaturedResultsSetCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "BatchDeleteFeaturedResultsSet", {}).n("KendraClient", "BatchDeleteFeaturedResultsSetCommand").f(void 0, void 0).ser(se_BatchDeleteFeaturedResultsSetCommand).de(de_BatchDeleteFeaturedResultsSetCommand).build() {
  static {
    __name(this, "BatchDeleteFeaturedResultsSetCommand");
  }
};

// src/commands/BatchGetDocumentStatusCommand.ts



var BatchGetDocumentStatusCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "BatchGetDocumentStatus", {}).n("KendraClient", "BatchGetDocumentStatusCommand").f(void 0, void 0).ser(se_BatchGetDocumentStatusCommand).de(de_BatchGetDocumentStatusCommand).build() {
  static {
    __name(this, "BatchGetDocumentStatusCommand");
  }
};

// src/commands/BatchPutDocumentCommand.ts



var BatchPutDocumentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "BatchPutDocument", {}).n("KendraClient", "BatchPutDocumentCommand").f(void 0, void 0).ser(se_BatchPutDocumentCommand).de(de_BatchPutDocumentCommand).build() {
  static {
    __name(this, "BatchPutDocumentCommand");
  }
};

// src/commands/ClearQuerySuggestionsCommand.ts



var ClearQuerySuggestionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ClearQuerySuggestions", {}).n("KendraClient", "ClearQuerySuggestionsCommand").f(void 0, void 0).ser(se_ClearQuerySuggestionsCommand).de(de_ClearQuerySuggestionsCommand).build() {
  static {
    __name(this, "ClearQuerySuggestionsCommand");
  }
};

// src/commands/CreateAccessControlConfigurationCommand.ts



var CreateAccessControlConfigurationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "CreateAccessControlConfiguration", {}).n("KendraClient", "CreateAccessControlConfigurationCommand").f(void 0, void 0).ser(se_CreateAccessControlConfigurationCommand).de(de_CreateAccessControlConfigurationCommand).build() {
  static {
    __name(this, "CreateAccessControlConfigurationCommand");
  }
};

// src/commands/CreateDataSourceCommand.ts



var CreateDataSourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "CreateDataSource", {}).n("KendraClient", "CreateDataSourceCommand").f(void 0, void 0).ser(se_CreateDataSourceCommand).de(de_CreateDataSourceCommand).build() {
  static {
    __name(this, "CreateDataSourceCommand");
  }
};

// src/commands/CreateExperienceCommand.ts



var CreateExperienceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "CreateExperience", {}).n("KendraClient", "CreateExperienceCommand").f(void 0, void 0).ser(se_CreateExperienceCommand).de(de_CreateExperienceCommand).build() {
  static {
    __name(this, "CreateExperienceCommand");
  }
};

// src/commands/CreateFaqCommand.ts



var CreateFaqCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "CreateFaq", {}).n("KendraClient", "CreateFaqCommand").f(void 0, void 0).ser(se_CreateFaqCommand).de(de_CreateFaqCommand).build() {
  static {
    __name(this, "CreateFaqCommand");
  }
};

// src/commands/CreateFeaturedResultsSetCommand.ts



var CreateFeaturedResultsSetCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "CreateFeaturedResultsSet", {}).n("KendraClient", "CreateFeaturedResultsSetCommand").f(void 0, void 0).ser(se_CreateFeaturedResultsSetCommand).de(de_CreateFeaturedResultsSetCommand).build() {
  static {
    __name(this, "CreateFeaturedResultsSetCommand");
  }
};

// src/commands/CreateIndexCommand.ts



var CreateIndexCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "CreateIndex", {}).n("KendraClient", "CreateIndexCommand").f(CreateIndexRequestFilterSensitiveLog, void 0).ser(se_CreateIndexCommand).de(de_CreateIndexCommand).build() {
  static {
    __name(this, "CreateIndexCommand");
  }
};

// src/commands/CreateQuerySuggestionsBlockListCommand.ts



var CreateQuerySuggestionsBlockListCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "CreateQuerySuggestionsBlockList", {}).n("KendraClient", "CreateQuerySuggestionsBlockListCommand").f(void 0, void 0).ser(se_CreateQuerySuggestionsBlockListCommand).de(de_CreateQuerySuggestionsBlockListCommand).build() {
  static {
    __name(this, "CreateQuerySuggestionsBlockListCommand");
  }
};

// src/commands/CreateThesaurusCommand.ts



var CreateThesaurusCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "CreateThesaurus", {}).n("KendraClient", "CreateThesaurusCommand").f(void 0, void 0).ser(se_CreateThesaurusCommand).de(de_CreateThesaurusCommand).build() {
  static {
    __name(this, "CreateThesaurusCommand");
  }
};

// src/commands/DeleteAccessControlConfigurationCommand.ts



var DeleteAccessControlConfigurationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DeleteAccessControlConfiguration", {}).n("KendraClient", "DeleteAccessControlConfigurationCommand").f(void 0, void 0).ser(se_DeleteAccessControlConfigurationCommand).de(de_DeleteAccessControlConfigurationCommand).build() {
  static {
    __name(this, "DeleteAccessControlConfigurationCommand");
  }
};

// src/commands/DeleteDataSourceCommand.ts



var DeleteDataSourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DeleteDataSource", {}).n("KendraClient", "DeleteDataSourceCommand").f(void 0, void 0).ser(se_DeleteDataSourceCommand).de(de_DeleteDataSourceCommand).build() {
  static {
    __name(this, "DeleteDataSourceCommand");
  }
};

// src/commands/DeleteExperienceCommand.ts



var DeleteExperienceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DeleteExperience", {}).n("KendraClient", "DeleteExperienceCommand").f(void 0, void 0).ser(se_DeleteExperienceCommand).de(de_DeleteExperienceCommand).build() {
  static {
    __name(this, "DeleteExperienceCommand");
  }
};

// src/commands/DeleteFaqCommand.ts



var DeleteFaqCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DeleteFaq", {}).n("KendraClient", "DeleteFaqCommand").f(void 0, void 0).ser(se_DeleteFaqCommand).de(de_DeleteFaqCommand).build() {
  static {
    __name(this, "DeleteFaqCommand");
  }
};

// src/commands/DeleteIndexCommand.ts



var DeleteIndexCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DeleteIndex", {}).n("KendraClient", "DeleteIndexCommand").f(void 0, void 0).ser(se_DeleteIndexCommand).de(de_DeleteIndexCommand).build() {
  static {
    __name(this, "DeleteIndexCommand");
  }
};

// src/commands/DeletePrincipalMappingCommand.ts



var DeletePrincipalMappingCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DeletePrincipalMapping", {}).n("KendraClient", "DeletePrincipalMappingCommand").f(void 0, void 0).ser(se_DeletePrincipalMappingCommand).de(de_DeletePrincipalMappingCommand).build() {
  static {
    __name(this, "DeletePrincipalMappingCommand");
  }
};

// src/commands/DeleteQuerySuggestionsBlockListCommand.ts



var DeleteQuerySuggestionsBlockListCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DeleteQuerySuggestionsBlockList", {}).n("KendraClient", "DeleteQuerySuggestionsBlockListCommand").f(void 0, void 0).ser(se_DeleteQuerySuggestionsBlockListCommand).de(de_DeleteQuerySuggestionsBlockListCommand).build() {
  static {
    __name(this, "DeleteQuerySuggestionsBlockListCommand");
  }
};

// src/commands/DeleteThesaurusCommand.ts



var DeleteThesaurusCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DeleteThesaurus", {}).n("KendraClient", "DeleteThesaurusCommand").f(void 0, void 0).ser(se_DeleteThesaurusCommand).de(de_DeleteThesaurusCommand).build() {
  static {
    __name(this, "DeleteThesaurusCommand");
  }
};

// src/commands/DescribeAccessControlConfigurationCommand.ts



var DescribeAccessControlConfigurationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DescribeAccessControlConfiguration", {}).n("KendraClient", "DescribeAccessControlConfigurationCommand").f(void 0, void 0).ser(se_DescribeAccessControlConfigurationCommand).de(de_DescribeAccessControlConfigurationCommand).build() {
  static {
    __name(this, "DescribeAccessControlConfigurationCommand");
  }
};

// src/commands/DescribeDataSourceCommand.ts



var DescribeDataSourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DescribeDataSource", {}).n("KendraClient", "DescribeDataSourceCommand").f(void 0, void 0).ser(se_DescribeDataSourceCommand).de(de_DescribeDataSourceCommand).build() {
  static {
    __name(this, "DescribeDataSourceCommand");
  }
};

// src/commands/DescribeExperienceCommand.ts



var DescribeExperienceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DescribeExperience", {}).n("KendraClient", "DescribeExperienceCommand").f(void 0, void 0).ser(se_DescribeExperienceCommand).de(de_DescribeExperienceCommand).build() {
  static {
    __name(this, "DescribeExperienceCommand");
  }
};

// src/commands/DescribeFaqCommand.ts



var DescribeFaqCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DescribeFaq", {}).n("KendraClient", "DescribeFaqCommand").f(void 0, void 0).ser(se_DescribeFaqCommand).de(de_DescribeFaqCommand).build() {
  static {
    __name(this, "DescribeFaqCommand");
  }
};

// src/commands/DescribeFeaturedResultsSetCommand.ts



var DescribeFeaturedResultsSetCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DescribeFeaturedResultsSet", {}).n("KendraClient", "DescribeFeaturedResultsSetCommand").f(void 0, void 0).ser(se_DescribeFeaturedResultsSetCommand).de(de_DescribeFeaturedResultsSetCommand).build() {
  static {
    __name(this, "DescribeFeaturedResultsSetCommand");
  }
};

// src/commands/DescribeIndexCommand.ts



var DescribeIndexCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DescribeIndex", {}).n("KendraClient", "DescribeIndexCommand").f(void 0, DescribeIndexResponseFilterSensitiveLog).ser(se_DescribeIndexCommand).de(de_DescribeIndexCommand).build() {
  static {
    __name(this, "DescribeIndexCommand");
  }
};

// src/commands/DescribePrincipalMappingCommand.ts



var DescribePrincipalMappingCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DescribePrincipalMapping", {}).n("KendraClient", "DescribePrincipalMappingCommand").f(void 0, void 0).ser(se_DescribePrincipalMappingCommand).de(de_DescribePrincipalMappingCommand).build() {
  static {
    __name(this, "DescribePrincipalMappingCommand");
  }
};

// src/commands/DescribeQuerySuggestionsBlockListCommand.ts



var DescribeQuerySuggestionsBlockListCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DescribeQuerySuggestionsBlockList", {}).n("KendraClient", "DescribeQuerySuggestionsBlockListCommand").f(void 0, void 0).ser(se_DescribeQuerySuggestionsBlockListCommand).de(de_DescribeQuerySuggestionsBlockListCommand).build() {
  static {
    __name(this, "DescribeQuerySuggestionsBlockListCommand");
  }
};

// src/commands/DescribeQuerySuggestionsConfigCommand.ts



var DescribeQuerySuggestionsConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DescribeQuerySuggestionsConfig", {}).n("KendraClient", "DescribeQuerySuggestionsConfigCommand").f(void 0, void 0).ser(se_DescribeQuerySuggestionsConfigCommand).de(de_DescribeQuerySuggestionsConfigCommand).build() {
  static {
    __name(this, "DescribeQuerySuggestionsConfigCommand");
  }
};

// src/commands/DescribeThesaurusCommand.ts



var DescribeThesaurusCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DescribeThesaurus", {}).n("KendraClient", "DescribeThesaurusCommand").f(void 0, void 0).ser(se_DescribeThesaurusCommand).de(de_DescribeThesaurusCommand).build() {
  static {
    __name(this, "DescribeThesaurusCommand");
  }
};

// src/commands/DisassociateEntitiesFromExperienceCommand.ts



var DisassociateEntitiesFromExperienceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DisassociateEntitiesFromExperience", {}).n("KendraClient", "DisassociateEntitiesFromExperienceCommand").f(void 0, void 0).ser(se_DisassociateEntitiesFromExperienceCommand).de(de_DisassociateEntitiesFromExperienceCommand).build() {
  static {
    __name(this, "DisassociateEntitiesFromExperienceCommand");
  }
};

// src/commands/DisassociatePersonasFromEntitiesCommand.ts



var DisassociatePersonasFromEntitiesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "DisassociatePersonasFromEntities", {}).n("KendraClient", "DisassociatePersonasFromEntitiesCommand").f(void 0, void 0).ser(se_DisassociatePersonasFromEntitiesCommand).de(de_DisassociatePersonasFromEntitiesCommand).build() {
  static {
    __name(this, "DisassociatePersonasFromEntitiesCommand");
  }
};

// src/commands/GetQuerySuggestionsCommand.ts



var GetQuerySuggestionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "GetQuerySuggestions", {}).n("KendraClient", "GetQuerySuggestionsCommand").f(void 0, void 0).ser(se_GetQuerySuggestionsCommand).de(de_GetQuerySuggestionsCommand).build() {
  static {
    __name(this, "GetQuerySuggestionsCommand");
  }
};

// src/commands/GetSnapshotsCommand.ts



var GetSnapshotsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "GetSnapshots", {}).n("KendraClient", "GetSnapshotsCommand").f(void 0, void 0).ser(se_GetSnapshotsCommand).de(de_GetSnapshotsCommand).build() {
  static {
    __name(this, "GetSnapshotsCommand");
  }
};

// src/commands/ListAccessControlConfigurationsCommand.ts



var ListAccessControlConfigurationsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ListAccessControlConfigurations", {}).n("KendraClient", "ListAccessControlConfigurationsCommand").f(void 0, void 0).ser(se_ListAccessControlConfigurationsCommand).de(de_ListAccessControlConfigurationsCommand).build() {
  static {
    __name(this, "ListAccessControlConfigurationsCommand");
  }
};

// src/commands/ListDataSourcesCommand.ts



var ListDataSourcesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ListDataSources", {}).n("KendraClient", "ListDataSourcesCommand").f(void 0, void 0).ser(se_ListDataSourcesCommand).de(de_ListDataSourcesCommand).build() {
  static {
    __name(this, "ListDataSourcesCommand");
  }
};

// src/commands/ListDataSourceSyncJobsCommand.ts



var ListDataSourceSyncJobsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ListDataSourceSyncJobs", {}).n("KendraClient", "ListDataSourceSyncJobsCommand").f(void 0, void 0).ser(se_ListDataSourceSyncJobsCommand).de(de_ListDataSourceSyncJobsCommand).build() {
  static {
    __name(this, "ListDataSourceSyncJobsCommand");
  }
};

// src/commands/ListEntityPersonasCommand.ts



var ListEntityPersonasCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ListEntityPersonas", {}).n("KendraClient", "ListEntityPersonasCommand").f(void 0, void 0).ser(se_ListEntityPersonasCommand).de(de_ListEntityPersonasCommand).build() {
  static {
    __name(this, "ListEntityPersonasCommand");
  }
};

// src/commands/ListExperienceEntitiesCommand.ts



var ListExperienceEntitiesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ListExperienceEntities", {}).n("KendraClient", "ListExperienceEntitiesCommand").f(void 0, ListExperienceEntitiesResponseFilterSensitiveLog).ser(se_ListExperienceEntitiesCommand).de(de_ListExperienceEntitiesCommand).build() {
  static {
    __name(this, "ListExperienceEntitiesCommand");
  }
};

// src/commands/ListExperiencesCommand.ts



var ListExperiencesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ListExperiences", {}).n("KendraClient", "ListExperiencesCommand").f(void 0, void 0).ser(se_ListExperiencesCommand).de(de_ListExperiencesCommand).build() {
  static {
    __name(this, "ListExperiencesCommand");
  }
};

// src/commands/ListFaqsCommand.ts



var ListFaqsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ListFaqs", {}).n("KendraClient", "ListFaqsCommand").f(void 0, void 0).ser(se_ListFaqsCommand).de(de_ListFaqsCommand).build() {
  static {
    __name(this, "ListFaqsCommand");
  }
};

// src/commands/ListFeaturedResultsSetsCommand.ts



var ListFeaturedResultsSetsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ListFeaturedResultsSets", {}).n("KendraClient", "ListFeaturedResultsSetsCommand").f(void 0, void 0).ser(se_ListFeaturedResultsSetsCommand).de(de_ListFeaturedResultsSetsCommand).build() {
  static {
    __name(this, "ListFeaturedResultsSetsCommand");
  }
};

// src/commands/ListGroupsOlderThanOrderingIdCommand.ts



var ListGroupsOlderThanOrderingIdCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ListGroupsOlderThanOrderingId", {}).n("KendraClient", "ListGroupsOlderThanOrderingIdCommand").f(void 0, void 0).ser(se_ListGroupsOlderThanOrderingIdCommand).de(de_ListGroupsOlderThanOrderingIdCommand).build() {
  static {
    __name(this, "ListGroupsOlderThanOrderingIdCommand");
  }
};

// src/commands/ListIndicesCommand.ts



var ListIndicesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ListIndices", {}).n("KendraClient", "ListIndicesCommand").f(void 0, void 0).ser(se_ListIndicesCommand).de(de_ListIndicesCommand).build() {
  static {
    __name(this, "ListIndicesCommand");
  }
};

// src/commands/ListQuerySuggestionsBlockListsCommand.ts



var ListQuerySuggestionsBlockListsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ListQuerySuggestionsBlockLists", {}).n("KendraClient", "ListQuerySuggestionsBlockListsCommand").f(void 0, void 0).ser(se_ListQuerySuggestionsBlockListsCommand).de(de_ListQuerySuggestionsBlockListsCommand).build() {
  static {
    __name(this, "ListQuerySuggestionsBlockListsCommand");
  }
};

// src/commands/ListTagsForResourceCommand.ts



var ListTagsForResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ListTagsForResource", {}).n("KendraClient", "ListTagsForResourceCommand").f(void 0, void 0).ser(se_ListTagsForResourceCommand).de(de_ListTagsForResourceCommand).build() {
  static {
    __name(this, "ListTagsForResourceCommand");
  }
};

// src/commands/ListThesauriCommand.ts



var ListThesauriCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "ListThesauri", {}).n("KendraClient", "ListThesauriCommand").f(void 0, void 0).ser(se_ListThesauriCommand).de(de_ListThesauriCommand).build() {
  static {
    __name(this, "ListThesauriCommand");
  }
};

// src/commands/PutPrincipalMappingCommand.ts



var PutPrincipalMappingCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "PutPrincipalMapping", {}).n("KendraClient", "PutPrincipalMappingCommand").f(void 0, void 0).ser(se_PutPrincipalMappingCommand).de(de_PutPrincipalMappingCommand).build() {
  static {
    __name(this, "PutPrincipalMappingCommand");
  }
};

// src/commands/QueryCommand.ts



var QueryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "Query", {}).n("KendraClient", "QueryCommand").f(void 0, void 0).ser(se_QueryCommand).de(de_QueryCommand).build() {
  static {
    __name(this, "QueryCommand");
  }
};

// src/commands/RetrieveCommand.ts



var RetrieveCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "Retrieve", {}).n("KendraClient", "RetrieveCommand").f(void 0, void 0).ser(se_RetrieveCommand).de(de_RetrieveCommand).build() {
  static {
    __name(this, "RetrieveCommand");
  }
};

// src/commands/StartDataSourceSyncJobCommand.ts



var StartDataSourceSyncJobCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "StartDataSourceSyncJob", {}).n("KendraClient", "StartDataSourceSyncJobCommand").f(void 0, void 0).ser(se_StartDataSourceSyncJobCommand).de(de_StartDataSourceSyncJobCommand).build() {
  static {
    __name(this, "StartDataSourceSyncJobCommand");
  }
};

// src/commands/StopDataSourceSyncJobCommand.ts



var StopDataSourceSyncJobCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "StopDataSourceSyncJob", {}).n("KendraClient", "StopDataSourceSyncJobCommand").f(void 0, void 0).ser(se_StopDataSourceSyncJobCommand).de(de_StopDataSourceSyncJobCommand).build() {
  static {
    __name(this, "StopDataSourceSyncJobCommand");
  }
};

// src/commands/SubmitFeedbackCommand.ts



var SubmitFeedbackCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "SubmitFeedback", {}).n("KendraClient", "SubmitFeedbackCommand").f(void 0, void 0).ser(se_SubmitFeedbackCommand).de(de_SubmitFeedbackCommand).build() {
  static {
    __name(this, "SubmitFeedbackCommand");
  }
};

// src/commands/TagResourceCommand.ts



var TagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "TagResource", {}).n("KendraClient", "TagResourceCommand").f(void 0, void 0).ser(se_TagResourceCommand).de(de_TagResourceCommand).build() {
  static {
    __name(this, "TagResourceCommand");
  }
};

// src/commands/UntagResourceCommand.ts



var UntagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "UntagResource", {}).n("KendraClient", "UntagResourceCommand").f(void 0, void 0).ser(se_UntagResourceCommand).de(de_UntagResourceCommand).build() {
  static {
    __name(this, "UntagResourceCommand");
  }
};

// src/commands/UpdateAccessControlConfigurationCommand.ts



var UpdateAccessControlConfigurationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "UpdateAccessControlConfiguration", {}).n("KendraClient", "UpdateAccessControlConfigurationCommand").f(void 0, void 0).ser(se_UpdateAccessControlConfigurationCommand).de(de_UpdateAccessControlConfigurationCommand).build() {
  static {
    __name(this, "UpdateAccessControlConfigurationCommand");
  }
};

// src/commands/UpdateDataSourceCommand.ts



var UpdateDataSourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "UpdateDataSource", {}).n("KendraClient", "UpdateDataSourceCommand").f(void 0, void 0).ser(se_UpdateDataSourceCommand).de(de_UpdateDataSourceCommand).build() {
  static {
    __name(this, "UpdateDataSourceCommand");
  }
};

// src/commands/UpdateExperienceCommand.ts



var UpdateExperienceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "UpdateExperience", {}).n("KendraClient", "UpdateExperienceCommand").f(void 0, void 0).ser(se_UpdateExperienceCommand).de(de_UpdateExperienceCommand).build() {
  static {
    __name(this, "UpdateExperienceCommand");
  }
};

// src/commands/UpdateFeaturedResultsSetCommand.ts



var UpdateFeaturedResultsSetCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "UpdateFeaturedResultsSet", {}).n("KendraClient", "UpdateFeaturedResultsSetCommand").f(void 0, void 0).ser(se_UpdateFeaturedResultsSetCommand).de(de_UpdateFeaturedResultsSetCommand).build() {
  static {
    __name(this, "UpdateFeaturedResultsSetCommand");
  }
};

// src/commands/UpdateIndexCommand.ts



var UpdateIndexCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "UpdateIndex", {}).n("KendraClient", "UpdateIndexCommand").f(void 0, void 0).ser(se_UpdateIndexCommand).de(de_UpdateIndexCommand).build() {
  static {
    __name(this, "UpdateIndexCommand");
  }
};

// src/commands/UpdateQuerySuggestionsBlockListCommand.ts



var UpdateQuerySuggestionsBlockListCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "UpdateQuerySuggestionsBlockList", {}).n("KendraClient", "UpdateQuerySuggestionsBlockListCommand").f(void 0, void 0).ser(se_UpdateQuerySuggestionsBlockListCommand).de(de_UpdateQuerySuggestionsBlockListCommand).build() {
  static {
    __name(this, "UpdateQuerySuggestionsBlockListCommand");
  }
};

// src/commands/UpdateQuerySuggestionsConfigCommand.ts



var UpdateQuerySuggestionsConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "UpdateQuerySuggestionsConfig", {}).n("KendraClient", "UpdateQuerySuggestionsConfigCommand").f(void 0, void 0).ser(se_UpdateQuerySuggestionsConfigCommand).de(de_UpdateQuerySuggestionsConfigCommand).build() {
  static {
    __name(this, "UpdateQuerySuggestionsConfigCommand");
  }
};

// src/commands/UpdateThesaurusCommand.ts



var UpdateThesaurusCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSKendraFrontendService", "UpdateThesaurus", {}).n("KendraClient", "UpdateThesaurusCommand").f(void 0, void 0).ser(se_UpdateThesaurusCommand).de(de_UpdateThesaurusCommand).build() {
  static {
    __name(this, "UpdateThesaurusCommand");
  }
};

// src/Kendra.ts
var commands = {
  AssociateEntitiesToExperienceCommand,
  AssociatePersonasToEntitiesCommand,
  BatchDeleteDocumentCommand,
  BatchDeleteFeaturedResultsSetCommand,
  BatchGetDocumentStatusCommand,
  BatchPutDocumentCommand,
  ClearQuerySuggestionsCommand,
  CreateAccessControlConfigurationCommand,
  CreateDataSourceCommand,
  CreateExperienceCommand,
  CreateFaqCommand,
  CreateFeaturedResultsSetCommand,
  CreateIndexCommand,
  CreateQuerySuggestionsBlockListCommand,
  CreateThesaurusCommand,
  DeleteAccessControlConfigurationCommand,
  DeleteDataSourceCommand,
  DeleteExperienceCommand,
  DeleteFaqCommand,
  DeleteIndexCommand,
  DeletePrincipalMappingCommand,
  DeleteQuerySuggestionsBlockListCommand,
  DeleteThesaurusCommand,
  DescribeAccessControlConfigurationCommand,
  DescribeDataSourceCommand,
  DescribeExperienceCommand,
  DescribeFaqCommand,
  DescribeFeaturedResultsSetCommand,
  DescribeIndexCommand,
  DescribePrincipalMappingCommand,
  DescribeQuerySuggestionsBlockListCommand,
  DescribeQuerySuggestionsConfigCommand,
  DescribeThesaurusCommand,
  DisassociateEntitiesFromExperienceCommand,
  DisassociatePersonasFromEntitiesCommand,
  GetQuerySuggestionsCommand,
  GetSnapshotsCommand,
  ListAccessControlConfigurationsCommand,
  ListDataSourcesCommand,
  ListDataSourceSyncJobsCommand,
  ListEntityPersonasCommand,
  ListExperienceEntitiesCommand,
  ListExperiencesCommand,
  ListFaqsCommand,
  ListFeaturedResultsSetsCommand,
  ListGroupsOlderThanOrderingIdCommand,
  ListIndicesCommand,
  ListQuerySuggestionsBlockListsCommand,
  ListTagsForResourceCommand,
  ListThesauriCommand,
  PutPrincipalMappingCommand,
  QueryCommand,
  RetrieveCommand,
  StartDataSourceSyncJobCommand,
  StopDataSourceSyncJobCommand,
  SubmitFeedbackCommand,
  TagResourceCommand,
  UntagResourceCommand,
  UpdateAccessControlConfigurationCommand,
  UpdateDataSourceCommand,
  UpdateExperienceCommand,
  UpdateFeaturedResultsSetCommand,
  UpdateIndexCommand,
  UpdateQuerySuggestionsBlockListCommand,
  UpdateQuerySuggestionsConfigCommand,
  UpdateThesaurusCommand
};
var Kendra = class extends KendraClient {
  static {
    __name(this, "Kendra");
  }
};
(0, import_smithy_client.createAggregatedClient)(commands, Kendra);

// src/pagination/GetSnapshotsPaginator.ts

var paginateGetSnapshots = (0, import_core.createPaginator)(KendraClient, GetSnapshotsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListAccessControlConfigurationsPaginator.ts

var paginateListAccessControlConfigurations = (0, import_core.createPaginator)(KendraClient, ListAccessControlConfigurationsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListDataSourceSyncJobsPaginator.ts

var paginateListDataSourceSyncJobs = (0, import_core.createPaginator)(KendraClient, ListDataSourceSyncJobsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListDataSourcesPaginator.ts

var paginateListDataSources = (0, import_core.createPaginator)(KendraClient, ListDataSourcesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListEntityPersonasPaginator.ts

var paginateListEntityPersonas = (0, import_core.createPaginator)(KendraClient, ListEntityPersonasCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListExperienceEntitiesPaginator.ts

var paginateListExperienceEntities = (0, import_core.createPaginator)(KendraClient, ListExperienceEntitiesCommand, "NextToken", "NextToken", "");

// src/pagination/ListExperiencesPaginator.ts

var paginateListExperiences = (0, import_core.createPaginator)(KendraClient, ListExperiencesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListFaqsPaginator.ts

var paginateListFaqs = (0, import_core.createPaginator)(KendraClient, ListFaqsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListGroupsOlderThanOrderingIdPaginator.ts

var paginateListGroupsOlderThanOrderingId = (0, import_core.createPaginator)(KendraClient, ListGroupsOlderThanOrderingIdCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListIndicesPaginator.ts

var paginateListIndices = (0, import_core.createPaginator)(KendraClient, ListIndicesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListQuerySuggestionsBlockListsPaginator.ts

var paginateListQuerySuggestionsBlockLists = (0, import_core.createPaginator)(KendraClient, ListQuerySuggestionsBlockListsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListThesauriPaginator.ts

var paginateListThesauri = (0, import_core.createPaginator)(KendraClient, ListThesauriCommand, "NextToken", "NextToken", "MaxResults");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  KendraServiceException,
  __Client,
  KendraClient,
  Kendra,
  $Command,
  AssociateEntitiesToExperienceCommand,
  AssociatePersonasToEntitiesCommand,
  BatchDeleteDocumentCommand,
  BatchDeleteFeaturedResultsSetCommand,
  BatchGetDocumentStatusCommand,
  BatchPutDocumentCommand,
  ClearQuerySuggestionsCommand,
  CreateAccessControlConfigurationCommand,
  CreateDataSourceCommand,
  CreateExperienceCommand,
  CreateFaqCommand,
  CreateFeaturedResultsSetCommand,
  CreateIndexCommand,
  CreateQuerySuggestionsBlockListCommand,
  CreateThesaurusCommand,
  DeleteAccessControlConfigurationCommand,
  DeleteDataSourceCommand,
  DeleteExperienceCommand,
  DeleteFaqCommand,
  DeleteIndexCommand,
  DeletePrincipalMappingCommand,
  DeleteQuerySuggestionsBlockListCommand,
  DeleteThesaurusCommand,
  DescribeAccessControlConfigurationCommand,
  DescribeDataSourceCommand,
  DescribeExperienceCommand,
  DescribeFaqCommand,
  DescribeFeaturedResultsSetCommand,
  DescribeIndexCommand,
  DescribePrincipalMappingCommand,
  DescribeQuerySuggestionsBlockListCommand,
  DescribeQuerySuggestionsConfigCommand,
  DescribeThesaurusCommand,
  DisassociateEntitiesFromExperienceCommand,
  DisassociatePersonasFromEntitiesCommand,
  GetQuerySuggestionsCommand,
  GetSnapshotsCommand,
  ListAccessControlConfigurationsCommand,
  ListDataSourceSyncJobsCommand,
  ListDataSourcesCommand,
  ListEntityPersonasCommand,
  ListExperienceEntitiesCommand,
  ListExperiencesCommand,
  ListFaqsCommand,
  ListFeaturedResultsSetsCommand,
  ListGroupsOlderThanOrderingIdCommand,
  ListIndicesCommand,
  ListQuerySuggestionsBlockListsCommand,
  ListTagsForResourceCommand,
  ListThesauriCommand,
  PutPrincipalMappingCommand,
  QueryCommand,
  RetrieveCommand,
  StartDataSourceSyncJobCommand,
  StopDataSourceSyncJobCommand,
  SubmitFeedbackCommand,
  TagResourceCommand,
  UntagResourceCommand,
  UpdateAccessControlConfigurationCommand,
  UpdateDataSourceCommand,
  UpdateExperienceCommand,
  UpdateFeaturedResultsSetCommand,
  UpdateIndexCommand,
  UpdateQuerySuggestionsBlockListCommand,
  UpdateQuerySuggestionsConfigCommand,
  UpdateThesaurusCommand,
  paginateGetSnapshots,
  paginateListAccessControlConfigurations,
  paginateListDataSourceSyncJobs,
  paginateListDataSources,
  paginateListEntityPersonas,
  paginateListExperienceEntities,
  paginateListExperiences,
  paginateListFaqs,
  paginateListGroupsOlderThanOrderingId,
  paginateListIndices,
  paginateListQuerySuggestionsBlockLists,
  paginateListThesauri,
  AccessDeniedException,
  HighlightType,
  AdditionalResultAttributeValueType,
  AlfrescoEntity,
  EntityType,
  InternalServerException,
  ResourceAlreadyExistException,
  ResourceNotFoundException,
  ThrottlingException,
  ValidationException,
  Persona,
  AttributeSuggestionsMode,
  ErrorCode,
  ConflictException,
  DocumentStatus,
  ConditionOperator,
  ReadAccessType,
  PrincipalType,
  ContentType,
  ServiceQuotaExceededException,
  ConfluenceAttachmentFieldName,
  ConfluenceAuthenticationType,
  ConfluenceBlogFieldName,
  ConfluencePageFieldName,
  ConfluenceSpaceFieldName,
  ConfluenceVersion,
  DatabaseEngineType,
  QueryIdentifiersEnclosingOption,
  FsxFileSystemType,
  Type,
  IssueSubEntity,
  SalesforceChatterFeedIncludeFilterType,
  SalesforceKnowledgeArticleState,
  SalesforceStandardObjectName,
  ServiceNowAuthenticationType,
  ServiceNowBuildVersionType,
  SharePointOnlineAuthenticationType,
  SharePointVersion,
  SlackEntity,
  WebCrawlerMode,
  DataSourceType,
  FaqFileFormat,
  FeaturedResultsSetStatus,
  FeaturedResultsConflictException,
  IndexEdition,
  UserContextPolicy,
  UserGroupResolutionMode,
  KeyLocation,
  DataSourceStatus,
  EndpointType,
  ExperienceStatus,
  FaqStatus,
  Order,
  DocumentAttributeValueType,
  IndexStatus,
  PrincipalMappingStatus,
  QuerySuggestionsBlockListStatus,
  Mode,
  QuerySuggestionsStatus,
  ThesaurusStatus,
  SuggestionType,
  Interval,
  MetricType,
  InvalidRequestException,
  DataSourceSyncJobStatus,
  ResourceUnavailableException,
  MissingAttributeKeyStrategy,
  SortOrder,
  QueryResultType,
  QueryResultFormat,
  ServerSideEncryptionConfigurationFilterSensitiveLog,
  CreateIndexRequestFilterSensitiveLog,
  DescribeIndexResponseFilterSensitiveLog,
  EntityDisplayDataFilterSensitiveLog,
  ExperienceEntitiesSummaryFilterSensitiveLog,
  ListExperienceEntitiesResponseFilterSensitiveLog,
  ScoreConfidence,
  WarningCode,
  ResourceInUseException,
  RelevanceType
});

