import { Express, RequestHandler, ErrorRequestHandler } from 'express';
import { A as A2ARequestHandler } from '../../a2a_request_handler-DUvKWfix.cjs';
import '../../types-DNKcmF0f.cjs';

declare class A2AExpressApp {
    private requestHandler;
    private jsonRpcTransportHandler;
    constructor(requestHandler: A2ARequestHandler);
    /**
     * Adds A2A routes to an existing Express app.
     * @param app Optional existing Express app.
     * @param baseUrl The base URL for A2A endpoints (e.g., "/a2a/api").
     * @param middlewares Optional array of Express middlewares to apply to the A2A routes.
     * @param agentCardPath Optional custom path for the agent card endpoint (defaults to /.well-known/agent-card.json).
     * @returns The Express app with A2A routes.
     */
    setupRoutes(app: Express, baseUrl?: string, middlewares?: Array<RequestHandler | ErrorRequestHandler>, agentCardPath?: string): Express;
}

export { A2AExpressApp };
