/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationPlanVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.plan.logical.Fork;
import org.elasticsearch.xpack.esql.plan.logical.InlineStats;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public class UnionAll
extends Fork
implements PostOptimizationPlanVerificationAware {
    public UnionAll(Source source, List<LogicalPlan> children, List<Attribute> output) {
        super(source, children, output);
    }

    @Override
    public LogicalPlan replaceChildren(List<LogicalPlan> newChildren) {
        return new UnionAll(this.source(), newChildren, this.output());
    }

    @Override
    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, UnionAll::new, (Object)this.children(), this.output());
    }

    @Override
    public UnionAll replaceSubPlans(List<LogicalPlan> subPlans) {
        return new UnionAll(this.source(), subPlans, this.output());
    }

    @Override
    public Fork replaceSubPlansAndOutput(List<LogicalPlan> subPlans, List<Attribute> output) {
        return new UnionAll(this.source(), subPlans, output);
    }

    @Override
    public int hashCode() {
        return Objects.hash(UnionAll.class, this.children());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionAll other = (UnionAll)o;
        return Objects.equals(this.children(), other.children());
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return UnionAll::checkUnionAll;
    }

    private static void checkUnionAll(LogicalPlan plan, Failures failures) {
        if (plan instanceof UnionAll) {
            UnionAll unionAll = (UnionAll)plan;
            Map<String, DataType> outputTypes = unionAll.output().stream().collect(Collectors.toMap(NamedExpression::name, Expression::dataType));
            unionAll.children().forEach(subPlan -> {
                for (Attribute attr : subPlan.output()) {
                    DataType actual;
                    DataType expected = (DataType)outputTypes.get(attr.name());
                    if (expected == DataType.UNSUPPORTED || (actual = attr.dataType()) == expected) continue;
                    failures.add(Failure.fail(attr, "Column [{}] has conflicting data types in subqueries: [{}] and [{}]", new Object[]{attr.name(), actual, expected}));
                }
            });
        }
        if (plan instanceof InlineStats) {
            InlineStats inlineStats = (InlineStats)plan;
            Holder inlineStatsDescendantUnionAll = new Holder();
            inlineStats.forEachDownMayReturnEarly((p, breakEarly) -> {
                if (p instanceof UnionAll) {
                    UnionAll unionAll = (UnionAll)p;
                    inlineStatsDescendantUnionAll.set((Object)unionAll);
                    breakEarly.set((Object)true);
                    return;
                }
            });
            if (inlineStatsDescendantUnionAll.get() != null) {
                failures.add(Failure.fail((Node)inlineStatsDescendantUnionAll.get(), "INLINE STATS after subquery is not supported, as INLINE STATS cannot be used after an explicit or implicit LIMIT command", new Object[0]));
            }
        }
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postOptimizationPlanVerification() {
        return UnionAll::checkNestedUnionAlls;
    }

    private static void checkNestedUnionAlls(LogicalPlan logicalPlan, Failures failures) {
        if (logicalPlan instanceof UnionAll) {
            UnionAll unionAll = (UnionAll)logicalPlan;
            unionAll.forEachDown(Fork.class, otherForkOrUnionAll -> {
                if (unionAll == otherForkOrUnionAll) {
                    return;
                }
                failures.add(Failure.fail(otherForkOrUnionAll, otherForkOrUnionAll instanceof UnionAll ? "Nested subqueries are not supported" : "FORK inside subquery is not supported", new Object[0]));
            });
        }
    }
}

