/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.ChunkingStrategy;
import org.elasticsearch.xpack.core.inference.chunking.Chunker;
import org.elasticsearch.xpack.core.inference.chunking.ChunkerBuilder;
import org.elasticsearch.xpack.core.inference.chunking.SentenceBoundaryChunkingSettings;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.MapParam;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Options;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ChunkBytesRefEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Chunk
extends EsqlScalarFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Chunk", Chunk::new);
    public static final int DEFAULT_NUM_CHUNKS = Integer.MAX_VALUE;
    public static final int DEFAULT_CHUNK_SIZE = 300;
    private final Expression field;
    private final Expression options;
    static final String NUM_CHUNKS = "num_chunks";
    static final String CHUNK_SIZE = "chunk_size";
    public static final Map<String, DataType> ALLOWED_OPTIONS = Map.of("num_chunks", DataType.INTEGER, "chunk_size", DataType.INTEGER);

    @FunctionInfo(returnType={"keyword"}, preview=true, description="Use `CHUNK` to split a text field into smaller chunks.", detailedDescription="    Chunk can be used on fields from the text famiy like <<text, text>> and <<semantic-text, semantic_text>>.\n    Chunk will split a text field into smaller chunks, using a sentence-based chunking strategy.\n    The number of chunks returned, and the length of the sentences used to create the chunks can be specified.\n", examples={@Example(file="chunk", tag="chunk-with-field", applies_to="stack: preview 9.3.0")})
    public Chunk(Source source, @Param(name="field", type={"keyword", "text"}, description="The input to chunk.") Expression field, @MapParam(name="options", params={@MapParam.MapParamEntry(name="num_chunks", type={"integer"}, description="The number of chunks to return. Defaults to return all chunks."), @MapParam.MapParamEntry(name="chunk_size", type={"integer"}, description="The size of sentence-based chunks to use. Defaults to 300")}, description="Options to customize chunking behavior.", optional=true) Expression options) {
        super(source, options == null ? List.of(field) : List.of(field, options));
        this.field = field;
        this.options = options;
    }

    private Chunk(Source source, Expression field, Expression options, boolean unused) {
        super(source, options == null ? List.of(field) : List.of(field, options));
        this.field = field;
        this.options = options;
    }

    public Chunk(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeOptionalNamedWriteable((NamedWriteable)this.options);
    }

    public String getWriteableName() {
        return Chunk.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isString((Expression)this.field(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(Options.resolve(this.options, this.source(), TypeResolutions.ParamOrdinal.SECOND, ALLOWED_OPTIONS, this::verifyOptions));
    }

    private void verifyOptions(Map<String, Object> optionsMap) {
        if (this.options == null) {
            return;
        }
        Integer numChunks = (Integer)optionsMap.get(NUM_CHUNKS);
        if (numChunks != null && numChunks < 0) {
            throw new InvalidArgumentException("[{}] cannot be negative, found [{}]", new Object[]{NUM_CHUNKS, numChunks});
        }
        Integer chunkSize = (Integer)optionsMap.get(CHUNK_SIZE);
        if (chunkSize != null && chunkSize < 0) {
            throw new InvalidArgumentException("[{}] cannot be negative, found [{}]", new Object[]{CHUNK_SIZE, chunkSize});
        }
    }

    public boolean foldable() {
        return this.field().foldable() && (this.options() == null || this.options().foldable());
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Chunk(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Chunk::new, (Object)this.field, (Object)this.options);
    }

    Expression field() {
        return this.field;
    }

    Expression options() {
        return this.options;
    }

    static void process(BytesRefBlock.Builder builder, BytesRef str, int numChunks, int chunkSize) {
        boolean multivalued;
        SentenceBoundaryChunkingSettings settings;
        String content = str.utf8ToString();
        List<String> chunks = Chunk.chunkText(content, (ChunkingSettings)(settings = new SentenceBoundaryChunkingSettings(Integer.valueOf(chunkSize), Integer.valueOf(0))), numChunks);
        boolean bl = multivalued = chunks.size() > 1;
        if (multivalued) {
            builder.beginPositionEntry();
        }
        for (String chunk : chunks) {
            builder.appendBytesRef(new BytesRef((CharSequence)chunk.trim()));
        }
        if (multivalued) {
            builder.endPositionEntry();
        }
    }

    public static List<String> chunkText(String content, ChunkingSettings chunkingSettings, int numChunks) {
        Chunker chunker = ChunkerBuilder.fromChunkingStrategy((ChunkingStrategy)chunkingSettings.getChunkingStrategy());
        return chunker.chunk(content, chunkingSettings).stream().map(offset -> content.substring(offset.start(), offset.end())).limit(numChunks > 0 ? (long)numChunks : Integer.MAX_VALUE).toList();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chunk chunk = (Chunk)o;
        return Objects.equals(this.field(), chunk.field()) && Objects.equals(this.options(), chunk.options());
    }

    public int hashCode() {
        return Objects.hash(this.field(), this.options());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        HashMap<String, Object> optionsMap = new HashMap<String, Object>();
        if (this.options() != null) {
            Options.populateMap((MapExpression)this.options, optionsMap, this.source(), TypeResolutions.ParamOrdinal.SECOND, ALLOWED_OPTIONS);
        }
        int numChunks = optionsMap.getOrDefault(NUM_CHUNKS, Integer.MAX_VALUE);
        int chunkSize = (Integer)optionsMap.getOrDefault(CHUNK_SIZE, 300);
        return new ChunkBytesRefEvaluator.Factory(this.source(), toEvaluator.apply(this.field), toEvaluator.apply((Expression)new Literal(this.source(), (Object)numChunks, DataType.INTEGER)), toEvaluator.apply((Expression)new Literal(this.source(), (Object)chunkSize, DataType.INTEGER)));
    }
}

