/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopDoubleDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopDoubleFloatAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopDoubleIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopDoubleLongAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopFloatDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopFloatFloatAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopFloatIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopFloatLongAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopIntDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopIntFloatAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopIntIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopIntLongAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopIpAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopLongAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopLongDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopLongFloatAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopLongIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopLongLongAggregatorFunctionSupplier;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.TwoOptionalArguments;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Top
extends AggregateFunction
implements TwoOptionalArguments,
ToAggregator,
SurrogateExpression,
PostOptimizationVerificationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Top", Top::new);
    private static final String ORDER_ASC = "ASC";
    private static final String ORDER_DESC = "DESC";
    private static final Map<DataType, BiFunction<Integer, Boolean, AggregatorFunctionSupplier>> SUPPLIERS = Map.ofEntries(Map.entry(DataType.LONG, TopLongAggregatorFunctionSupplier::new), Map.entry(DataType.DATETIME, TopLongAggregatorFunctionSupplier::new), Map.entry(DataType.INTEGER, TopIntAggregatorFunctionSupplier::new), Map.entry(DataType.DOUBLE, TopDoubleAggregatorFunctionSupplier::new), Map.entry(DataType.BOOLEAN, TopBooleanAggregatorFunctionSupplier::new), Map.entry(DataType.IP, TopIpAggregatorFunctionSupplier::new), Map.entry(DataType.KEYWORD, TopBytesRefAggregatorFunctionSupplier::new), Map.entry(DataType.TEXT, TopBytesRefAggregatorFunctionSupplier::new));
    private static final Map<Tuple<DataType, DataType>, BiFunction<Integer, Boolean, AggregatorFunctionSupplier>> SUPPLIERS_WITH_EXTRA = Map.ofEntries(Map.entry(Tuple.tuple((Object)DataType.LONG, (Object)DataType.DATETIME), TopLongLongAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.LONG, (Object)DataType.INTEGER), TopLongIntAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.LONG, (Object)DataType.LONG), TopLongLongAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.LONG, (Object)DataType.FLOAT), TopLongFloatAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.LONG, (Object)DataType.DOUBLE), TopLongDoubleAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.DATETIME, (Object)DataType.DATETIME), TopLongLongAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.DATETIME, (Object)DataType.INTEGER), TopLongIntAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.DATETIME, (Object)DataType.LONG), TopLongLongAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.DATETIME, (Object)DataType.FLOAT), TopLongFloatAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.DATETIME, (Object)DataType.DOUBLE), TopLongDoubleAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.INTEGER, (Object)DataType.DATETIME), TopIntLongAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.INTEGER, (Object)DataType.INTEGER), TopIntIntAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.INTEGER, (Object)DataType.LONG), TopIntLongAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.INTEGER, (Object)DataType.FLOAT), TopIntFloatAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.INTEGER, (Object)DataType.DOUBLE), TopIntDoubleAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.FLOAT, (Object)DataType.DATETIME), TopFloatLongAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.FLOAT, (Object)DataType.INTEGER), TopFloatIntAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.FLOAT, (Object)DataType.LONG), TopFloatLongAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.FLOAT, (Object)DataType.FLOAT), TopFloatFloatAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.FLOAT, (Object)DataType.DOUBLE), TopFloatDoubleAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.DOUBLE, (Object)DataType.DATETIME), TopDoubleLongAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.DOUBLE, (Object)DataType.INTEGER), TopDoubleIntAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.DOUBLE, (Object)DataType.LONG), TopDoubleLongAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.DOUBLE, (Object)DataType.FLOAT), TopDoubleFloatAggregatorFunctionSupplier::new), Map.entry(Tuple.tuple((Object)DataType.DOUBLE, (Object)DataType.DOUBLE), TopDoubleDoubleAggregatorFunctionSupplier::new));

    @FunctionInfo(returnType={"boolean", "double", "integer", "long", "date", "ip", "keyword"}, description="Collects the top values for a field. Includes repeated values.", type=FunctionType.AGGREGATE, examples={@Example(file="stats_top", tag="top")})
    public Top(Source source, @Param(name="field", type={"boolean", "double", "integer", "long", "date", "ip", "keyword", "text"}, description="The field to collect the top values for.") Expression field, @Param(name="limit", type={"integer"}, description="The maximum number of values to collect.") Expression limit, @Param(optional=true, name="order", type={"keyword"}, description="The order to calculate the top values. Either `asc` or `desc`, and defaults to `asc` if omitted.") Expression order, @Param(optional=true, name="outputField", type={"double", "integer", "long", "date"}, description="The extra field that, if present, will be the output of the TOP call instead of `field`.{applies_to}`stack: ga 9.3`") Expression outputField) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW, limit, (Expression)(order == null ? Literal.keyword((Source)source, (String)ORDER_ASC) : order), outputField);
    }

    public Top(Source source, Expression field, Expression filter, Expression window, Expression limit, Expression order, @Nullable Expression outputField) {
        super(source, field, filter, window, outputField != null ? Arrays.asList(limit, order, outputField) : Arrays.asList(limit, order));
    }

    private Top(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public Top withFilter(Expression filter) {
        return new Top(this.source(), this.field(), filter, this.window(), this.limitField(), this.orderField(), this.outputField());
    }

    public String getWriteableName() {
        return Top.ENTRY.name;
    }

    Expression limitField() {
        return this.parameters().get(0);
    }

    Expression orderField() {
        return this.parameters().get(1);
    }

    @Nullable
    Expression outputField() {
        return this.parameters().size() > 2 ? this.parameters().get(2) : null;
    }

    private Integer limitValue() {
        return Foldables.limitValue(this.limitField(), this.sourceText());
    }

    private boolean orderValue() {
        Literal literal;
        String order;
        Expression expression = this.orderField();
        if (expression instanceof Literal && (ORDER_ASC.equalsIgnoreCase(order = BytesRefs.toString((Object)(literal = (Literal)expression).value())) || ORDER_DESC.equalsIgnoreCase(order))) {
            return order.equalsIgnoreCase(ORDER_ASC);
        }
        throw new EsqlIllegalArgumentException("Order value must be a literal, found: " + String.valueOf(this.orderField()));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution typeResolution = TypeResolutions.isType((Expression)this.field(), dt -> dt == DataType.BOOLEAN || dt == DataType.DATETIME || dt == DataType.IP || DataType.isString((DataType)dt) || dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"boolean", "date", "ip", "string", "numeric except unsigned_long or counter types"}).and(TypeResolutions.isNotNull((Expression)this.limitField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND)).and(TypeResolutions.isType((Expression)this.limitField(), dt -> dt == DataType.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"integer"})).and(TypeResolutions.isNotNull((Expression)this.orderField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD)).and(TypeResolutions.isString((Expression)this.orderField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD));
        if (this.outputField() != null) {
            typeResolution = typeResolution.and(TypeResolutions.isType((Expression)this.outputField(), dt -> dt == DataType.DATETIME || dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FOURTH, (String[])new String[]{"date", "numeric except unsigned_long or counter types"})).and(TypeResolutions.isType((Expression)this.field(), dt -> dt == DataType.DATETIME || dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)"when fourth argument is set, ", (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (boolean)false, (String[])new String[]{"date", "numeric except unsigned_long or counter types"}));
        }
        if (typeResolution.unresolved()) {
            return typeResolution;
        }
        Expression.TypeResolution result = this.resolveTypeLimit();
        if (!result.equals(Expression.TypeResolution.TYPE_RESOLVED)) {
            return result;
        }
        result = this.resolveTypeOrder(Foldables.TypeResolutionValidator.forPreOptimizationValidation(this.orderField()));
        if (!result.equals(Expression.TypeResolution.TYPE_RESOLVED)) {
            return result;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    private Expression.TypeResolution resolveTypeLimit() {
        return Foldables.resolveTypeLimit(this.limitField(), this.sourceText(), Foldables.TypeResolutionValidator.forPreOptimizationValidation(this.limitField()));
    }

    private Expression.TypeResolution resolveTypeOrder(Foldables.TypeResolutionValidator validator) {
        Expression order = this.orderField();
        if (order == null) {
            validator.invalid(new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Order must be a valid string in [{}], found [{}]", (Object[])new Object[]{this.sourceText(), order})));
        } else if (order instanceof Literal) {
            Literal literal = (Literal)order;
            if (literal.value() == null) {
                validator.invalid(new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Invalid order value in [{}], expected [{}, {}] but got [{}]", (Object[])new Object[]{this.sourceText(), ORDER_ASC, ORDER_DESC, order})));
            } else {
                String value = BytesRefs.toString((Object)literal.value());
                if (value == null || !value.equalsIgnoreCase(ORDER_ASC) && !value.equalsIgnoreCase(ORDER_DESC)) {
                    validator.invalid(new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Invalid order value in [{}], expected [{}, {}] but got [{}]", (Object[])new Object[]{this.sourceText(), ORDER_ASC, ORDER_DESC, order})));
                }
            }
        } else {
            validator.invalidIfPostValidation(Failure.fail(order, "Order must be a valid string in [{}], found [{}]", new Object[]{this.sourceText(), order}));
        }
        return validator.getResolvedType();
    }

    @Override
    public void postOptimizationVerification(Failures failures) {
        this.postOptimizationVerificationLimit(failures);
        this.postOptimizationVerificationOrder(failures);
    }

    private void postOptimizationVerificationLimit(Failures failures) {
        Foldables.resolveTypeLimit(this.limitField(), this.sourceText(), Foldables.TypeResolutionValidator.forPostOptimizationValidation(this.limitField(), failures));
    }

    private void postOptimizationVerificationOrder(Failures failures) {
        this.resolveTypeOrder(Foldables.TypeResolutionValidator.forPostOptimizationValidation(this.orderField(), failures));
    }

    public DataType dataType() {
        return this.outputField() == null ? this.field().dataType().noText() : this.outputField().dataType().noText();
    }

    protected NodeInfo<Top> info() {
        return NodeInfo.create((Node)this, Top::new, (Object)this.field(), (Object)this.filter(), (Object)this.window(), (Object)this.limitField(), (Object)this.orderField(), (Object)this.outputField());
    }

    public Top replaceChildren(List<Expression> newChildren) {
        return new Top(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3), newChildren.get(4), newChildren.size() > 5 ? newChildren.get(5) : null);
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        BiFunction<Integer, Boolean, AggregatorFunctionSupplier> supplierCtor;
        DataType fieldType = this.field().dataType();
        if (this.outputField() == null) {
            supplierCtor = SUPPLIERS.get(fieldType);
            if (supplierCtor == null) {
                throw EsqlIllegalArgumentException.illegalDataType(fieldType);
            }
        } else {
            DataType outputFieldType = this.outputField().dataType();
            supplierCtor = SUPPLIERS_WITH_EXTRA.get(Tuple.tuple((Object)fieldType, (Object)outputFieldType));
            if (supplierCtor == null) {
                throw EsqlIllegalArgumentException.illegalDataTypeCombination(fieldType, outputFieldType);
            }
        }
        return supplierCtor.apply(this.limitValue(), this.orderValue());
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        if (this.outputField() != null && this.field().semanticEquals(this.outputField())) {
            return new Top(s, this.field(), this.limitField(), this.orderField(), null);
        }
        if (this.orderField() instanceof Literal && this.limitField() instanceof Literal && this.limitValue() == 1) {
            if (this.orderValue()) {
                return new Min(s, this.field(), this.filter(), this.window());
            }
            return new Max(s, this.field(), this.filter(), this.window());
        }
        return null;
    }
}

