/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.InvertableType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.LowercaseNormalizer;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedBinaryIndexFieldData;
import org.elasticsearch.index.fielddata.StoredFieldSortedBinaryIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.BlockStoredFieldsReader;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FallbackSyntheticSourceBlockLoader;
import org.elasticsearch.index.mapper.FieldArrayContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.SearchAfterTermsEnum;
import org.elasticsearch.index.mapper.SortedSetDocValuesSyntheticFieldLoaderLayer;
import org.elasticsearch.index.mapper.SortedSetDocValuesTerms;
import org.elasticsearch.index.mapper.SortedSetWithOffsetsDocValuesSyntheticFieldLoaderLayer;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextFamilyFieldType;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.blockloader.BlockLoaderFunctionConfig;
import org.elasticsearch.index.mapper.blockloader.docvalues.BytesRefsFromOrdsBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.fn.Utf8CodePointsFromOrdsBlockLoader;
import org.elasticsearch.index.query.AutomatonQueryWithDescription;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.SortedSetDocValuesStringFieldScript;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.script.field.KeywordDocValuesField;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.search.runtime.StringScriptFieldPrefixQuery;
import org.elasticsearch.search.runtime.StringScriptFieldTermQuery;
import org.elasticsearch.search.runtime.StringScriptFieldWildcardQuery;
import org.elasticsearch.xcontent.Text;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentString;

public final class KeywordFieldMapper
extends FieldMapper {
    private static final Logger logger = LogManager.getLogger(KeywordFieldMapper.class);
    public static final String CONTENT_TYPE = "keyword";
    private static final String HOST_NAME = "host.name";
    public static final FieldMapper.TypeParser PARSER = KeywordFieldMapper.createTypeParserWithLegacySupport(Builder::new);
    private final boolean indexed;
    private final boolean hasDocValues;
    private final String indexOptions;
    private final FieldType fieldType;
    private final String normalizerName;
    private final boolean normalizerSkipStoreOriginalValue;
    private final boolean splitQueriesOnWhitespace;
    private final Script script;
    private final ScriptCompiler scriptCompiler;
    private final IndexAnalyzers indexAnalyzers;
    private final IndexSettings indexSettings;
    private final boolean forceDocValuesSkipper;
    private final String offsetsFieldName;

    private static TextSearchInfo textSearchInfo(FieldType fieldType, @Nullable SimilarityProvider similarity, NamedAnalyzer searchAnalyzer, NamedAnalyzer searchQuoteAnalyzer) {
        TextSearchInfo textSearchInfo = new TextSearchInfo(fieldType, similarity, searchAnalyzer, searchQuoteAnalyzer);
        if (textSearchInfo.equals(Defaults.TEXT_SEARCH_INFO)) {
            return Defaults.TEXT_SEARCH_INFO;
        }
        return textSearchInfo;
    }

    private static KeywordFieldMapper toType(FieldMapper in) {
        return (KeywordFieldMapper)in;
    }

    private KeywordFieldMapper(String simpleName, FieldType fieldType, KeywordFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Builder builder, String offsetsFieldName) {
        super(simpleName, mappedFieldType, builderParams);
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.indexOptions = builder.indexOptions.getValue();
        this.fieldType = KeywordFieldMapper.freezeAndDeduplicateFieldType(fieldType);
        this.normalizerName = builder.normalizer.getValue();
        this.normalizerSkipStoreOriginalValue = builder.normalizerSkipStoreOriginalValue.getValue();
        this.splitQueriesOnWhitespace = builder.splitQueriesOnWhitespace.getValue();
        this.script = builder.script.get();
        this.indexAnalyzers = builder.indexAnalyzers;
        this.scriptCompiler = builder.scriptCompiler;
        this.indexSettings = builder.indexSettings;
        this.forceDocValuesSkipper = builder.forceDocValuesSkipper;
        this.offsetsFieldName = offsetsFieldName;
    }

    @Override
    public KeywordFieldType fieldType() {
        return (KeywordFieldType)super.fieldType();
    }

    @Override
    public String getOffsetFieldName() {
        return this.offsetsFieldName;
    }

    public boolean isNormalizerSkipStoreOriginalValue() {
        return this.normalizerSkipStoreOriginalValue;
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentString value = context.parser().optimizedTextOrNull();
        if (value == null && this.fieldType().nullValue != null) {
            value = new Text(this.fieldType().nullValue);
        }
        boolean indexed = this.indexValue(context, value);
        if (this.offsetsFieldName != null && context.isImmediateParentAnArray() && context.canAddIgnoredField()) {
            if (indexed) {
                context.getOffSetContext().recordOffset(this.offsetsFieldName, (Comparable<?>)value.bytes());
            } else if (value == null) {
                context.getOffSetContext().recordNull(this.offsetsFieldName);
            }
        }
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.fieldType().scriptValues.valuesForDoc(searchLookup, readerContext, doc, value -> this.indexValue(documentParserContext, (String)value));
    }

    private boolean indexValue(DocumentParserContext context, String value) {
        return this.indexValue(context, (XContentString)new Text(value));
    }

    private boolean storeIgnoredValuesForSyntheticSource() {
        return this.fieldType().isSyntheticSourceEnabled() && !this.fieldType().isWithinMultiField();
    }

    private boolean indexValue(DocumentParserContext context, XContentString value) {
        if (value == null) {
            return false;
        }
        if (this.fieldType.indexOptions() == IndexOptions.NONE && !this.fieldType.stored() && !this.fieldType().hasDocValues()) {
            return false;
        }
        if (this.fieldType().ignoreAbove().isIgnored(value)) {
            context.addIgnoredField(this.fullPath());
            if (this.storeIgnoredValuesForSyntheticSource()) {
                XContentString.UTF8Bytes utfBytes = value.bytes();
                BytesRef bytesRef = new BytesRef(utfBytes.bytes(), utfBytes.offset(), utfBytes.length());
                String fieldName = this.fieldType().syntheticSourceFallbackFieldName();
                context.doc().add((IndexableField)new StoredField(fieldName, bytesRef));
            }
            return false;
        }
        if (this.fieldType().normalizer() != Lucene.KEYWORD_ANALYZER) {
            String normalizedString = KeywordFieldMapper.normalizeValue(this.fieldType().normalizer(), this.fullPath(), value.string());
            value = new Text(normalizedString);
        }
        XContentString.UTF8Bytes utfBytes = value.bytes();
        BytesRef binaryValue = new BytesRef(utfBytes.bytes(), utfBytes.offset(), utfBytes.length());
        if (this.fieldType().isDimension()) {
            context.getRoutingFields().addString(this.fieldType().name(), binaryValue);
        }
        if (binaryValue.length > 32766) {
            byte[] prefix = new byte[30];
            System.arraycopy(binaryValue.bytes, binaryValue.offset, prefix, 0, 30);
            String msg = "Document contains at least one immense term in field=\"" + this.fieldType().name() + "\" (whose UTF8 encoding is longer than the max length 32766), all of which were skipped. Please correct the analyzer to not produce such terms. The prefix of the first immense term is: '" + Arrays.toString(prefix) + "...'";
            throw new IllegalArgumentException(msg);
        }
        Field field = this.buildKeywordField(binaryValue);
        context.doc().add((IndexableField)field);
        if (!this.fieldType().hasDocValues() && this.fieldType.omitNorms()) {
            context.addToFieldNames(this.fieldType().name());
        }
        return true;
    }

    private static String normalizeValue(NamedAnalyzer normalizer, String field, String value) {
        String string;
        block11: {
            if (normalizer == Lucene.KEYWORD_ANALYZER) {
                return value;
            }
            TokenStream ts = normalizer.tokenStream(field, value);
            try {
                CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
                ts.reset();
                if (!ts.incrementToken()) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "The normalization token stream is expected to produce exactly 1 token, but got 0 for analyzer %s and input \"%s\"\n", new Object[]{normalizer, value}));
                }
                String newValue = termAtt.toString();
                if (ts.incrementToken()) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "The normalization token stream is expected to produce exactly 1 token, but got 2+ for analyzer %s and input \"%s\"\n", new Object[]{normalizer, value}));
                }
                ts.end();
                string = newValue;
                if (ts == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (ts != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ts.close();
        }
        return string;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), this.fieldType().normalizer);
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexAnalyzers, this.scriptCompiler, this.indexSettings, this.forceDocValuesSkipper, this.fieldType().isWithinMultiField()).dimension(this.fieldType().isDimension()).init(this);
    }

    public Field buildKeywordField(BytesRef binaryValue) {
        return new KeywordField(this.fieldType().name(), binaryValue, this.fieldType);
    }

    @Override
    public void doValidate(MappingLookup lookup) {
        if (this.fieldType().isDimension() && null != lookup.nestedLookup().getNestedParent(this.fullPath())) {
            throw new IllegalArgumentException("time_series_dimension can't be configured in nested field [" + this.fullPath() + "]");
        }
    }

    boolean hasNormalizer() {
        return this.normalizerName != null;
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.hasNormalizer() && !this.normalizerSkipStoreOriginalValue) {
            return FieldMapper.SyntheticSourceSupport.FALLBACK;
        }
        if (this.fieldType.stored() || this.hasDocValues) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> this.syntheticFieldLoader(this.fullPath(), this.leafName()));
        }
        return super.syntheticSourceSupport();
    }

    public CompositeSyntheticFieldLoader syntheticFieldLoader(String fullFieldName, String leafFieldName) {
        assert (this.fieldType.stored() || this.hasDocValues);
        ArrayList<CompositeSyntheticFieldLoader.Layer> layers = new ArrayList<CompositeSyntheticFieldLoader.Layer>(2);
        if (this.fieldType.stored()) {
            layers.add(new CompositeSyntheticFieldLoader.StoredFieldLayer(this, this.fullPath()){

                @Override
                protected void writeValue(Object value, XContentBuilder b) throws IOException {
                    BytesRef ref = (BytesRef)value;
                    b.utf8Value(ref.bytes, ref.offset, ref.length);
                }
            });
        } else if (this.hasDocValues) {
            if (this.offsetsFieldName != null) {
                layers.add(new SortedSetWithOffsetsDocValuesSyntheticFieldLoaderLayer(this.fullPath(), this.offsetsFieldName));
            } else {
                layers.add(new SortedSetDocValuesSyntheticFieldLoaderLayer(this, this.fullPath()){

                    @Override
                    protected BytesRef convert(BytesRef value) {
                        return value;
                    }

                    @Override
                    protected BytesRef preserve(BytesRef value) {
                        return BytesRef.deepCopyOf((BytesRef)value);
                    }
                });
            }
        }
        if (this.fieldType().ignoreAbove.valuesPotentiallyIgnored()) {
            String fieldName = this.fieldType().syntheticSourceFallbackFieldName();
            layers.add(new CompositeSyntheticFieldLoader.StoredFieldLayer(this, fieldName){

                @Override
                protected void writeValue(Object value, XContentBuilder b) throws IOException {
                    BytesRef ref = (BytesRef)value;
                    b.utf8Value(ref.bytes, ref.offset, ref.length);
                }
            });
        }
        return new CompositeSyntheticFieldLoader(leafFieldName, fullFieldName, layers);
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE;
        public static final FieldType FIELD_TYPE_WITH_SKIP_DOC_VALUES;
        public static final TextSearchInfo TEXT_SEARCH_INFO;

        static {
            FieldType ft = new FieldType();
            ft.setTokenized(false);
            ft.setOmitNorms(true);
            ft.setIndexOptions(IndexOptions.DOCS);
            ft.setDocValuesType(DocValuesType.SORTED_SET);
            FIELD_TYPE = Mapper.freezeAndDeduplicateFieldType(ft);
            ft = new FieldType();
            ft.setTokenized(false);
            ft.setOmitNorms(true);
            ft.setIndexOptions(IndexOptions.NONE);
            ft.setDocValuesType(DocValuesType.SORTED_SET);
            ft.setDocValuesSkipIndexType(DocValuesSkipIndexType.RANGE);
            FIELD_TYPE_WITH_SKIP_DOC_VALUES = Mapper.freezeAndDeduplicateFieldType(ft);
            TEXT_SEARCH_INFO = new TextSearchInfo(FIELD_TYPE, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        }
    }

    public static final class Builder
    extends FieldMapper.DimensionBuilder {
        private final FieldMapper.Parameter<Boolean> indexed;
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> KeywordFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> KeywordFieldMapper.toType((FieldMapper)m).fieldType.stored(), false);
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> KeywordFieldMapper.toType((FieldMapper)m).fieldType().nullValue, null).acceptsNull();
        private final FieldMapper.Parameter<Boolean> eagerGlobalOrdinals = FieldMapper.Parameter.boolParam("eager_global_ordinals", true, m -> KeywordFieldMapper.toType(m).fieldType().eagerGlobalOrdinals(), false);
        private final FieldMapper.Parameter<Integer> ignoreAbove;
        private final FieldMapper.Parameter<String> indexOptions = TextParams.keywordIndexOptions(m -> KeywordFieldMapper.toType((FieldMapper)m).indexOptions);
        private final FieldMapper.Parameter<Boolean> hasNorms = FieldMapper.Parameter.normsParam(m -> !KeywordFieldMapper.toType((FieldMapper)m).fieldType.omitNorms(), false);
        private final FieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> KeywordFieldMapper.toType(m).fieldType().getTextSearchInfo().similarity());
        private final FieldMapper.Parameter<String> normalizer;
        private final FieldMapper.Parameter<Boolean> normalizerSkipStoreOriginalValue;
        private final FieldMapper.Parameter<Boolean> splitQueriesOnWhitespace = FieldMapper.Parameter.boolParam("split_queries_on_whitespace", true, m -> KeywordFieldMapper.toType((FieldMapper)m).splitQueriesOnWhitespace, false);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> KeywordFieldMapper.toType((FieldMapper)m).script);
        private final FieldMapper.Parameter<OnScriptError> onScriptError = FieldMapper.Parameter.onScriptErrorParam(m -> KeywordFieldMapper.toType((FieldMapper)m).builderParams.onScriptError(), this.script);
        private final FieldMapper.Parameter<Boolean> dimension;
        private final IndexAnalyzers indexAnalyzers;
        private final ScriptCompiler scriptCompiler;
        private final IndexVersion indexCreatedVersion;
        private final boolean forceDocValuesSkipper;
        private final boolean isWithinMultiField;
        private final IndexSettings indexSettings;

        public Builder(String name, MappingParserContext mappingParserContext) {
            this(name, mappingParserContext.getIndexAnalyzers(), mappingParserContext.scriptCompiler(), mappingParserContext.getIndexSettings(), false, mappingParserContext.isWithinMultiField());
        }

        public Builder(String name, IndexAnalyzers indexAnalyzers, ScriptCompiler scriptCompiler, IndexSettings indexSettings, boolean forceDocValuesSkipper, boolean isWithinMultiField) {
            super(name);
            this.indexAnalyzers = indexAnalyzers;
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.indexCreatedVersion = indexSettings.getIndexVersionCreated();
            this.normalizer = FieldMapper.Parameter.stringParam("normalizer", this.indexCreatedVersion.isLegacyIndexVersion(), m -> KeywordFieldMapper.toType((FieldMapper)m).normalizerName, null).acceptsNull();
            this.normalizerSkipStoreOriginalValue = FieldMapper.Parameter.boolParam("normalizer_skip_store_original_value", false, m -> ((KeywordFieldMapper)m).isNormalizerSkipStoreOriginalValue(), () -> "lowercase".equals(this.normalizer.getValue()) && indexAnalyzers.getNormalizer(this.normalizer.getValue()).analyzer() instanceof LowercaseNormalizer);
            this.script.precludesParameters(this.nullValue);
            this.dimension = TimeSeriesParams.dimensionParam(m -> KeywordFieldMapper.toType(m).fieldType().isDimension(), this.hasDocValues::get).precludesParameters(this.normalizer);
            this.indexed = FieldMapper.Parameter.indexParam(m -> KeywordFieldMapper.toType((FieldMapper)m).indexed, indexSettings, this.dimension);
            this.addScriptValidation(this.script, this.indexed, this.hasDocValues);
            this.ignoreAbove = FieldMapper.Parameter.ignoreAboveParam(m -> KeywordFieldMapper.toType(m).fieldType().ignoreAbove().get(), IndexSettings.IGNORE_ABOVE_SETTING.get(indexSettings.getSettings()));
            this.forceDocValuesSkipper = forceDocValuesSkipper;
            this.isWithinMultiField = isWithinMultiField;
            this.indexSettings = indexSettings;
        }

        public Builder(String name, IndexSettings indexSettings) {
            this(name, null, ScriptCompiler.NONE, indexSettings, false, false);
        }

        public Builder(String name, IndexSettings indexSettings, boolean isWithinMultiField) {
            this(name, null, ScriptCompiler.NONE, indexSettings, false, isWithinMultiField);
        }

        public static Builder buildWithDocValuesSkipper(String name, IndexSettings indexSettings, boolean isWithinMultiField) {
            return new Builder(name, null, ScriptCompiler.NONE, indexSettings, true, isWithinMultiField);
        }

        public Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove.setValue(ignoreAbove);
            return this;
        }

        Builder normalizer(String normalizerName) {
            this.normalizer.setValue(normalizerName);
            return this;
        }

        public boolean hasNormalizer() {
            return this.normalizer.get() != null;
        }

        public boolean isNormalizerSkipStoreOriginalValue() {
            return this.normalizerSkipStoreOriginalValue.getValue();
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        public boolean hasDocValues() {
            return this.hasDocValues.get();
        }

        public SimilarityProvider similarity() {
            return this.similarity.get();
        }

        public Builder dimension(boolean dimension) {
            this.dimension.setValue(dimension);
            return this;
        }

        public Builder indexed(boolean indexed) {
            this.indexed.setValue(indexed);
            return this;
        }

        public Builder stored(boolean stored) {
            this.stored.setValue(stored);
            return this;
        }

        public boolean isStored() {
            return this.stored.get();
        }

        private FieldValues<String> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            StringFieldScript.Factory scriptFactory = this.scriptCompiler.compile(this.script.get(), StringFieldScript.CONTEXT);
            return scriptFactory == null ? null : (lookup, ctx, doc, consumer) -> scriptFactory.newFactory(this.leafName(), this.script.get().getParams(), lookup, OnScriptError.FAIL).newInstance(ctx).runForDoc(doc, consumer);
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.hasDocValues, this.stored, this.nullValue, this.eagerGlobalOrdinals, this.ignoreAbove, this.indexOptions, this.hasNorms, this.similarity, this.normalizer, this.normalizerSkipStoreOriginalValue, this.splitQueriesOnWhitespace, this.script, this.onScriptError, this.meta, this.dimension};
        }

        private KeywordFieldType buildFieldType(MapperBuilderContext context, FieldType fieldType) {
            NamedAnalyzer normalizer = Lucene.KEYWORD_ANALYZER;
            NamedAnalyzer searchAnalyzer = Lucene.KEYWORD_ANALYZER;
            NamedAnalyzer quoteAnalyzer = Lucene.KEYWORD_ANALYZER;
            String normalizerName = this.normalizer.getValue();
            if (normalizerName != null) {
                assert (this.indexAnalyzers != null);
                normalizer = this.indexAnalyzers.getNormalizer(normalizerName);
                if (normalizer == null) {
                    if (this.indexCreatedVersion.isLegacyIndexVersion()) {
                        logger.warn(() -> Strings.format((String)"Could not find normalizer [%s] of legacy index, falling back to default", (Object[])new Object[]{normalizerName}));
                        normalizer = Lucene.KEYWORD_ANALYZER;
                    } else {
                        throw new MapperParsingException("normalizer [" + normalizerName + "] not found for field [" + this.leafName() + "]");
                    }
                }
                searchAnalyzer = quoteAnalyzer = normalizer;
                if (this.splitQueriesOnWhitespace.getValue().booleanValue()) {
                    searchAnalyzer = this.indexAnalyzers.getWhitespaceNormalizer(normalizerName);
                }
            } else if (this.splitQueriesOnWhitespace.getValue().booleanValue()) {
                searchAnalyzer = Lucene.WHITESPACE_ANALYZER;
            }
            if (this.inheritDimensionParameterFromParentObject(context)) {
                this.dimension(true);
            }
            return new KeywordFieldType(context.buildFullName(this.leafName()), IndexType.terms(fieldType), new TextSearchInfo(fieldType, this.similarity.get(), searchAnalyzer, quoteAnalyzer), normalizer, this, context.isSourceSynthetic());
        }

        @Override
        public KeywordFieldMapper build(MapperBuilderContext context) {
            FieldType fieldtype = this.resolveFieldType(this.forceDocValuesSkipper, context.buildFullName(this.leafName()));
            this.hasScript = this.script.get() != null;
            ((FieldMapper.DimensionBuilder)this).onScriptError = this.onScriptError.getValue();
            String offsetsFieldName = FieldArrayContext.getOffsetsFieldName(context, this.indexSettings.sourceKeepMode(), this.hasDocValues.getValue(), this.stored.getValue(), this, this.indexCreatedVersion, IndexVersions.SYNTHETIC_SOURCE_STORE_ARRAYS_NATIVELY_KEYWORD);
            return new KeywordFieldMapper(this.leafName(), fieldtype, this.buildFieldType(context, fieldtype), this.builderParams(this, context), this, offsetsFieldName);
        }

        private FieldType resolveFieldType(boolean forceDocValuesSkipper, String fullFieldName) {
            FieldType fieldtype = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE);
            if (forceDocValuesSkipper || this.shouldUseHostnameSkipper(fullFieldName) || this.shouldUseTimeSeriesSkipper()) {
                fieldtype = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE_WITH_SKIP_DOC_VALUES);
            }
            fieldtype.setOmitNorms(this.hasNorms.getValue() == false);
            fieldtype.setStored(this.stored.getValue().booleanValue());
            fieldtype.setDocValuesType(this.hasDocValues.getValue() != false ? DocValuesType.SORTED_SET : DocValuesType.NONE);
            if (!fieldtype.equals((Object)Defaults.FIELD_TYPE_WITH_SKIP_DOC_VALUES)) {
                fieldtype.setIndexOptions(TextParams.toIndexOptions(this.indexed.getValue(), this.indexOptions.getValue()));
            }
            if (fieldtype.equals((Object)Defaults.FIELD_TYPE)) {
                fieldtype = Defaults.FIELD_TYPE;
            }
            if (fieldtype.equals((Object)Defaults.FIELD_TYPE_WITH_SKIP_DOC_VALUES)) {
                fieldtype = Defaults.FIELD_TYPE_WITH_SKIP_DOC_VALUES;
            }
            return fieldtype;
        }

        private boolean shouldUseTimeSeriesSkipper() {
            return this.hasDocValues.get() != false && this.indexed.get() == false && FieldMapper.Parameter.useTimeSeriesDocValuesSkippers(this.indexSettings, this.dimension.get());
        }

        private boolean shouldUseHostnameSkipper(String fullFieldName) {
            return this.hasDocValues.get() != false && this.indexSettings.useDocValuesSkipper() && this.indexSettings.getIndexVersionCreated().onOrAfter(IndexVersions.SKIPPERS_ENABLED_BY_DEFAULT) && IndexMode.LOGSDB.equals((Object)this.indexSettings.getMode()) && KeywordFieldMapper.HOST_NAME.equals(fullFieldName) && Builder.indexSortConfigByHostName(this.indexSettings.getIndexSortConfig());
        }

        private static boolean indexSortConfigByHostName(IndexSortConfig indexSortConfig) {
            return indexSortConfig != null && indexSortConfig.hasIndexSort() && indexSortConfig.hasSortOnField(KeywordFieldMapper.HOST_NAME);
        }
    }

    public static final class KeywordFieldType
    extends TextFamilyFieldType {
        private static final Mapper.IgnoreAbove IGNORE_ABOVE_DEFAULT = new Mapper.IgnoreAbove(null, IndexMode.STANDARD);
        private final Mapper.IgnoreAbove ignoreAbove;
        private final String nullValue;
        private final NamedAnalyzer normalizer;
        private final boolean eagerGlobalOrdinals;
        private final FieldValues<String> scriptValues;
        private final boolean isDimension;

        public KeywordFieldType(String name, IndexType indexType, TextSearchInfo textSearchInfo, NamedAnalyzer normalizer, Builder builder, boolean isSyntheticSource) {
            super(name, indexType, builder.stored.get(), textSearchInfo, builder.meta.getValue(), isSyntheticSource, builder.isWithinMultiField);
            this.eagerGlobalOrdinals = builder.eagerGlobalOrdinals.getValue();
            this.normalizer = normalizer;
            this.ignoreAbove = new Mapper.IgnoreAbove(builder.ignoreAbove.getValue(), builder.indexSettings.getMode(), builder.indexSettings.getIndexVersionCreated());
            this.nullValue = builder.nullValue.getValue();
            this.scriptValues = builder.scriptValues();
            this.isDimension = builder.dimension.getValue();
        }

        public KeywordFieldType(String name) {
            this(name, true, true, Collections.emptyMap());
        }

        public KeywordFieldType(String name, boolean isIndexed, boolean hasDocValues, Map<String, String> meta) {
            super(name, IndexType.terms(isIndexed, hasDocValues), false, TextSearchInfo.SIMPLE_MATCH_ONLY, meta, false, false);
            this.normalizer = Lucene.KEYWORD_ANALYZER;
            this.ignoreAbove = IGNORE_ABOVE_DEFAULT;
            this.nullValue = null;
            this.eagerGlobalOrdinals = false;
            this.scriptValues = null;
            this.isDimension = false;
        }

        public KeywordFieldType(String name, FieldType fieldType, boolean isSyntheticSource) {
            super(name, IndexType.terms(fieldType), fieldType.stored(), KeywordFieldMapper.textSearchInfo(fieldType, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), Collections.emptyMap(), isSyntheticSource, false);
            this.normalizer = Lucene.KEYWORD_ANALYZER;
            this.ignoreAbove = IGNORE_ABOVE_DEFAULT;
            this.nullValue = null;
            this.eagerGlobalOrdinals = false;
            this.scriptValues = null;
            this.isDimension = false;
        }

        public KeywordFieldType(String name, NamedAnalyzer analyzer) {
            super(name, IndexType.terms(true, true), false, KeywordFieldMapper.textSearchInfo(Defaults.FIELD_TYPE, null, analyzer, analyzer), Collections.emptyMap(), false, false);
            this.normalizer = Lucene.KEYWORD_ANALYZER;
            this.ignoreAbove = IGNORE_ABOVE_DEFAULT;
            this.nullValue = null;
            this.eagerGlobalOrdinals = false;
            this.scriptValues = null;
            this.isDimension = false;
        }

        @Override
        public boolean isSearchable() {
            return this.indexType.hasTerms() || this.hasDocValues();
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.indexType.hasTerms()) {
                return super.termQuery(value, context);
            }
            return SortedSetDocValuesField.newSlowExactQuery((String)this.name(), (BytesRef)this.indexedValueForSearch(value));
        }

        @Override
        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.indexType.hasTerms()) {
                return super.termsQuery(values, context);
            }
            List<BytesRef> bytesRefs = values.stream().map(this::indexedValueForSearch).toList();
            return SortedSetDocValuesField.newSlowSetQuery((String)this.name(), bytesRefs);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.indexType.hasTerms()) {
                return super.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, context);
            }
            return SortedSetDocValuesField.newSlowRangeQuery((String)this.name(), (BytesRef)(lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm)), (BytesRef)(upperTerm == null ? null : this.indexedValueForSearch(upperTerm)), (boolean)includeLower, (boolean)includeUpper);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.indexType.hasTerms()) {
                return super.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, context, rewriteMethod);
            }
            return new FuzzyQuery(new Term(this.name(), this.indexedValueForSearch(value)), fuzziness.asDistance(BytesRefs.toString(value)), prefixLength, maxExpansions, transpositions, MultiTermQuery.DOC_VALUES_REWRITE);
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.indexType.hasTerms()) {
                return super.prefixQuery(value, method, caseInsensitive, context);
            }
            if (!caseInsensitive) {
                Term prefix = new Term(this.name(), this.indexedValueForSearch(value));
                return new PrefixQuery(prefix, MultiTermQuery.DOC_VALUES_REWRITE);
            }
            return new StringScriptFieldPrefixQuery(new Script(""), ctx -> new SortedSetDocValuesStringFieldScript(this.name(), context.lookup(), ctx), this.name(), this.indexedValueForSearch(value).utf8ToString(), caseInsensitive);
        }

        @Override
        public Query termQueryCaseInsensitive(Object value, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.indexType.hasTerms()) {
                return super.termQueryCaseInsensitive(value, context);
            }
            return new StringScriptFieldTermQuery(new Script(""), ctx -> new SortedSetDocValuesStringFieldScript(this.name(), context.lookup(), ctx), this.name(), this.indexedValueForSearch(value).utf8ToString(), true);
        }

        @Override
        public TermsEnum getTerms(IndexReader reader, String prefix, boolean caseInsensitive, String searchAfter) throws IOException {
            BytesRef searchBytes;
            Automaton a;
            Terms terms = null;
            if (this.indexType.hasTerms()) {
                terms = MultiTerms.getTerms((IndexReader)reader, (String)this.name());
            } else if (this.hasDocValues()) {
                terms = SortedSetDocValuesTerms.getTerms(reader, this.name());
            }
            if (terms == null) {
                return null;
            }
            Automaton automaton = a = caseInsensitive ? AutomatonQueries.caseInsensitivePrefix(prefix) : Operations.concatenate((Automaton)Automata.makeString((String)prefix), (Automaton)Automata.makeAnyString());
            assert (a.isDeterministic());
            CompiledAutomaton automaton2 = new CompiledAutomaton(a, true, true);
            BytesRef bytesRef = searchBytes = searchAfter == null ? null : new BytesRef((CharSequence)searchAfter);
            if (automaton2.type == CompiledAutomaton.AUTOMATON_TYPE.ALL) {
                Object result = terms.iterator();
                if (searchAfter != null) {
                    result = new SearchAfterTermsEnum((TermsEnum)result, searchBytes);
                }
                return result;
            }
            return terms.intersect(automaton2, searchBytes);
        }

        @Override
        public String typeName() {
            return KeywordFieldMapper.CONTENT_TYPE;
        }

        @Override
        public boolean eagerGlobalOrdinals() {
            return this.eagerGlobalOrdinals;
        }

        NamedAnalyzer normalizer() {
            return this.normalizer;
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.hasDocValues() && (blContext.fieldExtractPreference() != MappedFieldType.FieldExtractPreference.STORED || this.isSyntheticSourceEnabled())) {
                BlockLoaderFunctionConfig cfg = blContext.blockLoaderFunctionConfig();
                if (cfg == null) {
                    return new BytesRefsFromOrdsBlockLoader(this.name());
                }
                if (cfg.function() == BlockLoaderFunctionConfig.Function.LENGTH) {
                    return new Utf8CodePointsFromOrdsBlockLoader(((BlockLoaderFunctionConfig.JustWarnings)cfg).warnings(), this.name());
                }
                throw new UnsupportedOperationException("unknown fusion config [" + String.valueOf((Object)cfg.function()) + "]");
            }
            if (blContext.blockLoaderFunctionConfig() != null) {
                throw new UnsupportedOperationException("function fusing only supported for doc values");
            }
            if (this.isStored()) {
                return new BlockStoredFieldsReader.BytesFromBytesRefsBlockLoader(this.name());
            }
            if (this.isSyntheticSourceEnabled() && blContext.parentField(this.name()) == null) {
                return new FallbackSyntheticSourceBlockLoader(this, this.fallbackSyntheticSourceBlockLoaderReader(), this.name(), IgnoredSourceFieldMapper.ignoredSourceFormat(blContext.indexSettings().getIndexVersionCreated())){

                    @Override
                    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
                        return factory.bytesRefs(expectedCount);
                    }
                };
            }
            SourceValueFetcher fetcher = this.sourceValueFetcher(blContext.sourcePaths(this.name()), blContext.indexSettings());
            return new BlockSourceReader.BytesRefsBlockLoader(fetcher, this.sourceBlockLoaderLookup(blContext));
        }

        @Override
        public boolean supportsBlockLoaderConfig(BlockLoaderFunctionConfig config, MappedFieldType.FieldExtractPreference preference) {
            if (this.hasDocValues() && (preference != MappedFieldType.FieldExtractPreference.STORED || this.isSyntheticSourceEnabled())) {
                return config.function() == BlockLoaderFunctionConfig.Function.LENGTH;
            }
            return false;
        }

        private FallbackSyntheticSourceBlockLoader.Reader<?> fallbackSyntheticSourceBlockLoaderReader() {
            BytesRef nullValueBytes = this.nullValue != null ? new BytesRef((CharSequence)this.nullValue) : null;
            return new FallbackSyntheticSourceBlockLoader.SingleValueReader<BytesRef>((Object)nullValueBytes){

                @Override
                public void convertValue(Object value, List<BytesRef> accumulator) {
                    String stringValue = ((BytesRef)value).utf8ToString();
                    String adjusted = this.applyIgnoreAboveAndNormalizer(stringValue);
                    if (adjusted != null) {
                        accumulator.add(new BytesRef((CharSequence)adjusted));
                    }
                }

                @Override
                public void parseNonNullValue(XContentParser parser, List<BytesRef> accumulator) throws IOException {
                    assert (parser.currentToken() == XContentParser.Token.VALUE_STRING) : "Unexpected token " + String.valueOf(parser.currentToken());
                    String value = this.applyIgnoreAboveAndNormalizer(parser.text());
                    if (value != null) {
                        accumulator.add(new BytesRef((CharSequence)value));
                    }
                }

                @Override
                public void writeToBlock(List<BytesRef> values, BlockLoader.Builder blockBuilder) {
                    BlockLoader.BytesRefBuilder bytesRefBuilder = (BlockLoader.BytesRefBuilder)blockBuilder;
                    for (BytesRef value : values) {
                        bytesRefBuilder.appendBytesRef(value);
                    }
                }
            };
        }

        private BlockSourceReader.LeafIteratorLookup sourceBlockLoaderLookup(MappedFieldType.BlockLoaderContext blContext) {
            if (this.getTextSearchInfo().hasNorms()) {
                return BlockSourceReader.lookupFromNorms(this.name());
            }
            if (!this.hasDocValues() && (this.indexType.hasTerms() || this.isStored())) {
                return BlockSourceReader.lookupFromFieldNames(blContext.fieldNames(), this.name());
            }
            return BlockSourceReader.lookupMatchingAll();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            MappedFieldType.FielddataOperation operation = fieldDataContext.fielddataOperation();
            if (operation == MappedFieldType.FielddataOperation.SEARCH) {
                this.failIfNoDocValues();
                return this.fieldDataFromDocValues();
            }
            if (operation != MappedFieldType.FielddataOperation.SCRIPT) {
                throw new IllegalStateException("unknown operation [" + operation.name() + "]");
            }
            if (this.hasDocValues()) {
                return this.fieldDataFromDocValues();
            }
            if (this.isSyntheticSourceEnabled()) {
                if (!this.isStored()) {
                    throw new IllegalStateException("keyword field [" + this.name() + "] is only supported in synthetic _source index if it creates doc values or stored fields");
                }
                return (cache, breaker) -> new StoredFieldSortedBinaryIndexFieldData(this, this.name(), CoreValuesSourceType.KEYWORD, KeywordDocValuesField::new){

                    @Override
                    protected BytesRef storedToBytesRef(Object stored) {
                        return (BytesRef)stored;
                    }
                };
            }
            Set<String> sourcePaths = fieldDataContext.sourcePathsLookup().apply(this.name());
            return new SourceValueFetcherSortedBinaryIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, (ValueFetcher)this.sourceValueFetcher(sourcePaths, fieldDataContext.indexSettings()), (SourceProvider)fieldDataContext.lookupSupplier().get(), KeywordDocValuesField::new);
        }

        private SortedSetOrdinalsIndexFieldData.Builder fieldDataFromDocValues() {
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.KEYWORD, (dv, n) -> new KeywordDocValuesField(FieldData.toString(dv), n));
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, context);
            }
            return this.sourceValueFetcher(context.isSourceEnabled() ? context.sourcePath(this.name()) : Collections.emptySet(), context.getIndexSettings());
        }

        private SourceValueFetcher sourceValueFetcher(Set<String> sourcePaths, IndexSettings indexSettings) {
            return new SourceValueFetcher(sourcePaths, this.nullValue, indexSettings.getIgnoredSourceFormat()){

                @Override
                protected String parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    return this.applyIgnoreAboveAndNormalizer(keywordValue);
                }
            };
        }

        private String applyIgnoreAboveAndNormalizer(String value) {
            if (this.ignoreAbove.isIgnored(value)) {
                return null;
            }
            return KeywordFieldMapper.normalizeValue(this.normalizer(), this.name(), value);
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        protected BytesRef indexedValueForSearch(Object value) {
            if (this.getTextSearchInfo().searchAnalyzer() == Lucene.KEYWORD_ANALYZER) {
                return super.indexedValueForSearch(value);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return this.getTextSearchInfo().searchAnalyzer().normalize(this.name(), value.toString());
        }

        @Override
        public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.indexType.hasTerms()) {
                return super.wildcardQuery(value, method, caseInsensitive, true, context);
            }
            value = this.getTextSearchInfo().searchAnalyzer() != null ? KeywordFieldType.normalizeWildcardPattern(this.name(), value, (Analyzer)this.getTextSearchInfo().searchAnalyzer()) : this.indexedValueForSearch(value).utf8ToString();
            if (!caseInsensitive) {
                Term term = new Term(this.name(), value);
                return new WildcardQuery(term, 10000, MultiTermQuery.DOC_VALUES_REWRITE);
            }
            return new StringScriptFieldWildcardQuery(new Script(""), ctx -> new SortedSetDocValuesStringFieldScript(this.name(), context.lookup(), ctx), this.name(), value, caseInsensitive);
        }

        @Override
        public Query normalizedWildcardQuery(String value, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.indexType.hasTerms()) {
                return super.normalizedWildcardQuery(value, method, context);
            }
            value = this.getTextSearchInfo().searchAnalyzer() != null ? KeywordFieldType.normalizeWildcardPattern(this.name(), value, (Analyzer)this.getTextSearchInfo().searchAnalyzer()) : this.indexedValueForSearch(value).utf8ToString();
            Term term = new Term(this.name(), value);
            return new WildcardQuery(term, 10000, MultiTermQuery.DOC_VALUES_REWRITE);
        }

        @Override
        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.indexType.hasTerms()) {
                return super.regexpQuery(value, syntaxFlags, matchFlags, maxDeterminizedStates, method, context);
            }
            if (matchFlags != 0) {
                throw new IllegalArgumentException("Match flags not yet implemented [" + matchFlags + "]");
            }
            return new RegexpQuery(new Term(this.name(), this.indexedValueForSearch(value)), syntaxFlags, matchFlags, RegexpQuery.DEFAULT_PROVIDER, maxDeterminizedStates, MultiTermQuery.DOC_VALUES_REWRITE);
        }

        @Override
        public MappedFieldType.CollapseType collapseType() {
            return MappedFieldType.CollapseType.KEYWORD;
        }

        public Mapper.IgnoreAbove ignoreAbove() {
            return this.ignoreAbove;
        }

        @Override
        public boolean isDimension() {
            return this.isDimension;
        }

        @Override
        public boolean hasScriptValues() {
            return this.scriptValues != null;
        }

        public boolean hasNormalizer() {
            return this.normalizer != Lucene.KEYWORD_ANALYZER;
        }

        @Override
        public Query automatonQuery(Supplier<Automaton> automatonSupplier, Supplier<CharacterRunAutomaton> characterRunAutomatonSupplier, @Nullable MultiTermQuery.RewriteMethod method, SearchExecutionContext context, String description) {
            return new AutomatonQueryWithDescription(new Term(this.name()), automatonSupplier.get(), description);
        }
    }

    public static class KeywordField
    extends Field {
        public KeywordField(String field, BytesRef term, FieldType ft) {
            super(field, term, (IndexableFieldType)ft);
        }

        public InvertableType invertableType() {
            return InvertableType.BINARY;
        }
    }
}

