/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.script.DateFieldScript;

public class DateScriptBlockDocValuesReader
extends BlockDocValuesReader {
    private final DateFieldScript script;
    private int docId;

    DateScriptBlockDocValuesReader(DateFieldScript script) {
        this.script = script;
    }

    @Override
    public int docId() {
        return this.docId;
    }

    @Override
    public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
        try (BlockLoader.LongBuilder builder = factory.longs(docs.count() - offset);){
            for (int i = offset; i < docs.count(); ++i) {
                this.read(docs.get(i), builder);
            }
            BlockLoader.Block block = builder.build();
            return block;
        }
    }

    @Override
    public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
        this.docId = docId;
        this.read(docId, (BlockLoader.LongBuilder)builder);
    }

    private void read(int docId, BlockLoader.LongBuilder builder) {
        this.script.runForDoc(docId);
        switch (this.script.count()) {
            case 0: {
                builder.appendNull();
                break;
            }
            case 1: {
                builder.appendLong(this.script.values()[0]);
                break;
            }
            default: {
                builder.beginPositionEntry();
                for (int i = 0; i < this.script.count(); ++i) {
                    builder.appendLong(this.script.values()[i]);
                }
                builder.endPositionEntry();
            }
        }
    }

    @Override
    public String toString() {
        return "ScriptDates";
    }

    static class DateScriptBlockLoader
    extends BlockDocValuesReader.DocValuesBlockLoader {
        private final DateFieldScript.LeafFactory factory;

        DateScriptBlockLoader(DateFieldScript.LeafFactory factory) {
            this.factory = factory;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.longs(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            return new DateScriptBlockDocValuesReader(this.factory.newInstance(context));
        }
    }
}

