/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.bloomfilter;

import org.elasticsearch.common.util.ByteUtils;

public class BloomFilterHashFunctions {
    private BloomFilterHashFunctions() {
    }

    public static final class MurmurHash3 {
        public static final int DEFAULT_SEED = 104729;
        private static final long C1 = -8663945395140668459L;
        private static final long C2 = 5545529020109919103L;
        private static final int R1 = 31;
        private static final int R2 = 27;
        private static final int R3 = 33;
        private static final int M = 5;
        private static final int N1 = 1390208809;
        private static final int N2 = 944331445;

        private MurmurHash3() {
        }

        public static long hash64(byte[] data, int offset, int length) {
            long h1 = 104729L;
            long h2 = 104729L;
            int nblocks = length >> 4;
            for (int i = 0; i < nblocks; ++i) {
                int index = offset + (i << 4);
                long k1 = ByteUtils.readLongLE(data, index);
                long k2 = ByteUtils.readLongLE(data, index + 8);
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
                h1 = Long.rotateLeft(h1, 27);
                h1 += h2;
                h1 = h1 * 5L + 1390208809L;
                k2 *= 5545529020109919103L;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
                h2 = Long.rotateLeft(h2, 31);
                h2 += h1;
                h2 = h2 * 5L + 944331445L;
            }
            long k1 = 0L;
            long k2 = 0L;
            int index = offset + (nblocks << 4);
            switch (offset + length - index) {
                case 15: {
                    k2 ^= ((long)data[index + 14] & 0xFFL) << 48;
                }
                case 14: {
                    k2 ^= ((long)data[index + 13] & 0xFFL) << 40;
                }
                case 13: {
                    k2 ^= ((long)data[index + 12] & 0xFFL) << 32;
                }
                case 12: {
                    k2 ^= ((long)data[index + 11] & 0xFFL) << 24;
                }
                case 11: {
                    k2 ^= ((long)data[index + 10] & 0xFFL) << 16;
                }
                case 10: {
                    k2 ^= ((long)data[index + 9] & 0xFFL) << 8;
                }
                case 9: {
                    k2 ^= (long)(data[index + 8] & 0xFF);
                    k2 *= 5545529020109919103L;
                    k2 = Long.rotateLeft(k2, 33);
                    h2 ^= (k2 *= -8663945395140668459L);
                }
                case 8: {
                    k1 ^= ((long)data[index + 7] & 0xFFL) << 56;
                }
                case 7: {
                    k1 ^= ((long)data[index + 6] & 0xFFL) << 48;
                }
                case 6: {
                    k1 ^= ((long)data[index + 5] & 0xFFL) << 40;
                }
                case 5: {
                    k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
                }
                case 4: {
                    k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                }
                case 3: {
                    k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                }
                case 2: {
                    k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                }
                case 1: {
                    k1 ^= (long)(data[index] & 0xFF);
                    k1 *= -8663945395140668459L;
                    k1 = Long.rotateLeft(k1, 31);
                    h1 ^= (k1 *= 5545529020109919103L);
                }
            }
            h1 ^= (long)length;
            h1 += (h2 ^= (long)length);
            h2 += h1;
            h1 = MurmurHash3.fmix64(h1);
            h2 = MurmurHash3.fmix64(h2);
            return h1 += h2;
        }

        private static long fmix64(long hash) {
            hash ^= hash >>> 33;
            hash *= -49064778989728563L;
            hash ^= hash >>> 33;
            hash *= -4265267296055464877L;
            hash ^= hash >>> 33;
            return hash;
        }
    }
}

