/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.scheduler.SchedulerEngine;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.slm.SnapshotInvocationRecord;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicy;

public class SnapshotLifecyclePolicyMetadata
implements SimpleDiffable<SnapshotLifecyclePolicyMetadata>,
ToXContentObject {
    static final ParseField POLICY = new ParseField("policy", new String[0]);
    static final ParseField HEADERS = new ParseField("headers", new String[0]);
    static final ParseField VERSION = new ParseField("version", new String[0]);
    static final ParseField MODIFIED_DATE_MILLIS = new ParseField("modified_date_millis", new String[0]);
    static final ParseField MODIFIED_DATE = new ParseField("modified_date", new String[0]);
    static final ParseField LAST_SUCCESS = new ParseField("last_success", new String[0]);
    static final ParseField LAST_FAILURE = new ParseField("last_failure", new String[0]);
    static final ParseField INVOCATIONS_SINCE_LAST_SUCCESS = new ParseField("invocations_since_last_success", new String[0]);
    static final ParseField NEXT_EXECUTION_MILLIS = new ParseField("next_execution_millis", new String[0]);
    static final ParseField NEXT_EXECUTION = new ParseField("next_execution", new String[0]);
    private final SnapshotLifecyclePolicy policy;
    private final Map<String, String> headers;
    private final long version;
    private final long modifiedDate;
    @Nullable
    private final SnapshotInvocationRecord lastSuccess;
    @Nullable
    private final SnapshotInvocationRecord lastFailure;
    private final long invocationsSinceLastSuccess;
    public static final ConstructingObjectParser<SnapshotLifecyclePolicyMetadata, String> PARSER = new ConstructingObjectParser("snapshot_policy_metadata", a -> {
        SnapshotLifecyclePolicy policy = (SnapshotLifecyclePolicy)a[0];
        SnapshotInvocationRecord lastSuccess = (SnapshotInvocationRecord)a[4];
        SnapshotInvocationRecord lastFailure = (SnapshotInvocationRecord)a[5];
        return SnapshotLifecyclePolicyMetadata.builder().setPolicy(policy).setHeaders((Map)a[1]).setVersion((Long)a[2]).setModifiedDate((Long)a[3]).setLastSuccess(lastSuccess).setLastFailure(lastFailure).setInvocationsSinceLastSuccess(a[6] == null ? 0L : (Long)a[6]).build();
    });

    public static SnapshotLifecyclePolicyMetadata parse(XContentParser parser, String name) {
        return (SnapshotLifecyclePolicyMetadata)PARSER.apply(parser, (Object)name);
    }

    public SnapshotLifecyclePolicyMetadata(SnapshotLifecyclePolicy policy, Map<String, String> headers, long version, long modifiedDate, SnapshotInvocationRecord lastSuccess, SnapshotInvocationRecord lastFailure, long invocationsSinceLastSuccess) {
        this.policy = policy;
        this.headers = headers;
        ClientHelper.assertNoAuthorizationHeader(this.headers);
        this.version = version;
        this.modifiedDate = modifiedDate;
        this.lastSuccess = lastSuccess;
        this.lastFailure = lastFailure;
        this.invocationsSinceLastSuccess = invocationsSinceLastSuccess;
    }

    SnapshotLifecyclePolicyMetadata(StreamInput in) throws IOException {
        this.policy = new SnapshotLifecyclePolicy(in);
        this.headers = (Map)in.readGenericValue();
        ClientHelper.assertNoAuthorizationHeader(this.headers);
        this.version = in.readVLong();
        this.modifiedDate = in.readVLong();
        this.lastSuccess = (SnapshotInvocationRecord)in.readOptionalWriteable(SnapshotInvocationRecord::new);
        this.lastFailure = (SnapshotInvocationRecord)in.readOptionalWriteable(SnapshotInvocationRecord::new);
        this.invocationsSinceLastSuccess = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_4_0) ? in.readVLong() : 0L;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.policy.writeTo(out);
        out.writeGenericValue(this.headers);
        out.writeVLong(this.version);
        out.writeVLong(this.modifiedDate);
        out.writeOptionalWriteable((Writeable)this.lastSuccess);
        out.writeOptionalWriteable((Writeable)this.lastFailure);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_4_0)) {
            out.writeVLong(this.invocationsSinceLastSuccess);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SnapshotLifecyclePolicyMetadata metadata) {
        if (metadata == null) {
            return SnapshotLifecyclePolicyMetadata.builder();
        }
        return new Builder().setHeaders(metadata.getHeaders()).setPolicy(metadata.getPolicy()).setVersion(metadata.getVersion()).setModifiedDate(metadata.getModifiedDate()).setLastSuccess(metadata.getLastSuccess()).setLastFailure(metadata.getLastFailure()).setInvocationsSinceLastSuccess(metadata.getInvocationsSinceLastSuccess());
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public SnapshotLifecyclePolicy getPolicy() {
        return this.policy;
    }

    public String getId() {
        return this.policy.getId();
    }

    public long getVersion() {
        return this.version;
    }

    public long getModifiedDate() {
        return this.modifiedDate;
    }

    public SnapshotInvocationRecord getLastSuccess() {
        return this.lastSuccess;
    }

    public SnapshotInvocationRecord getLastFailure() {
        return this.lastFailure;
    }

    public long getInvocationsSinceLastSuccess() {
        return this.invocationsSinceLastSuccess;
    }

    public SchedulerEngine.Job buildSchedulerJob(String jobId) {
        return this.policy.buildSchedulerJob(jobId, this.modifiedDate);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(POLICY.getPreferredName(), (ToXContent)this.policy);
        builder.field(HEADERS.getPreferredName(), this.headers);
        builder.field(VERSION.getPreferredName(), this.version);
        builder.timestampFieldsFromUnixEpochMillis(MODIFIED_DATE_MILLIS.getPreferredName(), MODIFIED_DATE.getPreferredName(), this.modifiedDate);
        if (Objects.nonNull(this.lastSuccess)) {
            builder.field(LAST_SUCCESS.getPreferredName(), (ToXContent)this.lastSuccess);
        }
        if (Objects.nonNull(this.lastFailure)) {
            builder.field(LAST_FAILURE.getPreferredName(), (ToXContent)this.lastFailure);
        }
        builder.field(INVOCATIONS_SINCE_LAST_SUCCESS.getPreferredName(), this.invocationsSinceLastSuccess);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.policy, this.headers, this.version, this.modifiedDate, this.lastSuccess, this.lastFailure, this.invocationsSinceLastSuccess);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotLifecyclePolicyMetadata other = (SnapshotLifecyclePolicyMetadata)obj;
        return Objects.equals(this.policy, other.policy) && Objects.equals(this.headers, other.headers) && Objects.equals(this.version, other.version) && Objects.equals(this.modifiedDate, other.modifiedDate) && Objects.equals(this.lastSuccess, other.lastSuccess) && Objects.equals(this.lastFailure, other.lastFailure) && Objects.equals(this.invocationsSinceLastSuccess, other.invocationsSinceLastSuccess);
    }

    public String toString() {
        return super.toString();
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), SnapshotLifecyclePolicy::parse, POLICY);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), XContentParser::mapStrings, HEADERS, ObjectParser.ValueType.OBJECT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), VERSION);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MODIFIED_DATE_MILLIS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), SnapshotInvocationRecord::parse, LAST_SUCCESS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), SnapshotInvocationRecord::parse, LAST_FAILURE);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), INVOCATIONS_SINCE_LAST_SUCCESS);
    }

    public static class Builder {
        private SnapshotLifecyclePolicy policy;
        private Map<String, String> headers;
        private long version = 1L;
        private Long modifiedDate;
        private SnapshotInvocationRecord lastSuccessDate;
        private SnapshotInvocationRecord lastFailureDate;
        private long invocationsSinceLastSuccess = 0L;

        private Builder() {
        }

        public Builder setPolicy(SnapshotLifecyclePolicy policy) {
            this.policy = policy;
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setVersion(long version) {
            this.version = version;
            return this;
        }

        public Builder setModifiedDate(long modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public Builder setLastSuccess(SnapshotInvocationRecord lastSuccess) {
            this.lastSuccessDate = lastSuccess;
            return this;
        }

        public Builder setLastFailure(SnapshotInvocationRecord lastFailure) {
            this.lastFailureDate = lastFailure;
            return this;
        }

        public Builder setInvocationsSinceLastSuccess(long invocationsSinceLastSuccess) {
            this.invocationsSinceLastSuccess = invocationsSinceLastSuccess;
            return this;
        }

        public Builder incrementInvocationsSinceLastSuccess() {
            ++this.invocationsSinceLastSuccess;
            return this;
        }

        public SnapshotLifecyclePolicyMetadata build() {
            return new SnapshotLifecyclePolicyMetadata(Objects.requireNonNull(this.policy), Optional.ofNullable(this.headers).orElse(new HashMap()), this.version, Objects.requireNonNull(this.modifiedDate, "modifiedDate must be set"), this.lastSuccessDate, this.lastFailureDate, this.invocationsSinceLastSuccess);
        }
    }
}

