/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.HashMap;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.datastreams.TimeSeriesFeatureSetUsage;
import org.elasticsearch.xpack.core.ilm.DownsampleAction;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.SearchableSnapshotAction;
import org.elasticsearch.xpack.core.ilm.TimeseriesLifecycleType;

public class TimeSeriesUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final ProjectResolver projectResolver;
    private final boolean ilmAvailable;

    @Inject
    public TimeSeriesUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super(XPackUsageFeatureAction.TIME_SERIES_DATA_STREAMS.name(), transportService, clusterService, threadPool, actionFilters);
        this.projectResolver = projectResolver;
        this.ilmAvailable = !DataStreamLifecycle.isDataStreamsLifecycleOnlyMode((Settings)clusterService.getSettings());
    }

    protected void localClusterStateOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        ProjectMetadata projectMetadata = this.projectResolver.getProjectMetadata(state);
        IndexLifecycleMetadata ilmMetadata = (IndexLifecycleMetadata)projectMetadata.custom("index_lifecycle", (Metadata.ProjectCustom)IndexLifecycleMetadata.EMPTY);
        Map dataStreams = projectMetadata.dataStreams();
        long tsDataStreamCount = 0L;
        long tsIndexCount = 0L;
        IlmDownsamplingStatsTracker ilmStats = this.ilmAvailable ? new IlmDownsamplingStatsTracker() : null;
        DownsamplingStatsTracker dlmStats = new DownsamplingStatsTracker();
        HashMap<String, Long> indicesByInterval = new HashMap<String, Long>();
        for (DataStream ds : dataStreams.values()) {
            if (ds.getIndexMode() != IndexMode.TIME_SERIES) continue;
            ++tsDataStreamCount;
            Integer dlmRounds = ds.getDataLifecycle() == null || ds.getDataLifecycle().downsamplingRounds() == null ? null : Integer.valueOf(ds.getDataLifecycle().downsamplingRounds().size());
            for (Index backingIndex : ds.getIndices()) {
                String interval;
                IndexMetadata indexMetadata = projectMetadata.index(backingIndex);
                if (indexMetadata.getIndexMode() != IndexMode.TIME_SERIES) continue;
                ++tsIndexCount;
                if (ds.isIndexManagedByDataStreamLifecycle(indexMetadata.getIndex(), ignored -> indexMetadata) && dlmRounds != null) {
                    dlmStats.trackIndex(ds, indexMetadata);
                    dlmStats.trackRounds(dlmRounds, ds, indexMetadata);
                } else if (this.ilmAvailable && projectMetadata.isIndexManagedByILM(indexMetadata)) {
                    LifecyclePolicyMetadata policyMetadata = ilmMetadata.getPolicyMetadatas().get(indexMetadata.getLifecyclePolicyName());
                    if (policyMetadata == null) continue;
                    int rounds = 0;
                    for (Phase phase : policyMetadata.getPolicy().getPhases().values()) {
                        if (!phase.getActions().containsKey("downsample")) continue;
                        ++rounds;
                    }
                    if (rounds > 0) {
                        ilmStats.trackPolicy(policyMetadata.getPolicy());
                        ilmStats.trackIndex(ds, indexMetadata);
                        ilmStats.trackRounds(rounds, ds, indexMetadata);
                    }
                }
                if ((interval = indexMetadata.getSettings().get(IndexMetadata.INDEX_DOWNSAMPLE_INTERVAL.getKey())) == null) continue;
                Long count = indicesByInterval.computeIfAbsent(interval, ignored -> 0L);
                indicesByInterval.put(interval, count + 1L);
            }
        }
        TimeSeriesFeatureSetUsage usage = this.ilmAvailable ? new TimeSeriesFeatureSetUsage(tsDataStreamCount, tsIndexCount, ilmStats.getDownsamplingStats(), ilmStats.calculateIlmPolicyStats(), dlmStats.getDownsamplingStats(), indicesByInterval) : new TimeSeriesFeatureSetUsage(tsDataStreamCount, tsIndexCount, dlmStats.getDownsamplingStats(), indicesByInterval);
        listener.onResponse((Object)new XPackUsageFeatureResponse(usage));
    }

    static class IlmDownsamplingStatsTracker
    extends DownsamplingStatsTracker {
        private final Map<String, Map<String, Phase>> policies = new HashMap<String, Map<String, Phase>>();

        IlmDownsamplingStatsTracker() {
        }

        void trackPolicy(LifecyclePolicy ilmPolicy) {
            this.policies.putIfAbsent(ilmPolicy.getName(), ilmPolicy.getPhases());
        }

        TimeSeriesFeatureSetUsage.IlmPolicyStats calculateIlmPolicyStats() {
            if (this.policies.isEmpty()) {
                return TimeSeriesFeatureSetUsage.IlmPolicyStats.EMPTY;
            }
            long forceMergeExplicitlyEnabledCounter = 0L;
            long forceMergeExplicitlyDisabledCounter = 0L;
            long forceMergeDefaultCounter = 0L;
            long downsampledForceMergeNeededCounter = 0L;
            HashMap<String, Long> downsamplingPhases = new HashMap<String, Long>();
            for (String ilmPolicy : this.policies.keySet()) {
                Map<String, Phase> phases = this.policies.get(ilmPolicy);
                boolean downsampledForceMergeNeeded = false;
                for (String phase : TimeseriesLifecycleType.ORDERED_VALID_PHASES) {
                    if (!phases.containsKey(phase)) continue;
                    Map<String, LifecycleAction> actions = phases.get(phase).getActions();
                    if (actions.containsKey("downsample")) {
                        Long current = downsamplingPhases.computeIfAbsent(phase, ignored -> 0L);
                        downsamplingPhases.put(phase, current + 1L);
                        DownsampleAction downsampleAction = (DownsampleAction)actions.get("downsample");
                        if (downsampleAction.forceMergeIndex() == null) {
                            ++forceMergeDefaultCounter;
                            downsampledForceMergeNeeded = true;
                        } else if (downsampleAction.forceMergeIndex().booleanValue()) {
                            ++forceMergeExplicitlyEnabledCounter;
                        } else {
                            ++forceMergeExplicitlyDisabledCounter;
                        }
                    }
                    if (actions.containsKey("forcemerge")) {
                        downsampledForceMergeNeeded = false;
                    }
                    if (!downsampledForceMergeNeeded || !actions.containsKey("searchable_snapshot")) continue;
                    SearchableSnapshotAction searchableSnapshotAction = (SearchableSnapshotAction)actions.get("searchable_snapshot");
                    if (!searchableSnapshotAction.isForceMergeIndex()) {
                        ++downsampledForceMergeNeededCounter;
                    }
                    downsampledForceMergeNeeded = false;
                }
            }
            return new TimeSeriesFeatureSetUsage.IlmPolicyStats(downsamplingPhases, forceMergeExplicitlyEnabledCounter, forceMergeExplicitlyDisabledCounter, forceMergeDefaultCounter, downsampledForceMergeNeededCounter);
        }
    }

    private static class DownsamplingStatsTracker {
        private long downsampledDataStreams = 0L;
        private long downsampledIndices = 0L;
        private final LongSummaryStatistics rounds = new LongSummaryStatistics();

        private DownsamplingStatsTracker() {
        }

        void trackIndex(DataStream ds, IndexMetadata indexMetadata) {
            if (Objects.equals(indexMetadata.getIndex(), ds.getWriteIndex())) {
                ++this.downsampledDataStreams;
            }
            ++this.downsampledIndices;
        }

        void trackRounds(int rounds, DataStream ds, IndexMetadata indexMetadata) {
            if (Objects.equals(indexMetadata.getIndex(), ds.getWriteIndex())) {
                this.rounds.accept(rounds);
            }
        }

        TimeSeriesFeatureSetUsage.DownsamplingFeatureStats getDownsamplingStats() {
            return new TimeSeriesFeatureSetUsage.DownsamplingFeatureStats(this.downsampledDataStreams, this.downsampledIndices, this.rounds.getMin(), this.rounds.getAverage(), this.rounds.getMax());
        }
    }
}

