/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.compute.Describable;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.TimeSeriesGroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.aggregation.blockhash.BytesRefLongBlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.HashAggregationOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.index.mapper.DateFieldMapper;

public class TimeSeriesAggregationOperator
extends HashAggregationOperator {
    private final Rounding.Prepared timeBucket;
    private final DateFieldMapper.Resolution timeResolution;

    public TimeSeriesAggregationOperator(Rounding.Prepared timeBucket, DateFieldMapper.Resolution timeResolution, List<GroupingAggregator.Factory> aggregators, Supplier<BlockHash> blockHash, DriverContext driverContext) {
        super(aggregators, blockHash, driverContext);
        this.timeBucket = timeBucket;
        this.timeResolution = timeResolution;
    }

    @Override
    protected GroupingAggregatorEvaluationContext evaluationContext(BlockHash blockHash, Block[] keys) {
        if (keys.length < 2) {
            return super.evaluationContext(blockHash, keys);
        }
        final BytesRefLongBlockHash hash = (BytesRefLongBlockHash)blockHash;
        final LongBlock timestamps = keys[0].elementType() == ElementType.LONG ? (LongBlock)keys[0] : (LongBlock)keys[1];
        return new TimeSeriesGroupingAggregatorEvaluationContext(this.driverContext){

            @Override
            public long rangeStartInMillis(int groupId) {
                return TimeSeriesAggregationOperator.this.timeResolution.roundDownToMillis(timestamps.getLong(groupId));
            }

            @Override
            public long rangeEndInMillis(int groupId) {
                return TimeSeriesAggregationOperator.this.timeResolution.roundDownToMillis(TimeSeriesAggregationOperator.this.timeBucket.nextRoundingValue(timestamps.getLong(groupId)));
            }

            @Override
            public List<Integer> groupIdsFromWindow(int startingGroupId, Duration window) {
                long ordinal = hash.getBytesRefKeyFromGroup(startingGroupId);
                long startTimestamp = hash.getLongKeyFromGroup(startingGroupId);
                ArrayList<Integer> results = new ArrayList<Integer>();
                results.add(startingGroupId);
                long endTimestamp = startTimestamp + TimeSeriesAggregationOperator.this.timeResolution.convert(window.toMillis());
                long nextTimestamp = startTimestamp;
                while ((nextTimestamp = TimeSeriesAggregationOperator.this.timeBucket.nextRoundingValue(nextTimestamp)) < endTimestamp) {
                    long nextGroupId = hash.getGroupId(ordinal, nextTimestamp);
                    if (nextGroupId == -1L) continue;
                    results.add(Math.toIntExact(nextGroupId));
                }
                assert (nextTimestamp == endTimestamp) : "expected to end at the original timestamp bucket";
                return results;
            }
        };
    }

    public record Factory(Rounding.Prepared timeBucket, boolean dateNanos, List<BlockHash.GroupSpec> groups, AggregatorMode aggregatorMode, List<GroupingAggregator.Factory> aggregators, int maxPageSize) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new TimeSeriesAggregationOperator(this.timeBucket, this.dateNanos ? DateFieldMapper.Resolution.NANOSECONDS : DateFieldMapper.Resolution.MILLISECONDS, this.aggregators, () -> BlockHash.build(this.groups, driverContext.blockFactory(), this.maxPageSize, true), driverContext);
        }

        @Override
        public String describe() {
            return "TimeSeriesAggregationOperator[mode = <not-needed>, aggs = " + this.aggregators.stream().map(Describable::describe).collect(Collectors.joining(", ")) + "]";
        }
    }
}

