/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene.read;

import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefVector;
import org.elasticsearch.compute.lucene.read.SingletonBytesRefBuilder;
import org.elasticsearch.compute.lucene.read.SingletonDoubleBuilder;
import org.elasticsearch.compute.lucene.read.SingletonIntBuilder;
import org.elasticsearch.compute.lucene.read.SingletonLongBuilder;
import org.elasticsearch.compute.lucene.read.SingletonOrdinalsBuilder;
import org.elasticsearch.compute.lucene.read.SortedSetOrdinalsBuilder;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.BlockLoader;

public abstract class DelegatingBlockLoaderFactory
implements BlockLoader.BlockFactory {
    protected final BlockFactory factory;

    protected DelegatingBlockLoaderFactory(BlockFactory factory) {
        this.factory = factory;
    }

    public void adjustBreaker(long delta) throws CircuitBreakingException {
        this.factory.adjustBreaker(delta);
    }

    public BlockLoader.BooleanBuilder booleansFromDocValues(int expectedCount) {
        return this.factory.newBooleanBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.SORTED_ASCENDING);
    }

    public BlockLoader.BooleanBuilder booleans(int expectedCount) {
        return this.factory.newBooleanBlockBuilder(expectedCount);
    }

    public BlockLoader.BytesRefBuilder bytesRefsFromDocValues(int expectedCount) {
        return this.factory.newBytesRefBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
    }

    public BlockLoader.BytesRefBuilder bytesRefs(int expectedCount) {
        return this.factory.newBytesRefBlockBuilder(expectedCount);
    }

    public BlockLoader.SingletonBytesRefBuilder singletonBytesRefs(int expectedCount) {
        return new SingletonBytesRefBuilder(expectedCount, this.factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesRefBlock constantBytes(BytesRef value, int count) {
        OrdinalBytesRefBlock ordinalBytesRefBlock;
        block4: {
            if (count == 1) {
                return this.factory.newConstantBytesRefBlockWith(value, count);
            }
            BytesRefVector dict = null;
            IntVector ordinals = null;
            boolean success = false;
            try {
                dict = this.factory.newConstantBytesRefVector(value, 1);
                ordinals = this.factory.newConstantIntVector(0, count);
                OrdinalBytesRefBlock result = new OrdinalBytesRefVector(ordinals, dict).asBlock();
                success = true;
                ordinalBytesRefBlock = result;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{dict, ordinals});
                }
                throw throwable;
            }
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{dict, ordinals});
        }
        return ordinalBytesRefBlock;
    }

    public BlockLoader.Block constantInt(int value, int count) {
        return this.factory.newConstantIntVector(value, count).asBlock();
    }

    public BlockLoader.DoubleBuilder doublesFromDocValues(int expectedCount) {
        return this.factory.newDoubleBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.SORTED_ASCENDING);
    }

    public BlockLoader.DoubleBuilder doubles(int expectedCount) {
        return this.factory.newDoubleBlockBuilder(expectedCount);
    }

    public BlockLoader.FloatBuilder denseVectors(int expectedVectorsCount, int dimensions) {
        return this.factory.newFloatBlockBuilder(expectedVectorsCount * dimensions);
    }

    public BlockLoader.IntBuilder intsFromDocValues(int expectedCount) {
        return this.factory.newIntBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.SORTED_ASCENDING);
    }

    public BlockLoader.IntBuilder ints(int expectedCount) {
        return this.factory.newIntBlockBuilder(expectedCount);
    }

    public BlockLoader.LongBuilder longsFromDocValues(int expectedCount) {
        return this.factory.newLongBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.SORTED_ASCENDING);
    }

    public BlockLoader.LongBuilder longs(int expectedCount) {
        return this.factory.newLongBlockBuilder(expectedCount);
    }

    public BlockLoader.SingletonLongBuilder singletonLongs(int expectedCount) {
        return new SingletonLongBuilder(expectedCount, this.factory);
    }

    public BlockLoader.SingletonIntBuilder singletonInts(int expectedCount) {
        return new SingletonIntBuilder(expectedCount, this.factory);
    }

    public BlockLoader.SingletonDoubleBuilder singletonDoubles(int expectedCount) {
        return new SingletonDoubleBuilder(expectedCount, this.factory);
    }

    public BlockLoader.Builder nulls(int expectedCount) {
        return ElementType.NULL.newBlockBuilder(expectedCount, this.factory);
    }

    public BlockLoader.SingletonOrdinalsBuilder singletonOrdinalsBuilder(SortedDocValues ordinals, int count, boolean isDense) {
        return new SingletonOrdinalsBuilder(this.factory, ordinals, count, isDense);
    }

    public BlockLoader.SortedSetOrdinalsBuilder sortedSetOrdinalsBuilder(SortedSetDocValues ordinals, int count) {
        return new SortedSetOrdinalsBuilder(this.factory, ordinals, count);
    }

    public BlockLoader.AggregateMetricDoubleBuilder aggregateMetricDoubleBuilder(int count) {
        return this.factory.newAggregateMetricDoubleBlockBuilder(count);
    }

    public BlockLoader.Block buildAggregateMetricDoubleDirect(BlockLoader.Block minBlock, BlockLoader.Block maxBlock, BlockLoader.Block sumBlock, BlockLoader.Block countBlock) {
        return this.factory.newAggregateMetricDoubleBlockFromDocValues((DoubleBlock)minBlock, (DoubleBlock)maxBlock, (DoubleBlock)sumBlock, (IntBlock)countBlock);
    }

    public BlockLoader.ExponentialHistogramBuilder exponentialHistogramBlockBuilder(int count) {
        return this.factory.newExponentialHistogramBlockBuilder(count);
    }

    public BlockLoader.Block buildExponentialHistogramBlockDirect(BlockLoader.Block minima, BlockLoader.Block maxima, BlockLoader.Block sums, BlockLoader.Block valueCounts, BlockLoader.Block zeroThresholds, BlockLoader.Block encodedHistograms) {
        return this.factory.newExponentialHistogramBlockFromDocValues((DoubleBlock)minima, (DoubleBlock)maxima, (DoubleBlock)sums, (LongBlock)valueCounts, (DoubleBlock)zeroThresholds, (BytesRefBlock)encodedHistograms);
    }
}

